/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.sequence;

import adams.data.sequence.XYSequence;
import adams.data.sequence.XYSequencePoint;
import adams.gui.event.PaintEvent;
import adams.gui.visualization.core.AxisPanel;
import adams.gui.visualization.core.plot.Axis;
import adams.gui.visualization.sequence.LinePaintlet;
import java.awt.Color;
import java.awt.Graphics;
import java.util.List;

public class IncrementalSumPaintlet
extends LinePaintlet {
    private static final long serialVersionUID = 8242948176244747138L;

    @Override
    public String globalInfo() {
        return "Paintlet that sums up the individual Y values of a sequence and plots these data points as line. The data points represent percentages and are scaled to the maximum on the Y axis, in order to be visible in the plot.";
    }

    @Override
    protected void drawData(Graphics g, PaintEvent.PaintMoment moment, XYSequence data, Color color, LinePaintlet.MarkerShape marker) {
        XYSequencePoint curr;
        int i;
        AxisPanel axisY = this.getPanel().getPlot().getAxis(Axis.LEFT);
        List points = data.toList();
        XYSequence newList = (XYSequence)data.getHeader();
        double sum = 0.0;
        for (i = 0; i < points.size(); ++i) {
            curr = (XYSequencePoint)points.get(i);
            XYSequencePoint newPoint = (XYSequencePoint)curr.getClone();
            newPoint.setY(sum += curr.getY() - axisY.getMinimum());
            newList.add(newPoint);
        }
        points = newList.toList();
        if (sum == 0.0) {
            sum = 1.0E7;
        }
        double factor = 1.0 / sum * (axisY.getMaximum() - axisY.getMinimum());
        for (i = 0; i < points.size(); ++i) {
            curr = (XYSequencePoint)points.get(i);
            curr.setY((curr.getY() - axisY.getMinimum()) * factor + axisY.getMinimum());
        }
        super.drawData(g, moment, newList, color, marker);
    }
}

