/*
 * Decompiled with CFR 0.152.
 */
package adams.data.conversion;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.data.conversion.AbstractConversion;
import adams.data.conversion.mapobject.AbstractMapObjectGenerator;
import adams.data.conversion.mapobject.SimpleCircleMarkerGenerator;
import adams.data.spreadsheet.SpreadSheet;
import org.openstreetmap.gui.jmapviewer.interfaces.MapObject;

public class SpreadSheetToMapObjects
extends AbstractConversion {
    private static final long serialVersionUID = -5361157360265877867L;
    protected AbstractMapObjectGenerator m_Generator;

    public String globalInfo() {
        return "Creates features from the incoming spreadsheet and turns them into OpenStreetMap MapObjects.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("generator", "generator", (Object)new SimpleCircleMarkerGenerator());
    }

    public void setGenerator(AbstractMapObjectGenerator value) {
        this.m_Generator = value;
        this.reset();
    }

    public AbstractMapObjectGenerator getGenerator() {
        return this.m_Generator;
    }

    public String generatorTipText() {
        return "The generator to use for turning the spreadsheet into MapObjects.";
    }

    public String getQuickInfo() {
        return QuickInfoHelper.toString((OptionHandler)this, (String)"generator", (Object)((Object)this.m_Generator));
    }

    public Class accepts() {
        return SpreadSheet.class;
    }

    public Class generates() {
        if (this.m_Generator == null) {
            return MapObject[].class;
        }
        return this.m_Generator.generates();
    }

    protected Object doConvert() throws Exception {
        SpreadSheet sheet = (SpreadSheet)this.m_Input;
        MapObject[] result = this.m_Generator.generate(sheet);
        return result;
    }
}

