/*
 * Decompiled with CFR 0.152.
 */
package adams.data.mapobject;

import adams.core.License;
import adams.core.annotation.MixedCopyright;
import adams.data.mapobject.AbstractMapObject;
import adams.data.mapobject.HitIndicator;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import org.openstreetmap.gui.jmapviewer.Coordinate;
import org.openstreetmap.gui.jmapviewer.JMapViewer;
import org.openstreetmap.gui.jmapviewer.Layer;
import org.openstreetmap.gui.jmapviewer.Style;
import org.openstreetmap.gui.jmapviewer.interfaces.MapMarker;

@MixedCopyright(copyright="2008 OpenStreetMap", author="Jan Peter Stotz", license=License.GPL2, url="http://svn.openstreetmap.org/applications/viewer/jmapviewer/releases/1.02/JMapViewer-1.02-Source.zip", note="Original class: org.openstreetmap.gui.jmapviewer.MapMarkerCircle")
public class SimpleMapMarkerCircle
extends AbstractMapObject
implements MapMarker,
HitIndicator {
    protected Coordinate coord;
    protected double radius;
    protected MapMarker.STYLE markerStyle;
    protected int radiusPixels;

    public SimpleMapMarkerCircle(Coordinate coord, double radius) {
        this(null, null, coord, radius);
    }

    public SimpleMapMarkerCircle(String name, Coordinate coord, double radius) {
        this(null, name, coord, radius);
    }

    public SimpleMapMarkerCircle(Layer layer, Coordinate coord, double radius) {
        this(layer, null, coord, radius);
    }

    public SimpleMapMarkerCircle(double lat, double lon, double radius) {
        this(null, null, new Coordinate(lat, lon), radius);
    }

    public SimpleMapMarkerCircle(Layer layer, double lat, double lon, double radius) {
        this(layer, null, new Coordinate(lat, lon), radius);
    }

    public SimpleMapMarkerCircle(Layer layer, String name, Coordinate coord, double radius) {
        this(layer, name, coord, radius, MapMarker.STYLE.VARIABLE, SimpleMapMarkerCircle.getDefaultStyle());
    }

    public SimpleMapMarkerCircle(Layer layer, String name, Coordinate coord, double radius, MapMarker.STYLE markerStyle, Style style) {
        super(layer, name, style);
        this.markerStyle = markerStyle;
        this.coord = coord;
        this.radius = radius;
        this.radiusPixels = -1;
    }

    public Coordinate getCoordinate() {
        return this.coord;
    }

    public double getLat() {
        return this.coord.getLat();
    }

    public double getLon() {
        return this.coord.getLon();
    }

    public void setRadius(double value) {
        this.radius = value;
    }

    public double getRadius() {
        return this.radius;
    }

    public MapMarker.STYLE getMarkerStyle() {
        return this.markerStyle;
    }

    public void paint(Graphics g, Point position, int radio) {
        int size_h = radio;
        int size = size_h * 2;
        this.radiusPixels = radio;
        if (g instanceof Graphics2D && this.getBackColor() != null) {
            Graphics2D g2 = (Graphics2D)g;
            Composite oldComposite = g2.getComposite();
            g2.setComposite(AlphaComposite.getInstance(3));
            g2.setPaint(this.getBackColor());
            g.fillOval(position.x - size_h, position.y - size_h, size, size);
            g2.setComposite(oldComposite);
        }
        g.setColor(this.getColor());
        g.drawOval(position.x - size_h, position.y - size_h, size, size);
        if (this.getLayer() == null || this.getLayer().isVisibleTexts().booleanValue()) {
            this.paintText(g, position);
        }
    }

    public static Style getDefaultStyle() {
        return new Style(Color.ORANGE, new Color(100, 100, 100, 50), null, SimpleMapMarkerCircle.getDefaultFont());
    }

    public void setLat(double lat) {
        if (this.coord == null) {
            this.coord = new Coordinate(lat, 0.0);
        } else {
            this.coord.setLat(lat);
        }
    }

    public void setLon(double lon) {
        if (this.coord == null) {
            this.coord = new Coordinate(0.0, lon);
        } else {
            this.coord.setLon(lon);
        }
    }

    @Override
    public boolean isHit(JMapViewer viewer, Coordinate coord) {
        Point pos = viewer.getMapPosition(coord);
        Point center = viewer.getMapPosition(this.getCoordinate());
        if (pos != null && center != null) {
            return Math.pow(pos.x - center.x, 2.0) + Math.pow(pos.y - center.y, 2.0) < (double)(this.radiusPixels * this.radiusPixels);
        }
        return false;
    }

    public String toString() {
        return "MarkerCircle: name=" + this.getName() + ", coord=" + this.getCoordinate() + ", meta=" + this.getMetaData();
    }
}

