/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.sink.openstreetmapviewer;

import adams.flow.sink.OpenStreetMapViewer;
import adams.flow.sink.openstreetmapviewer.AbstractPositionableMapOverlayWithDimensions;
import java.awt.Color;
import java.awt.Graphics;

public class RectangleMapOverlay
extends AbstractPositionableMapOverlayWithDimensions {
    private static final long serialVersionUID = 805661569976845842L;
    protected boolean m_BorderEnabled;
    protected Color m_BorderColor;
    protected boolean m_FillEnabled;
    protected Color m_FillColor;

    public String globalInfo() {
        return "Paints a rectangle at the specified location.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("border-enabled", "borderEnabled", (Object)true);
        this.m_OptionManager.add("border-color", "borderColor", (Object)Color.BLACK);
        this.m_OptionManager.add("fill-enabled", "fillEnabled", (Object)true);
        this.m_OptionManager.add("fill-color", "fillColor", (Object)new Color(100, 100, 100, 50));
    }

    @Override
    protected int getDefaultHeight() {
        return 20;
    }

    @Override
    public String heightTipText() {
        return "The height of the rectangle.";
    }

    @Override
    protected int getDefaultWidth() {
        return 100;
    }

    @Override
    public String widthTipText() {
        return "The width of the rectangle.";
    }

    public void setBorderEnabled(boolean value) {
        this.m_BorderEnabled = value;
        this.reset();
    }

    public boolean getBorderEnabled() {
        return this.m_BorderEnabled;
    }

    public String borderEnabledTipText() {
        return "If enabled, the border gets painted.";
    }

    public void setBorderColor(Color value) {
        this.m_BorderColor = value;
        this.reset();
    }

    public Color getBorderColor() {
        return this.m_BorderColor;
    }

    public String borderColorTipText() {
        return "The color of the border.";
    }

    public void setFillEnabled(boolean value) {
        this.m_FillEnabled = value;
        this.reset();
    }

    public boolean getFillEnabled() {
        return this.m_FillEnabled;
    }

    public String fillEnabledTipText() {
        return "If enabled, the rectangle gets filled.";
    }

    public void setFillColor(Color value) {
        this.m_FillColor = value;
        this.reset();
    }

    public Color getFillColor() {
        return this.m_FillColor;
    }

    public String fillColorTipText() {
        return "The fill color.";
    }

    @Override
    protected void doPaintOverlay(OpenStreetMapViewer viewer, Graphics g, int x, int y) {
        if (this.m_FillEnabled) {
            g.setColor(this.m_FillColor);
            g.fillRect(x, y - this.m_Height, this.m_Width, this.m_Height);
        }
        if (this.m_BorderEnabled) {
            g.setColor(this.m_BorderColor);
            g.drawRect(x, y - this.m_Height, this.m_Width, this.m_Height);
        }
    }
}

