/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.timeseries.eval;

import java.util.ArrayList;
import java.util.List;
import weka.classifiers.evaluation.NumericPrediction;
import weka.classifiers.timeseries.eval.TSEvalModule;
import weka.core.Instance;
import weka.core.Utils;

public class ErrorModule
extends TSEvalModule {
    protected List<List<NumericPrediction>> m_predictions;
    protected double[] m_counts;

    @Override
    public void reset() {
        if (this.m_targetFieldNames != null) {
            this.m_predictions = new ArrayList<List<NumericPrediction>>();
            this.m_counts = new double[this.m_targetFieldNames.size()];
            for (int i = 0; i < this.m_targetFieldNames.size(); ++i) {
                ArrayList predsForTarget = new ArrayList();
                this.m_predictions.add(predsForTarget);
            }
        }
    }

    @Override
    public String getEvalName() {
        return "Error";
    }

    @Override
    public String getDescription() {
        return "Sum of errors";
    }

    @Override
    public String getDefinition() {
        return "sum(predicted - actual)";
    }

    public String toString() {
        return this.getDescription() + " (" + this.getEvalName() + ")";
    }

    @Override
    public void evaluateForInstance(List<NumericPrediction> forecasts, Instance inst) throws Exception {
        if (this.m_predictions == null) {
            throw new Exception("Target fields haven't been set yet!");
        }
        if (forecasts.size() != this.m_targetFieldNames.size()) {
            throw new Exception("The number of forecasted values does not match the number of target fields!");
        }
        for (int i = 0; i < this.m_targetFieldNames.size(); ++i) {
            double actualValue = this.getTargetValue((String)this.m_targetFieldNames.get(i), inst);
            double predictedValue = forecasts.get(i).predicted();
            double[][] intervals = forecasts.get(i).predictionIntervals();
            NumericPrediction pred = new NumericPrediction(actualValue, predictedValue, 1.0, intervals);
            this.m_predictions.get(i).add(pred);
            if (Utils.isMissingValue((double)predictedValue) || Utils.isMissingValue((double)actualValue)) continue;
            int n = i;
            this.m_counts[n] = this.m_counts[n] + 1.0;
        }
    }

    @Override
    public double[] calculateMeasure() throws Exception {
        if (this.m_predictions == null || this.m_predictions.get(0).size() == 0) {
            throw new Exception("No predictions have been seen yet!");
        }
        double[] result = new double[this.m_targetFieldNames.size()];
        for (int i = 0; i < this.m_targetFieldNames.size(); ++i) {
            List<NumericPrediction> preds = this.m_predictions.get(i);
            double sumOfE = 0.0;
            for (NumericPrediction p : preds) {
                if (Utils.isMissingValue((double)p.error())) continue;
                sumOfE += p.error();
            }
            result[i] = sumOfE;
        }
        return result;
    }

    public double[] countsForTargets() throws Exception {
        if (this.m_predictions == null || this.m_predictions.get(0).size() == 0) {
            throw new Exception("No predictions have been seen yet!");
        }
        return this.m_counts;
    }

    public List<Double> getErrorsForTarget(String targetName) throws IllegalArgumentException {
        for (int i = 0; i < this.m_targetFieldNames.size(); ++i) {
            if (!((String)this.m_targetFieldNames.get(i)).equals(targetName)) continue;
            ArrayList<Double> errors = new ArrayList<Double>();
            List<NumericPrediction> preds = this.m_predictions.get(i);
            for (int j = 0; j < preds.size(); ++j) {
                Double err = new Double(preds.get(j).error());
                errors.add(err);
            }
            return errors;
        }
        throw new IllegalArgumentException("Unknown target: " + targetName);
    }

    public List<NumericPrediction> getPredictionsForTarget(String targetName) throws IllegalArgumentException {
        for (int i = 0; i < this.m_targetFieldNames.size(); ++i) {
            if (!((String)this.m_targetFieldNames.get(i)).equals(targetName)) continue;
            return this.m_predictions.get(i);
        }
        throw new IllegalArgumentException("Unknown target: " + targetName);
    }

    public List<List<NumericPrediction>> getPredictionsForAllTargets() {
        return this.m_predictions;
    }

    @Override
    public String toSummaryString() throws Exception {
        StringBuffer result = new StringBuffer();
        double[] measures = this.calculateMeasure();
        for (int i = 0; i < this.m_targetFieldNames.size(); ++i) {
            result.append(this.getDescription() + " (" + (String)this.m_targetFieldNames.get(i) + "): " + Utils.doubleToString((double)measures[i], (int)4) + " (n = " + this.m_counts[i] + ")");
            result.append("\n");
        }
        return result.toString();
    }
}

