/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.timeseries.eval;

import java.util.ArrayList;
import java.util.List;
import weka.classifiers.evaluation.NumericPrediction;
import weka.classifiers.timeseries.eval.DACModule;
import weka.classifiers.timeseries.eval.ErrorModule;
import weka.classifiers.timeseries.eval.MAEModule;
import weka.classifiers.timeseries.eval.MAPEModule;
import weka.classifiers.timeseries.eval.MSEModule;
import weka.classifiers.timeseries.eval.RAEModule;
import weka.classifiers.timeseries.eval.RMSEModule;
import weka.classifiers.timeseries.eval.RRSEModule;
import weka.core.Instance;
import weka.core.Utils;

public abstract class TSEvalModule {
    protected List<String> m_targetFieldNames;

    public static List<TSEvalModule> getModuleList() {
        ArrayList<TSEvalModule> result = new ArrayList<TSEvalModule>();
        result.add(new ErrorModule());
        result.add(new MAEModule());
        result.add(new MSEModule());
        result.add(new RMSEModule());
        result.add(new MAPEModule());
        result.add(new DACModule());
        result.add(new RAEModule());
        result.add(new RRSEModule());
        return result;
    }

    public static TSEvalModule getModule(String moduleName) throws IllegalArgumentException {
        if (moduleName.equalsIgnoreCase("Error")) {
            return new ErrorModule();
        }
        if (moduleName.equalsIgnoreCase("MAE")) {
            return new MAEModule();
        }
        if (moduleName.equalsIgnoreCase("MSE")) {
            return new MSEModule();
        }
        if (moduleName.equalsIgnoreCase("RMSE")) {
            return new RMSEModule();
        }
        if (moduleName.equalsIgnoreCase("MAPE")) {
            return new MAPEModule();
        }
        if (moduleName.equalsIgnoreCase("DAC")) {
            return new DACModule();
        }
        if (moduleName.equalsIgnoreCase("RAE")) {
            return new RAEModule();
        }
        if (moduleName.equalsIgnoreCase("RRSE")) {
            return new RRSEModule();
        }
        try {
            Object candidateModule = Class.forName(moduleName).newInstance();
            if (candidateModule instanceof TSEvalModule) {
                return (TSEvalModule)candidateModule;
            }
        }
        catch (InstantiationException e) {
            throw new IllegalArgumentException("Unable to instantiate " + moduleName);
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException("Unknown evaluation moduel " + moduleName);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("Unable to instantiate " + moduleName);
        }
        throw new IllegalArgumentException("Unknown evaluation moduel " + moduleName);
    }

    public abstract void reset();

    public abstract String getEvalName();

    public abstract String getDescription();

    public abstract String getDefinition();

    public abstract void evaluateForInstance(List<NumericPrediction> var1, Instance var2) throws Exception;

    public abstract double[] calculateMeasure() throws Exception;

    public abstract String toSummaryString() throws Exception;

    public void setTargetFields(List<String> targets) {
        this.m_targetFieldNames = targets;
        this.reset();
    }

    public List<String> getTargetFields() {
        return this.m_targetFieldNames;
    }

    protected double getTargetValue(String targetName, Instance inst) {
        if (inst == null) {
            return Utils.missingValue();
        }
        int targetIndex = inst.dataset().attribute(targetName).index();
        return inst.value(targetIndex);
    }
}

