/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.timeseries.eval;

import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.MethodDescriptor;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintStream;
import java.io.Reader;
import java.lang.reflect.Method;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JPanel;
import weka.classifiers.evaluation.NumericPrediction;
import weka.classifiers.timeseries.AbstractForecaster;
import weka.classifiers.timeseries.TSForecaster;
import weka.classifiers.timeseries.core.OverlayForecaster;
import weka.classifiers.timeseries.core.TSLagMaker;
import weka.classifiers.timeseries.core.TSLagUser;
import weka.classifiers.timeseries.core.Utils;
import weka.classifiers.timeseries.eval.ErrorModule;
import weka.classifiers.timeseries.eval.RAEModule;
import weka.classifiers.timeseries.eval.RRSEModule;
import weka.classifiers.timeseries.eval.TSEvalModule;
import weka.classifiers.timeseries.eval.graph.GraphDriver;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;

public class TSEvaluation {
    protected int m_horizon = 1;
    protected int m_primeWindowSize = 1;
    protected boolean m_primeForTestDataWithTestData = false;
    protected boolean m_rebuildModelAfterEachTestForecastStep = false;
    protected boolean m_forecastFuture = true;
    protected boolean m_evaluateTrainingData = true;
    protected boolean m_evaluateTestData = true;
    protected List<ErrorModule> m_predictionsForTrainingData;
    protected List<ErrorModule> m_predictionsForTestData;
    protected List<List<NumericPrediction>> m_trainingFuture;
    protected List<List<NumericPrediction>> m_testFuture;
    protected Map<String, List<TSEvalModule>> m_metricsForTrainingData;
    protected Map<String, List<TSEvalModule>> m_metricsForTestData;
    protected List<TSEvalModule> m_evalModules;
    protected Instances m_trainingData;
    protected Instances m_testData;
    protected Instances m_dataStructure;
    protected List<Integer> m_missingTargetListTestSet;
    protected List<Integer> m_missingTimeStampListTestSet;
    protected List<String> m_missingTimeStampTestSetRows;

    public TSEvaluation(Instances trainingData, double testSplitSize) throws Exception {
        if (trainingData != null) {
            Instances train = new Instances(trainingData);
            Instances test = null;
            if (testSplitSize > 0.0) {
                if (trainingData.numInstances() < 2) {
                    throw new Exception("Need at least 2 training instances to do hold out evaluation!");
                }
                int numToHoldOut = 0;
                int trainSize = 0;
                if (testSplitSize >= 1.0) {
                    numToHoldOut = (int)testSplitSize;
                    trainSize = trainingData.numInstances() - numToHoldOut;
                    if (trainSize <= 0) {
                        throw new Exception("Can't hold out more instances than there is in the data!");
                    }
                } else if (testSplitSize > 0.0) {
                    double trainP = 1.0 - testSplitSize;
                    trainSize = (int)Math.round((double)trainingData.numInstances() * trainP);
                    numToHoldOut = trainingData.numInstances() - trainSize;
                }
                train = new Instances(trainingData, 0, trainSize);
                test = new Instances(trainingData, trainSize, numToHoldOut);
            } else if (testSplitSize < 0.0) {
                throw new Exception("Testing holdout size can't be less than zero!");
            }
            this.setTrainingData(train);
            this.setTestData(test);
        } else {
            this.setEvaluateOnTrainingData(false);
        }
        this.setEvaluationModules("MAE,RMSE");
    }

    public TSEvaluation(Instances trainingData, Instances testData) throws Exception {
        if (trainingData != null && testData != null && !trainingData.equalHeaders(testData)) {
            throw new Exception("Training and testing data are not compatible!");
        }
        if (trainingData == null && testData == null) {
            throw new Exception("Can't specify null for both training and test data");
        }
        this.setTrainingData(trainingData);
        this.setTestData(testData);
        this.setEvaluationModules("MAE,RMSE");
    }

    public void setTrainingData(Instances train) {
        if (train == null || train.numInstances() > 0) {
            this.m_trainingData = train;
            if (this.m_trainingData == null) {
                this.m_evaluateTrainingData = false;
            }
        } else {
            this.m_dataStructure = train;
        }
    }

    public void setTestData(Instances testData) {
        if (testData == null || testData.numInstances() > 0) {
            this.m_testData = testData;
            this.m_evaluateTestData = this.m_testData != null;
        } else {
            this.m_dataStructure = testData;
            this.m_evaluateTestData = false;
        }
    }

    public Instances getTrainingData() {
        return this.m_trainingData;
    }

    public Instances getTestData() {
        return this.m_testData;
    }

    public void setEvaluateOnTrainingData(boolean evalOnTraining) {
        this.m_evaluateTrainingData = evalOnTraining;
    }

    public boolean getEvaluateOnTrainingData() {
        return this.m_evaluateTrainingData;
    }

    public void setEvaluateOnTestData(boolean evalOnTest) {
        this.m_evaluateTestData = evalOnTest;
    }

    public boolean getEvaluateOnTestData() {
        return this.m_evaluateTestData;
    }

    public void setHorizon(int horizon) {
        this.m_horizon = horizon;
    }

    public void setPrimeWindowSize(int primeSize) {
        this.m_primeWindowSize = primeSize;
    }

    public int getPrimeWindowSize() {
        return this.m_primeWindowSize;
    }

    public void setPrimeForTestDataWithTestData(boolean p) {
        this.m_primeForTestDataWithTestData = p;
    }

    public boolean getPrimeForTestDataWithTestData() {
        return this.m_primeForTestDataWithTestData;
    }

    public void setRebuildModelAfterEachTestForecastStep(boolean r) {
        this.m_rebuildModelAfterEachTestForecastStep = r;
    }

    public void setForecastFuture(boolean future) {
        this.m_forecastFuture = future;
    }

    public boolean getForecastFuture() {
        return this.m_forecastFuture;
    }

    public void setEvaluationModules(String evalModNames) throws Exception {
        String[] names = evalModNames.split(",");
        this.m_evalModules = new ArrayList<TSEvalModule>();
        this.m_evalModules.add(new ErrorModule());
        for (String modName : names) {
            TSEvalModule mod;
            if (modName.length() <= 0 || (mod = TSEvalModule.getModule(modName.trim())).equals("Error")) continue;
            this.m_evalModules.add(mod);
        }
    }

    public List<TSEvalModule> getEvaluationModules() {
        return this.m_evalModules;
    }

    public ErrorModule getPredictionsForTrainingData(int stepNumber) throws Exception {
        if (this.m_predictionsForTrainingData == null) {
            throw new Exception("No predictions for training data available!");
        }
        int numSteps = this.m_predictionsForTrainingData.size();
        if (stepNumber > this.m_predictionsForTrainingData.size()) {
            throw new Exception("Only predictions up to " + numSteps + (numSteps > 1 ? "steps" : "step") + "-ahead are available");
        }
        ErrorModule m = this.m_predictionsForTrainingData.get(stepNumber - 1);
        return m;
    }

    public ErrorModule getPredictionsForTestData(int stepNumber) throws Exception {
        if (this.m_predictionsForTestData == null) {
            throw new Exception("No predictions for test data available!");
        }
        int numSteps = this.m_predictionsForTestData.size();
        if (stepNumber > this.m_predictionsForTestData.size()) {
            throw new Exception("Only predictions up to " + numSteps + (numSteps > 1 ? "steps" : "step") + "-ahead are available");
        }
        ErrorModule m = this.m_predictionsForTestData.get(stepNumber - 1);
        return m;
    }

    private void setupEvalModules(List<ErrorModule> predHolders, Map<String, List<TSEvalModule>> evalHolders, List<String> fieldsToForecast) {
        for (int i = 0; i < this.m_horizon; ++i) {
            ErrorModule e = new ErrorModule();
            e.setTargetFields(fieldsToForecast);
            predHolders.add(e);
        }
        for (TSEvalModule m : this.m_evalModules) {
            if (m.getEvalName().equals("Error")) continue;
            String key = m.getEvalName();
            ArrayList<TSEvalModule> evalForSteps = new ArrayList<TSEvalModule>();
            TSEvalModule firstMod = null;
            for (int i = 0; i < this.m_horizon; ++i) {
                TSEvalModule newMod = TSEvalModule.getModule(key);
                newMod.setTargetFields(fieldsToForecast);
                if (i == 0) {
                    firstMod = newMod;
                } else if (newMod.getEvalName().equals("RRSE")) {
                    ((RRSEModule)newMod).setRelativeRRSEModule((RRSEModule)firstMod);
                } else if (newMod.getEvalName().equals("RAE")) {
                    ((RAEModule)newMod).setRelativeRAEModule((RAEModule)firstMod);
                }
                evalForSteps.add(newMod);
            }
            evalHolders.put(key, evalForSteps);
        }
    }

    private void updateEvalModules(List<ErrorModule> predHolders, Map<String, List<TSEvalModule>> evalHolders, List<List<NumericPrediction>> predsForSteps, int currentInstanceNum, Instances toPredict) throws Exception {
        for (int i = 0; i < this.m_horizon; ++i) {
            if (i >= predsForSteps.size()) continue;
            List<NumericPrediction> predsForStepI = predsForSteps.get(i);
            if (currentInstanceNum + i < toPredict.numInstances()) {
                predHolders.get(i).evaluateForInstance(predsForStepI, toPredict.instance(currentInstanceNum + i));
                continue;
            }
            predHolders.get(i).evaluateForInstance(predsForStepI, null);
        }
        for (TSEvalModule m : this.m_evalModules) {
            if (m.getEvalName().equals("Error")) continue;
            String key = m.getEvalName();
            List<TSEvalModule> evalForSteps = evalHolders.get(key);
            for (int i = 0; i < this.m_horizon; ++i) {
                if (i >= predsForSteps.size()) continue;
                List<NumericPrediction> predsForStepI = predsForSteps.get(i);
                if (currentInstanceNum + i < toPredict.numInstances()) {
                    evalForSteps.get(i).evaluateForInstance(predsForStepI, toPredict.instance(currentInstanceNum + i));
                    continue;
                }
                evalForSteps.get(i).evaluateForInstance(predsForStepI, null);
            }
        }
    }

    public void evaluateForecaster(TSForecaster forecaster, PrintStream ... progress) throws Exception {
        this.evaluateForecaster(forecaster, true, progress);
    }

    protected Instances createOverlayForecastData(TSForecaster forecaster, Instances source, int start, int numSteps) {
        int toCopy = Math.min(numSteps, source.numInstances() - start);
        Instances overlay = new Instances(source, start, toCopy);
        List<String> fieldsToForecast = AbstractForecaster.stringToList(forecaster.getFieldsToForecast());
        for (int i = 0; i < overlay.numInstances(); ++i) {
            Instance current = overlay.instance(i);
            for (String target : fieldsToForecast) {
                current.setValue(overlay.attribute(target), weka.core.Utils.missingValue());
            }
        }
        return overlay;
    }

    public void evaluateForecaster(TSForecaster forecaster, boolean buildModel, PrintStream ... progress) throws Exception {
        Instances primeData;
        this.m_predictionsForTrainingData = null;
        this.m_predictionsForTestData = null;
        this.m_trainingFuture = null;
        this.m_testFuture = null;
        if (this.m_trainingData != null && buildModel) {
            for (PrintStream p : progress) {
                p.println("Building forecaster...");
            }
            forecaster.buildForecaster(this.m_trainingData, new PrintStream[0]);
        }
        if (forecaster instanceof TSLagUser) {
            TSLagMaker lagMaker = ((TSLagUser)((Object)forecaster)).getTSLagMaker();
            Instances trainMod = new Instances(this.m_trainingData);
            if ((trainMod = Utils.replaceMissing(trainMod, lagMaker.getFieldsToLag(), lagMaker.getTimeStampField(), false, lagMaker.getPeriodicity(), lagMaker.getSkipEntries(), new Object[0])).numInstances() != this.m_trainingData.numInstances()) {
                this.m_trainingData = trainMod;
            }
            if (this.m_evaluateTestData) {
                this.m_missingTimeStampTestSetRows = new ArrayList<String>();
                this.m_missingTargetListTestSet = new ArrayList<Integer>();
                this.m_missingTimeStampListTestSet = new ArrayList<Integer>();
                Instances testMod = new Instances(this.m_testData);
                if ((testMod = Utils.replaceMissing(testMod, lagMaker.getFieldsToLag(), lagMaker.getTimeStampField(), false, lagMaker.getPeriodicity(), lagMaker.getSkipEntries(), this.m_missingTargetListTestSet, this.m_missingTimeStampListTestSet, this.m_missingTimeStampTestSetRows)).numInstances() != this.m_testData.numInstances()) {
                    this.m_testData = testMod;
                }
            }
        }
        if (this.m_evaluateTrainingData) {
            for (PrintStream p : progress) {
                p.println("Evaluating on training set...");
            }
            this.m_predictionsForTrainingData = new ArrayList<ErrorModule>();
            this.m_metricsForTrainingData = new HashMap<String, List<TSEvalModule>>();
            this.setupEvalModules(this.m_predictionsForTrainingData, this.m_metricsForTrainingData, AbstractForecaster.stringToList(forecaster.getFieldsToForecast()));
            primeData = new Instances(this.m_trainingData, 0);
            if (forecaster instanceof TSLagUser && ((TSLagUser)((Object)forecaster)).getTSLagMaker().isUsingAnArtificialTimeIndex()) {
                ((TSLagUser)((Object)forecaster)).getTSLagMaker().setArtificialTimeStartValue(this.m_primeWindowSize);
            }
            for (int i = 0; i < this.m_trainingData.numInstances(); ++i) {
                Instance current = this.m_trainingData.instance(i);
                if (i < this.m_primeWindowSize) {
                    primeData.add(current);
                    continue;
                }
                if (i % 10 == 0) {
                    for (PrintStream p : progress) {
                        p.println("Evaluating on training set: processed " + i + " instances...");
                    }
                }
                forecaster.primeForecaster(primeData);
                List<List<NumericPrediction>> forecast = null;
                if (forecaster instanceof OverlayForecaster && ((OverlayForecaster)((Object)forecaster)).isUsingOverlayData()) {
                    if (current != null) {
                        Instances overlay = this.createOverlayForecastData(forecaster, this.m_trainingData, i, this.m_horizon);
                        forecast = ((OverlayForecaster)((Object)forecaster)).forecast(this.m_horizon, overlay, progress);
                    }
                } else {
                    forecast = forecaster.forecast(this.m_horizon, progress);
                }
                this.updateEvalModules(this.m_predictionsForTrainingData, this.m_metricsForTrainingData, forecast, i, this.m_trainingData);
                if (this.m_primeWindowSize <= 0 || current == null) continue;
                primeData.remove(0);
                primeData.add(current);
                primeData.compactify();
            }
        }
        if (this.m_trainingData != null && this.m_forecastFuture) {
            for (PrintStream p : progress) {
                p.println("Generating future forecast for training data...");
            }
            primeData = new Instances(this.m_trainingData, this.m_trainingData.numInstances() - this.m_primeWindowSize, this.m_primeWindowSize);
            forecaster.primeForecaster(primeData);
            if (forecaster instanceof OverlayForecaster && ((OverlayForecaster)((Object)forecaster)).isUsingOverlayData()) {
                if (this.m_testData != null) {
                    Instances overlay = this.createOverlayForecastData(forecaster, this.m_testData, 0, this.m_horizon);
                    this.m_trainingFuture = ((OverlayForecaster)((Object)forecaster)).forecast(this.m_horizon, overlay, progress);
                } else {
                    for (PrintStream p : progress) {
                        p.println("WARNING: Unable to generate a future forecast beyond the end of the training data because there is no future overlay data available.");
                    }
                }
            } else {
                this.m_trainingFuture = forecaster.forecast(this.m_horizon, new PrintStream[0]);
            }
        }
        if (this.m_evaluateTestData) {
            for (PrintStream p : progress) {
                p.println("Evaluating on test set...");
            }
            this.m_predictionsForTestData = new ArrayList<ErrorModule>();
            this.m_metricsForTestData = new HashMap<String, List<TSEvalModule>>();
            this.setupEvalModules(this.m_predictionsForTestData, this.m_metricsForTestData, AbstractForecaster.stringToList(forecaster.getFieldsToForecast()));
            primeData = null;
            Instances rebuildData = null;
            if (this.m_trainingData != null) {
                primeData = new Instances(this.m_trainingData, 0);
                if (forecaster instanceof TSLagUser && ((TSLagUser)((Object)forecaster)).getTSLagMaker().isUsingAnArtificialTimeIndex()) {
                    ((TSLagUser)((Object)forecaster)).getTSLagMaker().setArtificialTimeStartValue(this.m_trainingData.numInstances());
                }
                if (this.m_rebuildModelAfterEachTestForecastStep) {
                    rebuildData = new Instances(this.m_trainingData);
                }
            } else {
                primeData = new Instances(this.m_testData, 0);
            }
            int predictionOffsetForTestData = 0;
            if (this.m_trainingData == null || this.m_primeForTestDataWithTestData) {
                if (this.m_primeWindowSize >= this.m_testData.numInstances()) {
                    throw new Exception("The test data needs to have at least as many instances as the the priming window size!");
                }
                predictionOffsetForTestData = this.m_primeWindowSize;
                if (predictionOffsetForTestData >= this.m_testData.numInstances()) {
                    throw new Exception("Priming using test data requires more instances than are available in the test data!");
                }
                primeData = new Instances(this.m_testData, 0, this.m_primeWindowSize);
                if (forecaster instanceof TSLagUser && ((TSLagUser)((Object)forecaster)).getTSLagMaker().isUsingAnArtificialTimeIndex()) {
                    double artificialTimeStampStart = 0.0;
                    if (this.m_primeForTestDataWithTestData) {
                        if (this.m_trainingData == null) {
                            artificialTimeStampStart = ((TSLagUser)((Object)forecaster)).getTSLagMaker().getArtificialTimeStartValue();
                            ((TSLagUser)((Object)forecaster)).getTSLagMaker().setArtificialTimeStartValue(artificialTimeStampStart += (double)this.m_primeWindowSize);
                        } else {
                            ((TSLagUser)((Object)forecaster)).getTSLagMaker().setArtificialTimeStartValue(this.m_trainingData.numInstances() + this.m_primeWindowSize);
                        }
                    }
                }
            } else {
                predictionOffsetForTestData = 0;
                primeData = new Instances(this.m_trainingData, this.m_trainingData.numInstances() - this.m_primeWindowSize, this.m_primeWindowSize);
            }
            for (int i = predictionOffsetForTestData; i < this.m_testData.numInstances(); ++i) {
                Instance current = this.m_testData.instance(i);
                if (this.m_primeWindowSize > 0) {
                    forecaster.primeForecaster(primeData);
                }
                if (i % 10 == 0) {
                    for (PrintStream p : progress) {
                        p.println("Evaluating on test set: processed " + i + " instances...");
                    }
                }
                List<List<NumericPrediction>> forecast = null;
                if (forecaster instanceof OverlayForecaster && ((OverlayForecaster)((Object)forecaster)).isUsingOverlayData()) {
                    if (current != null) {
                        Instances overlay = this.createOverlayForecastData(forecaster, this.m_testData, i, this.m_horizon);
                        forecast = ((OverlayForecaster)((Object)forecaster)).forecast(this.m_horizon, overlay, progress);
                    }
                } else {
                    forecast = forecaster.forecast(this.m_horizon, progress);
                }
                this.updateEvalModules(this.m_predictionsForTestData, this.m_metricsForTestData, forecast, i, this.m_testData);
                if (this.m_primeWindowSize > 0 && current != null) {
                    primeData.remove(0);
                    primeData.add(current);
                    primeData.compactify();
                }
                if (!this.m_rebuildModelAfterEachTestForecastStep || rebuildData == null) continue;
                rebuildData.add(current);
                forecaster.buildForecaster(rebuildData, new PrintStream[0]);
            }
        }
        if (this.m_testData != null && this.m_forecastFuture) {
            for (PrintStream p : progress) {
                p.println("Generating future forecast for test data...");
            }
            primeData = null;
            if (this.m_primeWindowSize > this.m_testData.numInstances()) {
                int difference = this.m_primeWindowSize - this.m_testData.numInstances();
                if (this.m_trainingData != null) {
                    primeData = difference > this.m_trainingData.numInstances() ? new Instances(this.m_trainingData) : new Instances(this.m_trainingData, this.m_trainingData.numInstances() - difference, difference);
                }
                for (int z = 0; z < this.m_testData.numInstances(); ++z) {
                    primeData.add(this.m_testData.instance(z));
                }
            } else {
                primeData = new Instances(this.m_testData, this.m_testData.numInstances() - this.m_primeWindowSize, this.m_primeWindowSize);
            }
            forecaster.primeForecaster(primeData);
            if (forecaster instanceof OverlayForecaster && ((OverlayForecaster)((Object)forecaster)).isUsingOverlayData()) {
                for (PrintStream p : progress) {
                    p.println("WARNING: Unable to generate a future forecast beyond the end of the test data because there is no future overlay data available.");
                }
            } else {
                this.m_testFuture = forecaster.forecast(this.m_horizon, progress);
            }
        }
    }

    protected static String makeOptionString(TSForecaster forecaster, boolean globalInfo) {
        StringBuffer optionsText = new StringBuffer("");
        optionsText.append("\n\tGeneral options:\n\n");
        optionsText.append("-h or -help\n");
        optionsText.append("\tOutput help information.\n");
        optionsText.append("-synopsis or -info\n");
        optionsText.append("\tOutput synopsis for forecaster (use in conjunction  with -h)\n");
        optionsText.append("-t <name of training file>\n");
        optionsText.append("\tSets training file.\n");
        optionsText.append("-T <name of test file>\n");
        optionsText.append("\tSets test file.\n");
        optionsText.append("-holdout <#instances | percentage>\n");
        optionsText.append("\tSets the number of instances or percentage of the training\n\tdata to hold out for testing.\n");
        optionsText.append("-horizon <#steps>\n");
        optionsText.append("\tThe maximum number of steps to forecast into the future.\n");
        optionsText.append("-prime <#instances>\n");
        optionsText.append("\tThe number of instances to prime the forecaster with before\n\tgenerating a forecast.\n");
        optionsText.append("-metrics <list of metrics>\n");
        optionsText.append("\tA list of metrics to use for evaluation.\n\t(default: MAE,RMSE)\n");
        optionsText.append("-p <target:step#>\n");
        optionsText.append("\tOutput predictions for the specified target at the\n\tspecified step-ahead level.\n");
        optionsText.append("-graph <file name:target list:step list>\n");
        optionsText.append("\tGenerate a PNG graph of predictions for the specified\n\ttarget(s) at the specified step-ahead level(s) on the training\n\tand/or test data. Note that only one of the targets or steps can\n\t be a list - i.e. either a single target is plotted for multiple step-ahead levels, or, multiple targets are plotted at a single\n\t step-ahead level.\n");
        optionsText.append("-future\n");
        optionsText.append("\tOutput training/test data plus predictions for all\n\ttargets up to horizon steps into the future.\n");
        optionsText.append("-future-graph <file name>\n");
        optionsText.append("\tGenerate a PNG graph of future predictions (beyond the end\n\tof the series) for the training and/or test data for all targets.\n");
        optionsText.append("-l <name of input file>\n");
        optionsText.append("\tSets model input file.\n");
        optionsText.append("-d <name of output file>\n");
        optionsText.append("\tSets model output file.\n");
        if (forecaster instanceof OptionHandler) {
            optionsText.append("\nOptions specific to " + forecaster.getClass().getName() + ":\n\n");
            Enumeration enu = ((OptionHandler)forecaster).listOptions();
            while (enu.hasMoreElements()) {
                Option option = (Option)enu.nextElement();
                optionsText.append(option.synopsis()).append("\n");
                optionsText.append(option.description()).append("\n");
            }
        }
        if (globalInfo) {
            try {
                String gi = TSEvaluation.getGlobalInfo(forecaster);
                optionsText.append(gi);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return optionsText.toString();
    }

    protected static String getGlobalInfo(TSForecaster forecaster) throws Exception {
        BeanInfo bi = Introspector.getBeanInfo(forecaster.getClass());
        MethodDescriptor[] methods = bi.getMethodDescriptors();
        Object[] args = new Object[]{};
        String result = "\nSynopsis for " + forecaster.getClass().getName() + ":\n\n";
        for (int i = 0; i < methods.length; ++i) {
            String name = methods[i].getDisplayName();
            Method meth = methods[i].getMethod();
            if (!name.equals("globalInfo")) continue;
            String globalInfo = (String)meth.invoke((Object)forecaster, args);
            result = result + globalInfo;
            break;
        }
        return result;
    }

    public static void evaluateForecaster(TSForecaster forecaster, String[] options) throws Exception {
        if (weka.core.Utils.getFlag((char)'h', (String[])options) || weka.core.Utils.getFlag((String)"-help", (String[])options)) {
            boolean globalInfo = weka.core.Utils.getFlag((String)"synopsis", (String[])options) || weka.core.Utils.getFlag((String)"info", (String[])options);
            throw new Exception("\nHelp requested." + TSEvaluation.makeOptionString(forecaster, globalInfo));
        }
        String trainingFileName = weka.core.Utils.getOption((char)'t', (String[])options);
        String testingFileName = weka.core.Utils.getOption((char)'T', (String[])options);
        String testSizeS = weka.core.Utils.getOption((String)"holdout", (String[])options);
        String loadForecasterName = weka.core.Utils.getOption((char)'l', (String[])options);
        String saveForecasterName = weka.core.Utils.getOption((char)'d', (String[])options);
        String horizonS = weka.core.Utils.getOption((String)"horizon", (String[])options);
        String primeWindowSizeS = weka.core.Utils.getOption((String)"prime", (String[])options);
        String evalModuleList = weka.core.Utils.getOption((String)"metrics", (String[])options);
        String outputPredictionsS = weka.core.Utils.getOption((char)'p', (String[])options);
        String saveGraphS = weka.core.Utils.getOption((String)"graph", (String[])options);
        boolean printFutureForecast = weka.core.Utils.getFlag((String)"future", (String[])options);
        String graphFutureForecastS = weka.core.Utils.getOption((String)"future-graph", (String[])options);
        Instances inputHeader = null;
        Instances trainingData = null;
        Instances testData = null;
        int testSize = 0;
        int horizon = 1;
        int primeWindowSize = 1;
        boolean primeWithTest = weka.core.Utils.getFlag((String)"primeWithTest", (String[])options);
        boolean rebuildModelAfterEachStep = weka.core.Utils.getFlag((char)'r', (String[])options);
        boolean noEvalForTrainingData = weka.core.Utils.getFlag((char)'v', (String[])options);
        if (loadForecasterName.length() > 0 && trainingFileName.length() > 0) {
            System.out.println("When a model is loaded from a file any training data is only used for priming the model.");
        }
        if (loadForecasterName.length() > 0) {
            ObjectInputStream ois = new ObjectInputStream(new FileInputStream(loadForecasterName));
            forecaster = (TSForecaster)ois.readObject();
            try {
                inputHeader = (Instances)ois.readObject();
            }
            catch (Exception ex) {
                // empty catch block
            }
            ois.close();
        }
        if (testingFileName.length() > 0 && testSizeS.length() > 0) {
            throw new Exception("Can't specify both a test file and a holdout size.");
        }
        if (testingFileName.length() == 0 && primeWithTest) {
            throw new Exception("Can't prime the forecaster with data from the test file if no test file is specified!");
        }
        if (testSizeS.length() > 0) {
            testSize = Integer.parseInt(testSizeS);
        }
        if (testingFileName.length() == 0 && testSize == 0 && rebuildModelAfterEachStep) {
            throw new Exception("Can't rebuild the model after each forecasting step on the test data if there is no test data specified or no holdout size specified!");
        }
        if (trainingFileName.length() > 0) {
            trainingData = new Instances((Reader)new BufferedReader(new FileReader(trainingFileName)));
        } else {
            noEvalForTrainingData = true;
        }
        if (testingFileName.length() > 0) {
            testData = new Instances((Reader)new BufferedReader(new FileReader(testingFileName)));
        }
        if (horizonS.length() > 0) {
            horizon = Integer.parseInt(horizonS);
        }
        if (primeWindowSizeS.length() <= 0) {
            throw new Exception("Must specify the number of instances to prime the forecaster with for generating predictions (-prime)");
        }
        primeWindowSize = Integer.parseInt(primeWindowSizeS);
        String outputPredsForTarget = null;
        int stepNum = 1;
        if (outputPredictionsS.length() > 0) {
            String[] parts = outputPredictionsS.split(":");
            outputPredsForTarget = parts[0].trim();
            if (parts.length > 1) {
                stepNum = Integer.parseInt(parts[1]);
            }
        }
        String saveGraphFileName = null;
        ArrayList<String> graphTargets = null;
        ArrayList<Integer> stepsToPlot = new ArrayList<Integer>();
        graphTargets = new ArrayList<String>();
        if (saveGraphS.length() > 0) {
            String[] targetParts;
            String[] parts = saveGraphS.split(":");
            saveGraphFileName = parts[0].trim();
            String targets = parts[1].trim();
            for (String s : targetParts = targets.split(",")) {
                graphTargets.add(s.trim());
            }
            if (parts.length > 2) {
                String[] graphStepNums;
                for (String s : graphStepNums = parts[2].split(",")) {
                    Integer step = new Integer(Integer.parseInt(s.trim()));
                    if (step < 1 || step > horizon) {
                        throw new Exception("Can't specify a step to graph that is less than 1 or greater than the selected horizon!");
                    }
                    stepsToPlot.add(step);
                }
            } else {
                stepsToPlot.add(new Integer(1));
            }
        }
        if (graphTargets.size() > 1 && stepsToPlot.size() > 1) {
            throw new Exception("Can't specify multiple targets to plot and multiple steps. Specify either multiple target names to plot for a single step, or, a single target to plot at multiple steps.");
        }
        if (forecaster instanceof OptionHandler && loadForecasterName.length() == 0) {
            ((OptionHandler)forecaster).setOptions(options);
        }
        TSEvaluation eval = new TSEvaluation(trainingData, testSize);
        if (testData != null) {
            eval.setTestData(testData);
        }
        eval.setHorizon(horizon);
        eval.setPrimeWindowSize(primeWindowSize);
        eval.setPrimeForTestDataWithTestData(primeWithTest);
        eval.setRebuildModelAfterEachTestForecastStep(rebuildModelAfterEachStep);
        eval.setForecastFuture(printFutureForecast || graphFutureForecastS.length() > 0);
        if (evalModuleList.length() > 0) {
            eval.setEvaluationModules(evalModuleList);
        }
        eval.setEvaluateOnTrainingData(!noEvalForTrainingData);
        if (loadForecasterName.length() == 0) {
            forecaster.buildForecaster(eval.getTrainingData(), new PrintStream[0]);
        }
        System.out.println(forecaster.toString());
        if (saveForecasterName.length() > 0) {
            ObjectOutputStream oos = new ObjectOutputStream(new FileOutputStream(saveForecasterName));
            oos.writeObject(forecaster);
            oos.writeObject(new Instances(eval.getTrainingData(), 0));
            oos.close();
        }
        eval.evaluateForecaster(forecaster, false, new PrintStream[0]);
        if (outputPredsForTarget != null && trainingData != null && !noEvalForTrainingData) {
            System.out.println(eval.printPredictionsForTrainingData("=== Predictions for training data: " + outputPredsForTarget + " (" + stepNum + (stepNum > 1 ? "-steps ahead)" : "-step ahead)") + " ===", outputPredsForTarget, stepNum, primeWindowSize));
        }
        if (outputPredsForTarget != null && (testData != null || testSize > 0)) {
            int instanceNumberOffset;
            int n = instanceNumberOffset = trainingData != null && testSize > 0 ? eval.getTrainingData().numInstances() : 0;
            if (primeWithTest) {
                instanceNumberOffset += primeWindowSize;
            }
            System.out.println(eval.printPredictionsForTestData("=== Predictions for test data: " + outputPredsForTarget + " (" + stepNum + (stepNum > 1 ? "-steps ahead)" : "-step ahead)") + " ===", outputPredsForTarget, stepNum, instanceNumberOffset));
        }
        if (printFutureForecast) {
            if (trainingData != null && !noEvalForTrainingData) {
                System.out.println("=== Future predictions from end of training data ===\n");
                System.out.println(eval.printFutureTrainingForecast(forecaster));
            }
            if (testData != null || testSize > 0) {
                System.out.println("=== Future predictions from end of test data ===\n");
                System.out.println(eval.printFutureTestForecast(forecaster));
            }
        }
        System.out.println(eval.toSummaryString());
        if (saveGraphFileName != null && trainingData != null && !noEvalForTrainingData) {
            if (graphTargets.size() >= 1 || graphTargets.size() == 1 && stepsToPlot.size() == 1) {
                JPanel result = eval.graphPredictionsForTargetsOnTraining(GraphDriver.getDefaultDriver(), forecaster, graphTargets, (Integer)stepsToPlot.get(0), primeWindowSize);
                GraphDriver.getDefaultDriver().saveChartToFile(result, saveGraphFileName + "_train", 1000, 600);
            } else {
                JPanel result = eval.graphPredictionsForStepsOnTraining(GraphDriver.getDefaultDriver(), forecaster, (String)graphTargets.get(0), stepsToPlot, primeWindowSize);
                GraphDriver.getDefaultDriver().saveChartToFile(result, saveGraphFileName + "_train", 1000, 600);
            }
        }
        if (saveGraphFileName != null && (testData != null || testSize > 0)) {
            JPanel result;
            int instanceOffset;
            int n = instanceOffset = primeWithTest ? primeWindowSize : 0;
            if (graphTargets.size() > 1 || graphTargets.size() == 1 && stepsToPlot.size() == 1) {
                result = eval.graphPredictionsForTargetsOnTesting(GraphDriver.getDefaultDriver(), forecaster, graphTargets, (Integer)stepsToPlot.get(0), instanceOffset);
                GraphDriver.getDefaultDriver().saveChartToFile(result, saveGraphFileName + "_test", 1000, 600);
            } else {
                result = eval.graphPredictionsForStepsOnTesting(GraphDriver.getDefaultDriver(), forecaster, (String)graphTargets.get(0), stepsToPlot, instanceOffset);
                GraphDriver.getDefaultDriver().saveChartToFile(result, saveGraphFileName + "_test", 1000, 600);
            }
        }
        if (graphFutureForecastS.length() > 0) {
            if (trainingData != null && !noEvalForTrainingData && eval.m_trainingFuture != null) {
                JPanel result = eval.graphFutureForecastOnTraining(GraphDriver.getDefaultDriver(), forecaster, AbstractForecaster.stringToList(forecaster.getFieldsToForecast()));
                GraphDriver.getDefaultDriver().saveChartToFile(result, graphFutureForecastS + "_train", 1000, 600);
            }
            if (testData != null || testSize > 0 && eval.m_testFuture != null) {
                JPanel result = eval.graphFutureForecastOnTesting(GraphDriver.getDefaultDriver(), forecaster, AbstractForecaster.stringToList(forecaster.getFieldsToForecast()));
                GraphDriver.getDefaultDriver().saveChartToFile(result, graphFutureForecastS + "_test", 1000, 600);
            }
        }
    }

    protected String printFutureForecast(TSForecaster forecaster, List<List<NumericPrediction>> futureForecast, Instances insts) throws Exception {
        if (futureForecast == null) {
            if (forecaster instanceof OverlayForecaster && ((OverlayForecaster)((Object)forecaster)).isUsingOverlayData()) {
                return "Unable to generate future forecast because there is no future overlay data available.";
            }
            return "Unable to generate future forecast.";
        }
        boolean timeIsInstanceNum = true;
        double timeStart = 1.0;
        double timeDelta = 1.0;
        String dateFormat = null;
        TSLagMaker lagMaker = null;
        if (forecaster instanceof TSLagUser && !(lagMaker = ((TSLagUser)((Object)forecaster)).getTSLagMaker()).isUsingAnArtificialTimeIndex() && lagMaker.getAdjustForTrends()) {
            String timeStampName = lagMaker.getTimeStampField();
            if (insts.attribute(timeStampName).isDate()) {
                dateFormat = insts.attribute(timeStampName).getDateFormat();
            }
            timeStart = insts.instance(0).value(insts.attribute(timeStampName));
            timeDelta = lagMaker.getDeltaTime();
            timeIsInstanceNum = false;
        }
        List<String> targets = AbstractForecaster.stringToList(forecaster.getFieldsToForecast());
        int maxColWidth = 1;
        for (String t : targets) {
            if (t.length() <= maxColWidth) continue;
            maxColWidth = t.length();
        }
        int maxTimeColWidth = "inst#".length();
        SimpleDateFormat format = null;
        if (dateFormat != null) {
            maxTimeColWidth = "Time".length();
            format = new SimpleDateFormat(dateFormat);
            String formatted = format.format(new Date((long)timeStart));
            if (formatted.length() > maxTimeColWidth) {
                maxTimeColWidth = formatted.length();
            }
        } else {
            double maxTime = timeStart + (double)(insts.numInstances() + this.m_horizon) * timeDelta;
            maxTimeColWidth = TSEvaluation.maxWidth(maxTimeColWidth, maxTime);
        }
        for (int i = 0; i < insts.numInstances(); ++i) {
            Instance current = insts.instance(i);
            for (String t : targets) {
                if (current.isMissing(insts.attribute(t))) continue;
                maxColWidth = TSEvaluation.maxWidth(maxColWidth, current.value(insts.attribute(t)));
            }
        }
        StringBuffer result = new StringBuffer();
        if (dateFormat != null) {
            result.append(TSEvaluation.pad("Time", " ", maxTimeColWidth, false)).append("  ");
        } else {
            result.append(TSEvaluation.pad("inst#", " ", maxTimeColWidth, false)).append("  ");
        }
        for (String t : targets) {
            result.append(TSEvaluation.pad(t, " ", maxColWidth, true)).append(" ");
        }
        result.append("\n");
        int instNum = (int)timeStart;
        long dateTime = (long)timeStart;
        for (int i = 0; i < insts.numInstances() + futureForecast.size(); ++i) {
            String predMarker;
            String string = predMarker = i < insts.numInstances() ? "" : "*";
            if (timeIsInstanceNum) {
                result.append(TSEvaluation.pad("" + instNum + predMarker, " ", maxTimeColWidth, false)).append("  ");
                instNum += (int)timeDelta;
            } else if (dateFormat != null) {
                result.append(TSEvaluation.pad(format.format(new Date(dateTime)) + predMarker, " ", maxTimeColWidth, false)).append("  ");
                dateTime = lagMaker != null ? (long)lagMaker.advanceSuppliedTimeValue(dateTime) : (dateTime += (long)timeDelta);
            } else {
                result.append(TSEvaluation.pad(weka.core.Utils.doubleToString((double)timeStart, (int)4) + predMarker, " ", maxTimeColWidth, false)).append("  ");
                timeStart += timeDelta;
            }
            if (i < insts.numInstances()) {
                Instance current = insts.instance(i);
                for (String t : targets) {
                    if (!current.isMissing(insts.attribute(t))) {
                        double value = current.value(insts.attribute(t));
                        result.append(TSEvaluation.pad(weka.core.Utils.doubleToString((double)value, (int)4), " ", maxColWidth, true)).append(" ");
                        continue;
                    }
                    result.append(TSEvaluation.pad("?", " ", maxColWidth, true)).append(" ");
                }
            } else if (futureForecast != null) {
                int step = i - insts.numInstances();
                List<NumericPrediction> preds = futureForecast.get(step);
                for (NumericPrediction p : preds) {
                    result.append(TSEvaluation.pad(weka.core.Utils.doubleToString((double)p.predicted(), (int)4), " ", maxColWidth, true)).append(" ");
                }
            }
            result.append("\n");
        }
        return result.toString();
    }

    public String printFutureTestForecast(TSForecaster forecaster) throws Exception {
        if (this.m_testData == null || this.m_testData.numInstances() == 0) {
            throw new Exception("Can't forecast beyond the end of the test instances because no test instances have been supplied!");
        }
        return this.printFutureForecast(forecaster, this.m_testFuture, this.m_testData);
    }

    public String printFutureTrainingForecast(TSForecaster forecaster) throws Exception {
        if (this.m_trainingData == null || this.m_trainingData.numInstances() == 0) {
            throw new Exception("Can't forecast beyond the end of the training instances because no training instances have been supplied!");
        }
        return this.printFutureForecast(forecaster, this.m_trainingFuture, this.m_trainingData);
    }

    protected JPanel graphFutureForecast(GraphDriver driver, TSForecaster forecaster, List<String> targetNames, List<List<NumericPrediction>> preds, Instances history) throws Exception {
        JPanel result = driver.getPanelFutureForecast(forecaster, preds, targetNames, history);
        return result;
    }

    public JPanel graphFutureForecastOnTraining(GraphDriver driver, TSForecaster forecaster, List<String> targetNames) throws Exception {
        if (this.m_trainingData == null || this.m_trainingData.numInstances() == 0) {
            throw new Exception("Can't forecast beyond the end of the training instances because no training instances have been supplied!");
        }
        if (this.m_trainingFuture != null) {
            return this.graphFutureForecast(driver, forecaster, targetNames, this.m_trainingFuture, this.m_trainingData);
        }
        throw new Exception("[TSEvaluation] can't graph future forecast for training  because there are no future predicitons.");
    }

    public JPanel graphFutureForecastOnTesting(GraphDriver driver, TSForecaster forecaster, List<String> targetNames) throws Exception {
        if (this.m_testData == null || this.m_testData.numInstances() == 0) {
            throw new Exception("Can't forecast beyond the end of the test instances because no test instances have been supplied!");
        }
        if (this.m_testFuture != null) {
            return this.graphFutureForecast(driver, forecaster, targetNames, this.m_testFuture, this.m_testData);
        }
        throw new Exception("[TSEvaluation] can't graph future forecast for test set  because there are no future predicitons.");
    }

    public JPanel graphPredictionsForStepsOnTraining(GraphDriver driver, TSForecaster forecaster, String targetName, List<Integer> stepsToPlot, int instanceNumberOffset) throws Exception {
        JPanel result = driver.getGraphPanelSteps(forecaster, this.m_predictionsForTrainingData, targetName, stepsToPlot, instanceNumberOffset, this.getTrainingData());
        return result;
    }

    public JPanel graphPredictionsForStepsOnTesting(GraphDriver driver, TSForecaster forecaster, String targetName, List<Integer> stepsToPlot, int instanceNumberOffset) throws Exception {
        JPanel result = driver.getGraphPanelSteps(forecaster, this.m_predictionsForTestData, targetName, stepsToPlot, instanceNumberOffset, this.getTestData());
        return result;
    }

    public JPanel graphPredictionsForTargetsOnTraining(GraphDriver driver, TSForecaster forecaster, List<String> graphTargets, int graphStepNum, int instanceNumberOffset) throws Exception {
        ErrorModule preds = this.m_predictionsForTrainingData.get(graphStepNum - 1);
        JPanel result = driver.getGraphPanelTargets(forecaster, preds, graphTargets, graphStepNum, instanceNumberOffset, this.getTrainingData());
        return result;
    }

    public JPanel graphPredictionsForTargetsOnTesting(GraphDriver driver, TSForecaster forecaster, List<String> graphTargets, int graphStepNum, int primeWindowSize) throws Exception {
        ErrorModule preds = this.m_predictionsForTestData.get(graphStepNum - 1);
        JPanel result = driver.getGraphPanelTargets(forecaster, preds, graphTargets, graphStepNum, primeWindowSize, this.getTestData());
        return result;
    }

    public String printPredictionsForTrainingData(String title, String targetName, int stepAhead) throws Exception {
        return this.printPredictionsForTrainingData(title, targetName, stepAhead, 0);
    }

    public String printPredictionsForTrainingData(String title, String targetName, int stepAhead, int instanceNumberOffset) throws Exception {
        ErrorModule predsForStep = this.getPredictionsForTrainingData(stepAhead);
        List<NumericPrediction> preds = predsForStep.getPredictionsForTarget(targetName);
        return this.printPredictions(title, preds, stepAhead, instanceNumberOffset);
    }

    public String printPredictionsForTestData(String title, String targetName, int stepAhead) throws Exception {
        return this.printPredictionsForTestData(title, targetName, stepAhead, 0);
    }

    public String printPredictionsForTestData(String title, String targetName, int stepAhead, int instanceNumberOffset) throws Exception {
        ErrorModule predsForStep = this.getPredictionsForTestData(stepAhead);
        List<NumericPrediction> preds = predsForStep.getPredictionsForTarget(targetName);
        return this.printPredictions(title, preds, stepAhead, instanceNumberOffset);
    }

    protected String printPredictions(String title, List<NumericPrediction> preds, int stepAhead, int instanceNumberOffset) {
        StringBuffer temp = new StringBuffer();
        boolean hasConfidenceIntervals = false;
        int maxColWidth = "predictions".length();
        int maxConfWidth = "interval".length();
        for (NumericPrediction p : preds) {
            double[][] conf;
            if (!weka.core.Utils.isMissingValue((double)p.actual())) {
                maxColWidth = TSEvaluation.maxWidth(maxColWidth, p.actual());
            }
            if (!weka.core.Utils.isMissingValue((double)p.predicted())) {
                maxColWidth = TSEvaluation.maxWidth(maxColWidth, p.predicted());
            }
            if ((conf = p.predictionIntervals()).length <= 0) continue;
            hasConfidenceIntervals = true;
            maxConfWidth = TSEvaluation.maxWidth(maxConfWidth, conf[0][0]);
            maxConfWidth = TSEvaluation.maxWidth(maxConfWidth, conf[0][1]);
        }
        maxConfWidth = maxConfWidth * 2 + 1;
        temp.append(title + "\n\n");
        temp.append(TSEvaluation.pad("inst#", " ", maxColWidth, true) + "  ");
        temp.append(TSEvaluation.pad("actual", " ", maxColWidth, true) + "  ");
        temp.append(TSEvaluation.pad("predicted", " ", maxColWidth, true) + "  ");
        if (hasConfidenceIntervals) {
            temp.append(TSEvaluation.pad("conf", " ", maxConfWidth, true) + "  ");
        }
        temp.append(TSEvaluation.pad("error", " ", maxColWidth, true) + "\n");
        for (int i = 0; i < preds.size(); ++i) {
            NumericPrediction pred = preds.get(i);
            String instNum = TSEvaluation.pad("" + (instanceNumberOffset + i + stepAhead), " ", maxColWidth, true);
            temp.append(instNum + "  ");
            double actual = pred.actual();
            String actualS = null;
            if (weka.core.Utils.isMissingValue((double)actual)) {
                actualS = TSEvaluation.pad("?", " ", maxColWidth, true);
            } else {
                actualS = weka.core.Utils.doubleToString((double)actual, (int)4);
                actualS = TSEvaluation.pad(actualS, " ", maxColWidth, true);
            }
            temp.append(actualS + "  ");
            double predicted = pred.predicted();
            String predictedS = null;
            if (weka.core.Utils.isMissingValue((double)predicted)) {
                predictedS = TSEvaluation.pad("?", " ", maxColWidth, true);
            } else {
                predictedS = weka.core.Utils.doubleToString((double)predicted, (int)4);
                predictedS = TSEvaluation.pad(predictedS, " ", maxColWidth, true);
            }
            temp.append(predictedS + "  ");
            if (hasConfidenceIntervals) {
                double[][] limits = pred.predictionIntervals();
                double low = limits[0][0];
                double high = limits[0][1];
                String limitsS = weka.core.Utils.doubleToString((double)low, (int)3) + ":" + weka.core.Utils.doubleToString((double)high, (int)3);
                limitsS = TSEvaluation.pad(limitsS, " ", maxConfWidth, true);
                temp.append(limitsS).append("  ");
            }
            double error = pred.error();
            String errorS = null;
            if (weka.core.Utils.isMissingValue((double)error)) {
                errorS = TSEvaluation.pad("?", " ", maxColWidth, true);
            } else {
                errorS = weka.core.Utils.doubleToString((double)error, (int)4);
                errorS = TSEvaluation.pad(errorS, " ", maxColWidth, true);
            }
            temp.append(errorS + "\n");
        }
        return temp.toString();
    }

    private static String pad(String source, String padChar, int length, boolean leftPad) {
        StringBuffer temp = new StringBuffer();
        if ((length -= source.length()) > 0) {
            if (leftPad) {
                for (int i = 0; i < length; ++i) {
                    temp.append(padChar);
                }
                temp.append(source);
            } else {
                temp.append(source);
                for (int i = 0; i < length; ++i) {
                    temp.append(padChar);
                }
            }
        } else {
            temp.append(source);
        }
        return temp.toString();
    }

    private static int maxWidth(int maxWidth, double value) {
        double width = Math.log(Math.abs(value)) / Math.log(10.0);
        if (width < 0.0) {
            width = 1.0;
        }
        if ((int)(width += 6.0) > maxWidth) {
            maxWidth = (int)width;
        }
        return maxWidth;
    }

    public String toSummaryString() throws Exception {
        double[] metricsForTargets;
        List<TSEvalModule> evalsForKey;
        Set<String> keys;
        StringBuffer result = new StringBuffer();
        int maxWidth = "10-steps-ahead".length() + 1;
        int maxWidthForLeftCol = "Target".length();
        List<String> targetFieldNames = null;
        if (this.m_evaluateTrainingData) {
            keys = this.m_metricsForTrainingData.keySet();
            for (String key : keys) {
                evalsForKey = this.m_metricsForTrainingData.get(key);
                for (TSEvalModule e : evalsForKey) {
                    if (targetFieldNames == null) {
                        targetFieldNames = e.getTargetFields();
                    }
                    for (double m : metricsForTargets = e.calculateMeasure()) {
                        maxWidth = TSEvaluation.maxWidth(maxWidth, m);
                    }
                }
            }
        }
        if (this.m_evaluateTestData) {
            keys = this.m_metricsForTestData.keySet();
            for (String key : keys) {
                evalsForKey = this.m_metricsForTestData.get(key);
                for (TSEvalModule e : evalsForKey) {
                    if (targetFieldNames == null) {
                        targetFieldNames = e.getTargetFields();
                    }
                    for (double m : metricsForTargets = e.calculateMeasure()) {
                        maxWidth = TSEvaluation.maxWidth(maxWidth, m);
                    }
                }
            }
        }
        for (String targetName : targetFieldNames) {
            if (targetName.length() <= maxWidthForLeftCol) continue;
            maxWidthForLeftCol = targetName.length();
        }
        for (TSEvalModule mod : this.m_evalModules) {
            if (mod.getDescription().length() + 2 <= maxWidthForLeftCol) continue;
            maxWidthForLeftCol = mod.getDescription().length() + 2;
        }
        if (this.m_missingTimeStampTestSetRows != null && this.m_missingTimeStampTestSetRows.size() > 0) {
            result.append("\n--------------------------------------------------\nInstances were inserted in the test data for the following\ntime-stamps (target values set by interpolation):\n\n");
            for (int i = 0; i < this.m_missingTimeStampTestSetRows.size(); ++i) {
                if (i == 0) {
                    result.append("              " + this.m_missingTimeStampTestSetRows.get(i));
                    continue;
                }
                result.append(", " + this.m_missingTimeStampTestSetRows.get(i));
            }
            result.append("\n--------------------------------------------------\n");
        }
        if (this.m_missingTargetListTestSet != null && this.m_missingTargetListTestSet.size() > 0) {
            Collections.sort(this.m_missingTargetListTestSet);
            result.append("\n---------------------------------------------------\nThe following test instances had missing values\nimputed via interpolation. Check source data as\nthis may affect forecasting performance:\n\n");
            for (int i = 0; i < this.m_missingTargetListTestSet.size(); ++i) {
                if (i == 0) {
                    result.append("              " + this.m_missingTargetListTestSet.get(i));
                    continue;
                }
                if (this.m_missingTargetListTestSet.get(i).equals(this.m_missingTargetListTestSet.get(i - 1))) continue;
                result.append("," + this.m_missingTargetListTestSet.get(i));
            }
            result.append("\n---------------------------------------------------\n");
        }
        if (this.m_missingTimeStampListTestSet != null && this.m_missingTimeStampListTestSet.size() > 0) {
            Collections.sort(this.m_missingTimeStampListTestSet);
            result.append("\n--------------------------------------------------------\nThe following test instances had missing time stamps:\n\n");
            for (int i = 0; i < this.m_missingTimeStampListTestSet.size(); ++i) {
                if (i == 0) {
                    result.append("              " + this.m_missingTimeStampListTestSet.get(i));
                    continue;
                }
                result.append("," + this.m_missingTimeStampListTestSet.get(i));
            }
            result.append("\n-------------------------------------------------------\n");
        }
        if (this.m_evaluateTrainingData) {
            String temp = this.summaryMetrics(maxWidthForLeftCol, maxWidth, targetFieldNames, this.m_metricsForTrainingData);
            result.append("=== Evaluation on training data ===\n");
            result.append(temp).append("\n");
            result.append("Total number of instances: " + this.m_trainingData.numInstances()).append("\n\n");
        }
        if (this.m_evaluateTestData) {
            String temp = this.summaryMetrics(maxWidthForLeftCol, maxWidth, targetFieldNames, this.m_metricsForTestData);
            result.append("=== Evaluation on test data ===\n");
            result.append(temp).append("\n");
            result.append("Total number of instances: " + this.m_testData.numInstances()).append("\n\n");
        }
        return result.toString();
    }

    private String summaryMetrics(int maxWidthForLeftCol, int maxWidth, List<String> targetFieldNames, Map<String, List<TSEvalModule>> metricsToUse) throws Exception {
        int i;
        StringBuffer temp = new StringBuffer();
        temp.append(TSEvaluation.pad("Target", " ", maxWidthForLeftCol, false));
        for (i = 0; i < this.m_horizon; ++i) {
            String stepS = i == 0 ? "step-ahead" : "steps-ahead";
            temp.append(TSEvaluation.pad("" + (i + 1) + "-" + stepS, " ", maxWidth, true));
        }
        temp.append("\n");
        temp.append(TSEvaluation.pad("=", "=", maxWidthForLeftCol + this.m_horizon * maxWidth, true));
        temp.append("\n");
        for (i = 0; i < targetFieldNames.size(); ++i) {
            temp.append(targetFieldNames.get(i) + "\n");
            if (this.m_evalModules.get(1) instanceof ErrorModule) {
                String tempKey = this.m_evalModules.get(1).getEvalName();
                temp.append(TSEvaluation.pad("  N", " ", maxWidthForLeftCol, false));
                List<TSEvalModule> metricForSteps = metricsToUse.get(tempKey);
                for (TSEvalModule m : metricForSteps) {
                    double[] countsForTargets = ((ErrorModule)m).countsForTargets();
                    double countForTarget = countsForTargets[i];
                    temp.append(TSEvaluation.pad(weka.core.Utils.doubleToString((double)countForTarget, (int)0), " ", maxWidth, true));
                }
                temp.append("\n");
            }
            Set<String> keys = metricsToUse.keySet();
            for (String key : keys) {
                String metricName = "  " + metricsToUse.get(key).get(0).getDescription();
                List<TSEvalModule> metricForSteps = metricsToUse.get(key);
                temp.append(TSEvaluation.pad(metricName, " ", maxWidthForLeftCol, false));
                for (TSEvalModule m : metricForSteps) {
                    double[] metricsForTargets = m.calculateMeasure();
                    double metricForTargetI = metricsForTargets[i];
                    String result = weka.core.Utils.isMissingValue((double)metricForTargetI) ? "N/A" : weka.core.Utils.doubleToString((double)metricForTargetI, (int)4);
                    temp.append(TSEvaluation.pad(result, " ", maxWidth, true));
                }
                temp.append("\n");
            }
        }
        return temp.toString();
    }
}

