/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.beans;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.Customizer;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.ObjectInputStream;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import weka.classifiers.timeseries.WekaForecaster;
import weka.core.Environment;
import weka.core.Instances;
import weka.gui.PropertySheetPanel;
import weka.gui.beans.CustomizerCloseRequester;
import weka.gui.beans.CustomizerClosingListener;
import weka.gui.beans.EnvironmentField;
import weka.gui.beans.FileEnvironmentField;
import weka.gui.beans.TimeSeriesForecasting;

public class TimeSeriesForecastingCustomizer
extends JPanel
implements Customizer,
CustomizerClosingListener,
CustomizerCloseRequester {
    private static final long serialVersionUID = -8638861579301145591L;
    protected TimeSeriesForecasting m_forecaster = null;
    protected WekaForecaster m_forecastingModel = null;
    protected Instances m_header;
    protected FileEnvironmentField m_filenameField = new FileEnvironmentField();
    protected JLabel m_numStepsLab;
    protected EnvironmentField m_numStepsToForecast = new EnvironmentField();
    protected JLabel m_artificialLab;
    protected EnvironmentField m_artificialOffset = new EnvironmentField();
    protected JCheckBox m_rebuildForecasterCheck = new JCheckBox();
    protected JLabel m_saveLab;
    protected FileEnvironmentField m_saveFilenameField = new FileEnvironmentField();
    protected JTextArea m_modelDisplay = new JTextArea(20, 60);
    protected PropertySheetPanel m_sheetPanel = new PropertySheetPanel();
    protected transient Environment m_env = Environment.getSystemWide();
    protected Window m_parentWindow;

    public TimeSeriesForecastingCustomizer() {
        this.setLayout(new BorderLayout());
        this.m_filenameField.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (TimeSeriesForecasting.isEmpty(TimeSeriesForecastingCustomizer.this.m_filenameField.getText())) {
                    return;
                }
                TimeSeriesForecastingCustomizer.this.loadModel();
                if (TimeSeriesForecastingCustomizer.this.m_forecastingModel != null) {
                    TimeSeriesForecastingCustomizer.this.m_modelDisplay.setText(TimeSeriesForecastingCustomizer.this.m_forecastingModel.toString());
                    TimeSeriesForecastingCustomizer.this.checkIfModelIsUsingArtificialTimeStamp();
                    TimeSeriesForecastingCustomizer.this.checkIfModelIsUsingOverlayData();
                }
            }
        });
    }

    @Override
    public void setObject(Object object) {
        this.setupLayout();
        this.m_forecaster = (TimeSeriesForecasting)object;
        this.m_sheetPanel.setTarget((Object)this.m_forecaster);
        String loadFilename = this.m_forecaster.getFilename();
        if (!TimeSeriesForecasting.isEmpty(loadFilename) && !loadFilename.equals("-NONE-")) {
            this.m_filenameField.setText(loadFilename);
            this.loadModel();
        } else {
            String encodedForecaster = this.m_forecaster.getEncodedForecaster();
            if (!TimeSeriesForecasting.isEmpty(encodedForecaster) && !encodedForecaster.equals("-NONE-")) {
                try {
                    List<Object> model = TimeSeriesForecasting.getForecaster(encodedForecaster);
                    if (model != null) {
                        this.m_forecastingModel = (WekaForecaster)model.get(0);
                        this.m_header = (Instances)model.get(1);
                        this.m_modelDisplay.setText(this.m_forecastingModel.toString());
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
        if (!TimeSeriesForecasting.isEmpty(this.m_forecaster.getSaveFilename())) {
            this.m_saveFilenameField.setText(this.m_forecaster.getSaveFilename());
        }
        this.m_numStepsToForecast.setText(this.m_forecaster.getNumStepsToForecast());
        this.m_artificialOffset.setText(this.m_forecaster.getArtificialTimeStartOffset());
        this.m_rebuildForecasterCheck.setSelected(this.m_forecaster.getRebuildForecaster());
        this.m_saveLab.setEnabled(this.m_rebuildForecasterCheck.isSelected());
        this.m_saveFilenameField.setEnabled(this.m_rebuildForecasterCheck.isSelected());
        this.checkIfModelIsUsingArtificialTimeStamp();
        this.checkIfModelIsUsingOverlayData();
    }

    private void checkIfModelIsUsingArtificialTimeStamp() {
        if (this.m_forecastingModel != null) {
            boolean usingA = this.m_forecastingModel.getTSLagMaker().isUsingAnArtificialTimeIndex();
            this.m_artificialLab.setEnabled(usingA);
            this.m_artificialOffset.setEnabled(usingA);
        }
    }

    private void checkIfModelIsUsingOverlayData() {
        if (this.m_forecastingModel != null) {
            if (this.m_forecastingModel.isUsingOverlayData()) {
                this.m_numStepsToForecast.setEnabled(false);
                this.m_numStepsLab.setEnabled(false);
                this.m_numStepsToForecast.setText("");
            } else {
                this.m_numStepsToForecast.setEnabled(true);
                this.m_numStepsLab.setEnabled(true);
            }
        }
    }

    private void setupLayout() {
        this.removeAll();
        JTabbedPane tabHolder = new JTabbedPane();
        JPanel modelFilePanel = new JPanel();
        modelFilePanel.setLayout(new BorderLayout());
        JPanel tempP1 = new JPanel();
        tempP1.setLayout(new GridLayout(5, 2));
        JLabel fileLab = new JLabel("Load/import forecaster", 4);
        tempP1.add(fileLab);
        tempP1.add((Component)this.m_filenameField);
        this.m_numStepsLab = new JLabel("Number of steps to forecast", 4);
        tempP1.add(this.m_numStepsLab);
        tempP1.add((Component)this.m_numStepsToForecast);
        this.m_artificialLab = new JLabel("Number of historical instances beyond end of training data", 4);
        tempP1.add(this.m_artificialLab);
        tempP1.add((Component)this.m_artificialOffset);
        JLabel rebuildLab = new JLabel("Rebuild/reestimate on incoming data", 4);
        tempP1.add(rebuildLab);
        tempP1.add(this.m_rebuildForecasterCheck);
        this.m_saveLab = new JLabel("Save forecaster", 4);
        tempP1.add(this.m_saveLab);
        tempP1.add((Component)this.m_saveFilenameField);
        modelFilePanel.add((Component)tempP1, "North");
        tabHolder.addTab("Model file", modelFilePanel);
        this.add((Component)tabHolder, "Center");
        JPanel modelPanel = new JPanel();
        modelPanel.setLayout(new BorderLayout());
        this.m_modelDisplay.setEditable(false);
        this.m_modelDisplay.setFont(new Font("Monospaced", 0, 12));
        this.m_modelDisplay.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        JScrollPane scrollPane = new JScrollPane(this.m_modelDisplay);
        modelPanel.add((Component)scrollPane, "Center");
        tabHolder.addTab("Model", modelPanel);
        JButton okBut = new JButton("OK");
        JButton cancelBut = new JButton("Cancel");
        JPanel butHolder1 = new JPanel();
        butHolder1.setLayout(new GridLayout(1, 2));
        butHolder1.add(okBut);
        butHolder1.add(cancelBut);
        JPanel butHolder2 = new JPanel();
        butHolder2.setLayout(new GridLayout(1, 3));
        butHolder2.add(new JPanel());
        butHolder2.add(butHolder1);
        butHolder2.add(new JPanel());
        this.add((Component)butHolder2, "South");
        cancelBut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TimeSeriesForecastingCustomizer.this.m_parentWindow.dispose();
            }
        });
        okBut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TimeSeriesForecastingCustomizer.this.customizerClosing();
                TimeSeriesForecastingCustomizer.this.m_parentWindow.dispose();
            }
        });
        this.m_saveLab.setEnabled(false);
        this.m_saveFilenameField.setEnabled(false);
        this.m_rebuildForecasterCheck.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TimeSeriesForecastingCustomizer.this.m_saveFilenameField.setEnabled(TimeSeriesForecastingCustomizer.this.m_rebuildForecasterCheck.isSelected());
                TimeSeriesForecastingCustomizer.this.m_saveLab.setEnabled(TimeSeriesForecastingCustomizer.this.m_rebuildForecasterCheck.isSelected());
            }
        });
    }

    private void loadModel() {
        if (!TimeSeriesForecasting.isEmpty(this.m_filenameField.getText())) {
            try {
                String filename = this.m_filenameField.getText();
                try {
                    if (this.m_env == null) {
                        this.m_env = Environment.getSystemWide();
                    }
                    filename = this.m_env.substitute(filename);
                }
                catch (Exception ex) {
                    // empty catch block
                }
                File theFile = new File(filename);
                if (theFile.isFile()) {
                    ObjectInputStream is = new ObjectInputStream(new BufferedInputStream(new FileInputStream(filename)));
                    this.m_forecastingModel = (WekaForecaster)is.readObject();
                    this.m_header = (Instances)is.readObject();
                    is.close();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public void setEnvironment(Environment env) {
        this.m_env = env;
        this.m_filenameField.setEnvironment(env);
        this.m_numStepsToForecast.setEnvironment(env);
        this.m_artificialOffset.setEnvironment(env);
        this.m_saveFilenameField.setEnvironment(env);
    }

    public void customizerClosing() {
        if (this.m_forecaster != null) {
            if (!TimeSeriesForecasting.isEmpty(this.m_filenameField.getText())) {
                this.m_forecaster.setFilename(this.m_filenameField.getText());
                this.m_forecaster.setEncodedForecaster("-NONE-");
            } else if (this.m_forecastingModel != null) {
                try {
                    String encodedModel = TimeSeriesForecasting.encodeForecasterToBase64(this.m_forecastingModel, this.m_header);
                    this.m_forecaster.setFilename("-NONE-");
                    this.m_forecaster.setEncodedForecaster(encodedModel);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            this.m_forecaster.setRebuildForecaster(this.m_rebuildForecasterCheck.isSelected());
            this.m_forecaster.setNumStepsToForecast(this.m_numStepsToForecast.getText());
            this.m_forecaster.setArtificialTimeStartOffset(this.m_artificialOffset.getText());
            if (this.m_rebuildForecasterCheck.isSelected() && !TimeSeriesForecasting.isEmpty(this.m_saveFilenameField.getText())) {
                this.m_forecaster.setSaveFilename(this.m_saveFilenameField.getText());
            } else {
                this.m_forecaster.setSaveFilename("");
            }
        }
    }

    public void setParentWindow(Window parent) {
        this.m_parentWindow = parent;
    }
}

