/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.sink;

import adams.core.Index;
import adams.flow.core.Token;
import adams.flow.sink.AbstractGraphicalDisplay;
import adams.gui.core.BasePanel;
import adams.gui.visualization.stats.histogram.HistogramOptions;
import weka.core.Instances;

public class Histogram
extends AbstractGraphicalDisplay {
    private static final long serialVersionUID = 8145699633341614296L;
    protected Index m_Index;
    protected String m_DataName;
    protected HistogramOptions m_Options;

    public String globalInfo() {
        return "Generates a histogram based on the incoming data.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("index", "index", (Object)new Index("first"));
        this.m_OptionManager.add("data-name", "dataName", (Object)"");
        this.m_OptionManager.add("options", "options", (Object)new HistogramOptions());
    }

    public void setIndex(Index value) {
        this.m_Index = value;
        this.reset();
    }

    public Index getIndex() {
        return this.m_Index;
    }

    public String indexTipText() {
        return "The attribute index in case of Instances being displayed.";
    }

    public void setDataName(String value) {
        this.m_DataName = value;
        this.reset();
    }

    public String getDataName() {
        return this.m_DataName;
    }

    public String dataNameTipText() {
        return "The name to display on the x-axis, overrides the attribute name obtained from the Instances.";
    }

    public void setOptions(HistogramOptions value) {
        this.m_Options = value;
        this.reset();
    }

    public HistogramOptions getOptions() {
        return this.m_Options;
    }

    public String optionsTipText() {
        return "The display options for the histogram.";
    }

    public Class[] accepts() {
        return new Class[]{Double[].class, Instances.class};
    }

    protected void display(Token token) {
        adams.gui.visualization.stats.histogram.Histogram hist = (adams.gui.visualization.stats.histogram.Histogram)this.m_Panel;
        if (token.getPayload() instanceof Instances) {
            Instances inst = (Instances)token.getPayload();
            this.m_Index.setMax(inst.numAttributes());
            hist.setInstances(inst);
            hist.setIndex(this.m_Index.getIntIndex());
        } else {
            hist.setArray((Double[])token.getPayload());
        }
        hist.setDataName(this.m_DataName);
        hist.update();
    }

    public void clearPanel() {
        if (this.m_Panel != null) {
            adams.gui.visualization.stats.histogram.Histogram hist = (adams.gui.visualization.stats.histogram.Histogram)this.m_Panel;
            hist.setInstances(null);
            hist.setArray(null);
            hist.update();
        }
    }

    protected BasePanel newPanel() {
        adams.gui.visualization.stats.histogram.Histogram result = new adams.gui.visualization.stats.histogram.Histogram();
        result.setOptions(this.m_Options);
        return result;
    }
}

