/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.sink;

import adams.data.instance.Instance;
import adams.data.report.AbstractField;
import adams.data.report.DataType;
import adams.data.report.Field;
import adams.flow.core.Token;
import adams.flow.sink.AbstractDisplayPanel;
import adams.flow.sink.AbstractGraphicalDisplay;
import adams.flow.sink.AbstractTextDisplayPanel;
import adams.flow.sink.DisplayPanelProvider;
import adams.flow.sink.TextSupplier;
import adams.gui.core.BasePanel;
import adams.gui.core.ExtensionFileFilter;
import adams.gui.visualization.instance.InstanceContainer;
import adams.gui.visualization.instance.InstanceContainerManager;
import adams.gui.visualization.instance.InstancePanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import weka.core.Attribute;
import weka.core.Instances;

public class WekaInstanceViewer
extends AbstractGraphicalDisplay
implements DisplayPanelProvider,
TextSupplier {
    private static final long serialVersionUID = 1283926389472133810L;
    protected InstancePanel m_InstancePanel;
    protected boolean m_ZoomOverview;
    protected String m_ID;

    public String globalInfo() {
        return "Actor for displaying adams.data.instance.Instance objects in a graphical way (using the internal format), like the 'Instance Explorer' tool.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("zoom-overview", "zoomOverview", (Object)false);
        this.m_OptionManager.add("id", "ID", (Object)"");
    }

    protected int getDefaultWidth() {
        return 800;
    }

    protected int getDefaultHeight() {
        return 500;
    }

    public void setZoomOverview(boolean value) {
        this.m_ZoomOverview = value;
        this.reset();
    }

    public boolean getZoomOverview() {
        return this.m_ZoomOverview;
    }

    public String zoomOverviewTipText() {
        return "If enabled, a zoom overview panel gets displayed as well.";
    }

    public void setID(String value) {
        this.m_ID = value;
        this.reset();
    }

    public String getID() {
        return this.m_ID;
    }

    public String IDTipText() {
        return "The name of the attribute/field to use as the ID in the display.";
    }

    public void clearPanel() {
        if (this.m_InstancePanel != null) {
            ((InstanceContainerManager)this.m_InstancePanel.getContainerManager()).clear();
        }
    }

    protected BasePanel newPanel() {
        BasePanel result = new BasePanel((LayoutManager)new BorderLayout());
        this.m_InstancePanel = new InstancePanel();
        this.m_InstancePanel.setZoomOverviewPanelVisible(this.m_ZoomOverview);
        result.add((Component)((Object)this.m_InstancePanel), (Object)"Center");
        return result;
    }

    public Class[] accepts() {
        return new Class[]{weka.core.Instance.class, Instance.class};
    }

    protected void display(Token token) {
        Instance inst;
        if (token.getPayload() instanceof weka.core.Instance) {
            Attribute att;
            weka.core.Instance winst = (weka.core.Instance)token.getPayload();
            inst = new Instance();
            inst.set(winst);
            if (!this.m_ID.isEmpty() && (att = winst.dataset().attribute(this.m_ID)) != null) {
                String id = att.isNominal() || att.isString() ? winst.stringValue(att.index()) : "" + winst.value(att.index());
                inst.setID(id);
            }
        } else {
            inst = (Instance)((Object)token.getPayload());
            if (inst.hasReport() && inst.getReport().hasValue(this.m_ID)) {
                inst.setID("" + inst.getReport().getValue((AbstractField)new Field(this.m_ID, DataType.UNKNOWN)));
            }
        }
        InstanceContainerManager manager = (InstanceContainerManager)this.m_InstancePanel.getContainerManager();
        InstanceContainer cont = manager.newContainer((Comparable)((Object)inst));
        manager.add(cont);
    }

    protected void cleanUpGUI() {
        super.cleanUpGUI();
        if (this.m_InstancePanel != null) {
            ((InstanceContainerManager)this.m_InstancePanel.getContainerManager()).clear();
        }
    }

    public AbstractDisplayPanel createDisplayPanel(Token token) {
        AbstractTextDisplayPanel result = new AbstractTextDisplayPanel(((Object)((Object)this)).getClass().getSimpleName()){
            private static final long serialVersionUID = -5618543590920864397L;
            protected InstancePanel m_InstancePanel;

            protected void initGUI() {
                super.initGUI();
                this.setLayout(new BorderLayout());
                this.m_InstancePanel = new InstancePanel();
                this.add((Component)((Object)this.m_InstancePanel), "Center");
            }

            public void display(Token token) {
                Instance inst = null;
                if (token.getPayload() instanceof weka.core.Instance) {
                    inst = new Instance();
                    inst.set((weka.core.Instance)token.getPayload());
                } else {
                    inst = (Instance)((Object)token.getPayload());
                }
                InstanceContainerManager manager = (InstanceContainerManager)this.m_InstancePanel.getContainerManager();
                InstanceContainer cont = manager.newContainer((Comparable)((Object)inst));
                manager.add(cont);
            }

            public ExtensionFileFilter getCustomTextFileFilter() {
                return new ExtensionFileFilter("ARFF file", "arff");
            }

            public String supplyText() {
                return WekaInstanceViewer.supplyText(this.m_InstancePanel);
            }

            public void clearPanel() {
                ((InstanceContainerManager)this.m_InstancePanel.getContainerManager()).clear();
            }

            public void cleanUp() {
                ((InstanceContainerManager)this.m_InstancePanel.getContainerManager()).clear();
            }
        };
        if (token != null) {
            result.display(token);
        }
        return result;
    }

    public ExtensionFileFilter getCustomTextFileFilter() {
        return new ExtensionFileFilter("ARFF file", "arff");
    }

    public String supplyText() {
        return WekaInstanceViewer.supplyText(this.m_InstancePanel);
    }

    protected static String supplyText(InstancePanel panel) {
        if (panel == null) {
            return null;
        }
        InstanceContainerManager manager = (InstanceContainerManager)panel.getContainerManager();
        if (manager.countVisible() == 0) {
            return null;
        }
        Instances data = new Instances(manager.getVisible(0).getData().getDatasetHeader());
        for (int i = 0; i < manager.countVisible(); ++i) {
            data.add(manager.getVisible(i).getData().toInstance());
        }
        return data.toString();
    }

    public boolean displayPanelRequiresScrollPane() {
        return true;
    }
}

