/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.DateFormat;
import adams.core.DateUtils;
import adams.core.Index;
import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.data.spreadsheet.DataRow;
import adams.data.spreadsheet.HeaderRow;
import adams.data.spreadsheet.SpreadSheet;
import adams.data.weka.WekaAttributeIndex;
import adams.flow.core.DataInfoActor;
import adams.flow.core.Token;
import adams.flow.transformer.AbstractTransformer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import weka.core.Attribute;
import weka.core.AttributeStats;
import weka.core.Instances;

public class WekaInstancesInfo
extends AbstractTransformer
implements DataInfoActor {
    private static final long serialVersionUID = -3019442578354930841L;
    protected List m_Queue;
    protected InfoType m_Type;
    protected WekaAttributeIndex m_AttributeIndex;
    protected Index m_ClassLabelIndex;
    protected DateFormat m_DateFormat;

    public String globalInfo() {
        return "Outputs statistics of a weka.core.Instances object.\n" + (Object)((Object)InfoType.FULL_ATTRIBUTE) + " and " + (Object)((Object)InfoType.FULL_CLASS) + " output " + "a spreadsheet with detailed attribute statistics. All others output " + "either strings, integers or doubles.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("type", "type", (Object)InfoType.FULL);
        this.m_OptionManager.add("attribute-index", "attributeIndex", (Object)new WekaAttributeIndex("last"));
        this.m_OptionManager.add("class-label-index", "classLabelIndex", (Object)new Index("first"));
    }

    protected void initialize() {
        super.initialize();
        this.m_Queue = new ArrayList();
    }

    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, (String)"type", (Object)((Object)this.m_Type));
        HashSet<InfoType> types = new HashSet<InfoType>(Arrays.asList(InfoType.FULL, InfoType.FULL_CLASS, InfoType.HEADER, InfoType.RELATION_NAME, InfoType.NUM_ATTRIBUTES, InfoType.NUM_INSTANCES, InfoType.NUM_CLASS_LABELS, InfoType.CLASS_TYPE, InfoType.CLASS_LABELS, InfoType.CLASS_LABEL_COUNT));
        if (QuickInfoHelper.hasVariable((OptionHandler)this, (String)"type") || !types.contains((Object)this.m_Type)) {
            result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"attributeIndex", (Object)((Object)this.m_AttributeIndex), (String)", index: ");
        }
        types = new HashSet<InfoType>(Arrays.asList(InfoType.LABEL_COUNT, InfoType.CLASS_LABEL_COUNT));
        if (QuickInfoHelper.hasVariable((OptionHandler)this, (String)"type") || types.contains((Object)this.m_Type)) {
            result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"classLabelIndex", (Object)this.m_ClassLabelIndex, (String)", label: ");
        }
        return result;
    }

    public void setType(InfoType value) {
        this.m_Type = value;
        this.reset();
    }

    public InfoType getType() {
        return this.m_Type;
    }

    public String typeTipText() {
        return "The type of information to generate; NB some of the types are only available for numeric or nominal attributes.";
    }

    public void setAttributeIndex(WekaAttributeIndex value) {
        this.m_AttributeIndex = value;
        this.reset();
    }

    public WekaAttributeIndex getAttributeIndex() {
        return this.m_AttributeIndex;
    }

    public String attributeIndexTipText() {
        return "The attribute index to use for generating attribute-specific information; " + this.m_AttributeIndex.getExample();
    }

    public void setClassLabelIndex(Index value) {
        this.m_ClassLabelIndex = value;
        this.reset();
    }

    public Index getClassLabelIndex() {
        return this.m_ClassLabelIndex;
    }

    public String classLabelIndexTipText() {
        return "The index of the class label to use; " + this.m_ClassLabelIndex.getExample();
    }

    public Class[] accepts() {
        return new Class[]{Instances.class};
    }

    public Class[] generates() {
        switch (this.m_Type) {
            case FULL: 
            case HEADER: 
            case RELATION_NAME: 
            case ATTRIBUTE_NAME: 
            case LABELS: 
            case CLASS_LABELS: 
            case ATTRIBUTE_TYPE: 
            case CLASS_TYPE: {
                return new Class[]{String.class};
            }
            case NUM_ATTRIBUTES: 
            case NUM_INSTANCES: 
            case NUM_CLASS_LABELS: 
            case NUM_LABELS: 
            case NUM_DISTINCT_VALUES: 
            case NUM_UNIQUE_VALUES: 
            case NUM_MISSING_VALUES: 
            case LABEL_COUNT: 
            case CLASS_LABEL_COUNT: {
                return new Class[]{Integer.class};
            }
            case MIN: 
            case MAX: 
            case MEAN: 
            case STDEV: {
                return new Class[]{Double.class};
            }
            case FULL_ATTRIBUTE: 
            case FULL_CLASS: {
                return new Class[]{SpreadSheet.class};
            }
        }
        throw new IllegalStateException("Unhandled info type: " + (Object)((Object)this.m_Type));
    }

    protected void addStatistic(SpreadSheet sheet, String name, Object value) {
        DataRow row = sheet.addRow();
        row.addCell("S").setContent(name);
        if (value instanceof String) {
            row.addCell("V").setContent((String)value);
        } else if (value instanceof Double) {
            row.addCell("V").setContent((Double)value);
        } else if (value instanceof Integer) {
            row.addCell("V").setContent((Integer)value);
        }
    }

    protected Object formatDate(double value) {
        if (this.m_DateFormat == null) {
            this.m_DateFormat = DateUtils.getTimestampFormatter();
        }
        return this.m_DateFormat.format(new Date((long)value));
    }

    protected SpreadSheet getAttributeStats(Instances data, int index) {
        SpreadSheet result = new SpreadSheet();
        result.setName("Attribute statistics - #" + (index + 1) + " " + data.attribute(index).name());
        HeaderRow row = result.getHeaderRow();
        row.addCell("S").setContent("Statistic");
        row.addCell("V").setContent("Value");
        Attribute att = data.attribute(index);
        if (att.isNominal()) {
            int i;
            AttributeStats stats = data.attributeStats(index);
            this.addStatistic(result, "Total", stats.totalCount);
            this.addStatistic(result, "Missing", stats.missingCount);
            this.addStatistic(result, "Unique", stats.uniqueCount);
            this.addStatistic(result, "Distinct", stats.distinctCount);
            this.addStatistic(result, "Integer-like", stats.intCount);
            this.addStatistic(result, "Float-like", stats.realCount);
            for (i = 0; i < stats.nominalCounts.length; ++i) {
                this.addStatistic(result, "Label-" + (i + 1) + "-" + att.value(i), stats.nominalCounts[i]);
            }
            for (i = 0; i < stats.nominalWeights.length; ++i) {
                this.addStatistic(result, "Weight-" + (i + 1) + "-" + att.value(i), stats.nominalWeights[i]);
            }
        } else if (att.isDate()) {
            if (this.m_DateFormat == null) {
                this.m_DateFormat = DateUtils.getTimestampFormatter();
            }
            AttributeStats stats = data.attributeStats(index);
            this.addStatistic(result, "Count", stats.numericStats.count);
            this.addStatistic(result, "Min", this.formatDate(stats.numericStats.min));
            this.addStatistic(result, "Max", this.formatDate(stats.numericStats.max));
            this.addStatistic(result, "Mean", this.formatDate(stats.numericStats.mean));
            this.addStatistic(result, "StdDev (in days)", stats.numericStats.stdDev / 1000.0 / 60.0 / 60.0 / 24.0);
        } else if (att.isNumeric()) {
            AttributeStats stats = data.attributeStats(index);
            this.addStatistic(result, "Count", stats.numericStats.count);
            this.addStatistic(result, "Min", stats.numericStats.min);
            this.addStatistic(result, "Max", stats.numericStats.max);
            this.addStatistic(result, "Mean", stats.numericStats.mean);
            this.addStatistic(result, "StdDev", stats.numericStats.stdDev);
            this.addStatistic(result, "Sum", stats.numericStats.sum);
            this.addStatistic(result, "Sum^2", stats.numericStats.sumSq);
        }
        return result;
    }

    protected String doExecute() {
        String result = null;
        Instances inst = (Instances)this.m_InputToken.getPayload();
        this.m_AttributeIndex.setData(inst);
        int index = this.m_AttributeIndex.getIntIndex();
        this.m_Queue.clear();
        switch (this.m_Type) {
            case FULL: {
                this.m_Queue.add(inst.toSummaryString());
                break;
            }
            case FULL_ATTRIBUTE: {
                this.m_Queue.add(this.getAttributeStats(inst, index));
                break;
            }
            case FULL_CLASS: {
                if (inst.classIndex() <= -1) break;
                this.m_Queue.add(this.getAttributeStats(inst, inst.classIndex()));
                break;
            }
            case HEADER: {
                this.m_Queue.add(new Instances(inst, 0).toString());
                break;
            }
            case RELATION_NAME: {
                this.m_Queue.add(inst.relationName());
                break;
            }
            case ATTRIBUTE_NAME: {
                if (index == -1) break;
                this.m_Queue.add(inst.attribute(index).name());
                break;
            }
            case LABELS: {
                if (index == -1) break;
                Enumeration enm = inst.attribute(index).enumerateValues();
                while (enm.hasMoreElements()) {
                    this.m_Queue.add(enm.nextElement());
                }
                break;
            }
            case CLASS_LABELS: {
                if (inst.classIndex() <= -1) break;
                Enumeration enm = inst.classAttribute().enumerateValues();
                while (enm.hasMoreElements()) {
                    this.m_Queue.add(enm.nextElement());
                }
                break;
            }
            case LABEL_COUNT: {
                if (index <= -1) break;
                this.m_ClassLabelIndex.setMax(inst.attribute(index).numValues());
                int labelIndex = this.m_ClassLabelIndex.getIntIndex();
                this.m_Queue.add(inst.attributeStats((int)index).nominalCounts[labelIndex]);
                break;
            }
            case CLASS_LABEL_COUNT: {
                if (inst.classIndex() <= -1) break;
                this.m_ClassLabelIndex.setMax(inst.classAttribute().numValues());
                int labelIndex = this.m_ClassLabelIndex.getIntIndex();
                this.m_Queue.add(inst.attributeStats((int)inst.classIndex()).nominalCounts[labelIndex]);
                break;
            }
            case NUM_ATTRIBUTES: {
                this.m_Queue.add(inst.numAttributes());
                break;
            }
            case NUM_INSTANCES: {
                this.m_Queue.add(inst.numInstances());
                break;
            }
            case NUM_CLASS_LABELS: {
                if (inst.classIndex() == -1 || !inst.classAttribute().isNominal()) break;
                this.m_Queue.add(inst.classAttribute().numValues());
                break;
            }
            case NUM_LABELS: {
                if (index == -1 || !inst.attribute(index).isNominal()) break;
                this.m_Queue.add(inst.attribute(index).numValues());
                break;
            }
            case NUM_DISTINCT_VALUES: {
                if (index == -1) break;
                this.m_Queue.add(inst.attributeStats((int)index).distinctCount);
                break;
            }
            case NUM_UNIQUE_VALUES: {
                if (index == -1) break;
                this.m_Queue.add(inst.attributeStats((int)index).uniqueCount);
                break;
            }
            case NUM_MISSING_VALUES: {
                if (index == -1) break;
                this.m_Queue.add(inst.attributeStats((int)index).missingCount);
                break;
            }
            case MIN: {
                if (index == -1 || !inst.attribute(index).isNumeric()) break;
                this.m_Queue.add(inst.attributeStats((int)index).numericStats.min);
                break;
            }
            case MAX: {
                if (index == -1 || !inst.attribute(index).isNumeric()) break;
                this.m_Queue.add(inst.attributeStats((int)index).numericStats.max);
                break;
            }
            case MEAN: {
                if (index == -1 || !inst.attribute(index).isNumeric()) break;
                this.m_Queue.add(inst.attributeStats((int)index).numericStats.mean);
                break;
            }
            case STDEV: {
                if (index == -1 || !inst.attribute(index).isNumeric()) break;
                this.m_Queue.add(inst.attributeStats((int)index).numericStats.stdDev);
                break;
            }
            case ATTRIBUTE_TYPE: {
                if (index == -1) break;
                this.m_Queue.add(Attribute.typeToString((Attribute)inst.attribute(index)));
                break;
            }
            case CLASS_TYPE: {
                if (inst.classIndex() == -1) break;
                this.m_Queue.add(Attribute.typeToString((Attribute)inst.classAttribute()));
                break;
            }
            default: {
                result = "Unhandled info type: " + (Object)((Object)this.m_Type);
            }
        }
        return result;
    }

    public Token output() {
        Token result = new Token(this.m_Queue.get(0));
        this.m_Queue.remove(0);
        return result;
    }

    public boolean hasPendingOutput() {
        return this.m_Queue.size() > 0;
    }

    public void wrapUp() {
        this.m_Queue.clear();
        super.wrapUp();
    }

    public static enum InfoType {
        FULL,
        FULL_ATTRIBUTE,
        FULL_CLASS,
        HEADER,
        RELATION_NAME,
        NUM_ATTRIBUTES,
        NUM_INSTANCES,
        NUM_CLASS_LABELS,
        ATTRIBUTE_NAME,
        LABELS,
        CLASS_LABELS,
        NUM_LABELS,
        NUM_MISSING_VALUES,
        NUM_DISTINCT_VALUES,
        NUM_UNIQUE_VALUES,
        LABEL_COUNT,
        CLASS_LABEL_COUNT,
        MIN,
        MAX,
        MEAN,
        STDEV,
        ATTRIBUTE_TYPE,
        CLASS_TYPE;

    }
}

