/*
 * Decompiled with CFR 0.152.
 */
package weka.filters.unsupervised.attribute;

import adams.core.Utils;
import adams.core.base.BaseRegExp;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import weka.core.Attribute;
import weka.core.Capabilities;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.Range;
import weka.core.RevisionUtils;
import weka.filters.AllFilter;
import weka.filters.Filter;
import weka.filters.SimpleBatchFilter;
import weka.filters.unsupervised.attribute.PartitionedMultiFilter;

public class MetaPartitionedMultiFilter
extends SimpleBatchFilter {
    private static final long serialVersionUID = 1054608438486826054L;
    protected BaseRegExp[] m_RegExp = new BaseRegExp[]{new BaseRegExp(".*")};
    protected Filter[] m_Filters = new Filter[]{new AllFilter()};
    protected boolean m_RemoveUnused = false;
    protected PartitionedMultiFilter m_ActualFilter = null;

    public String globalInfo() {
        return "With each specified filter, a regular expression is associated that defines the range of attributes to apply the filter to. This is used to configure a " + PartitionedMultiFilter.class.getName() + " " + "internally to filter that actual data.\n" + "Unused attributes can be discarded as well.";
    }

    public Enumeration listOptions() {
        Vector result = new Vector();
        Enumeration enm = super.listOptions();
        while (enm.hasMoreElements()) {
            result.add(enm.nextElement());
        }
        result.addElement(new Option("\tA filter to apply (can be specified multiple times).", "F", 1, "-F <classname [options]>"));
        result.addElement(new Option("\tA regular expression for matching attribute names\n\t(can be specified multiple times).\n\tFor each filter an expression must be supplied.", "R", 1, "-R <regexp>"));
        result.addElement(new Option("\tFlag for leaving unused attributes out of the output, by default\n\tthese are included in the filter output.", "U", 0, "-U"));
        return result.elements();
    }

    public void setOptions(String[] options) throws Exception {
        String tmpStr;
        super.setOptions(options);
        this.setRemoveUnused(weka.core.Utils.getFlag((String)"U", (String[])options));
        Vector<Object> objects = new Vector<Object>();
        while ((tmpStr = weka.core.Utils.getOption((String)"F", (String[])options)).length() != 0) {
            String[] options2 = weka.core.Utils.splitOptions((String)tmpStr);
            String classname = options2[0];
            options2[0] = "";
            objects.add(weka.core.Utils.forName(Filter.class, (String)classname, (String[])options2));
        }
        if (objects.size() == 0) {
            objects.add(new AllFilter());
        }
        this.setFilters(objects.toArray(new Filter[objects.size()]));
        objects = new Vector();
        while ((tmpStr = weka.core.Utils.getOption((String)"R", (String[])options)).length() != 0) {
            BaseRegExp regexp = new BaseRegExp(tmpStr);
            objects.add(regexp);
        }
        if (objects.size() == 0) {
            objects.add(new BaseRegExp(".*"));
        }
        this.setRegExp(objects.toArray(new BaseRegExp[objects.size()]));
        this.checkDimensions();
    }

    public String[] getOptions() {
        int i;
        Vector<String> result = new Vector<String>();
        String[] options = super.getOptions();
        for (i = 0; i < options.length; ++i) {
            result.add(options[i]);
        }
        if (this.getRemoveUnused()) {
            result.add("-U");
        }
        for (i = 0; i < this.getFilters().length; ++i) {
            result.add("-F");
            result.add(this.getFilterSpec(this.getFilter(i)));
        }
        for (i = 0; i < this.getRegExp().length; ++i) {
            result.add("-R");
            result.add(this.getRegExp(i).stringValue());
        }
        return result.toArray(new String[result.size()]);
    }

    protected void checkDimensions() throws Exception {
        if (this.getFilters().length != this.getRegExp().length) {
            throw new IllegalArgumentException("Number of filters (= " + this.getFilters().length + ") " + "and regular expressions (= " + this.getRegExp().length + ") don't match!");
        }
    }

    public void setRemoveUnused(boolean value) {
        this.m_RemoveUnused = value;
    }

    public boolean getRemoveUnused() {
        return this.m_RemoveUnused;
    }

    public String removeUnusedTipText() {
        return "If true then unused attributes (ones that are not covered by any of the ranges) will be removed from the output.";
    }

    public void setFilters(Filter[] filters) {
        this.m_Filters = filters;
        this.reset();
    }

    public Filter[] getFilters() {
        return this.m_Filters;
    }

    public String filtersTipText() {
        return "The base filters to be used.";
    }

    public Filter getFilter(int index) {
        return this.m_Filters[index];
    }

    protected String getFilterSpec(Filter filter) {
        String result;
        if (filter == null) {
            result = "";
        } else {
            result = filter.getClass().getName();
            if (filter instanceof OptionHandler) {
                result = result + " " + weka.core.Utils.joinOptions((String[])filter.getOptions());
            }
        }
        return result;
    }

    public void setRegExp(BaseRegExp[] value) {
        this.m_RegExp = value;
        this.reset();
    }

    public BaseRegExp[] getRegExp() {
        return this.m_RegExp;
    }

    public String regExpTipText() {
        return "The regular expressions defining the subsets for the filters.";
    }

    public BaseRegExp getRegExp(int index) {
        return this.m_RegExp[index];
    }

    public Capabilities getCapabilities() {
        Capabilities result = new PartitionedMultiFilter().getCapabilities();
        result.enable(Capabilities.Capability.NO_CLASS);
        return result;
    }

    public Capabilities getCapabilities(Instances data) {
        Capabilities result = new PartitionedMultiFilter().getCapabilities(data);
        result.enable(Capabilities.Capability.NO_CLASS);
        return result;
    }

    protected void reset() {
        super.reset();
        this.m_ActualFilter = null;
    }

    protected Instances determineOutputFormat(Instances inputFormat) throws Exception {
        if (!this.isFirstBatchDone()) {
            int i;
            if (inputFormat.numInstances() == 0) {
                return null;
            }
            HashMap indices = new HashMap();
            for (BaseRegExp r : this.m_RegExp) {
                indices.put(r, new ArrayList());
            }
            for (i = 0; i < inputFormat.numAttributes(); ++i) {
                Attribute att = inputFormat.attribute(i);
                for (BaseRegExp r : this.m_RegExp) {
                    if (!r.isMatch(att.name())) continue;
                    ((List)indices.get(r)).add(att.index() + 1);
                }
            }
            ArrayList<Range> ranges = new ArrayList<Range>();
            ArrayList<Filter> filters = new ArrayList<Filter>();
            for (i = 0; i < this.m_RegExp.length; ++i) {
                if (((List)indices.get(this.m_RegExp[i])).size() == 0) {
                    System.err.println("RegExp #" + (i + 1) + " (" + this.m_RegExp[i] + ") matched no attribute names!");
                    continue;
                }
                Object[] range = ((List)indices.get(this.m_RegExp[i])).toArray(new Integer[((List)indices.get(this.m_RegExp[i])).size()]);
                ranges.add(new Range(Utils.flatten((Object[])range, (String)",")));
                filters.add(Filter.makeCopy((Filter)this.m_Filters[i]));
            }
            this.m_ActualFilter = new PartitionedMultiFilter();
            this.m_ActualFilter.setRemoveUnused(this.m_RemoveUnused);
            this.m_ActualFilter.setFilters(filters.toArray(new Filter[filters.size()]));
            this.m_ActualFilter.setRanges(ranges.toArray(new Range[ranges.size()]));
            this.m_ActualFilter.setInputFormat(inputFormat);
            Filter.useFilter((Instances)inputFormat, (Filter)this.m_ActualFilter);
            return this.m_ActualFilter.getOutputFormat();
        }
        return this.getOutputFormat();
    }

    protected Instances process(Instances instances) throws Exception {
        if (!this.isFirstBatchDone()) {
            this.setOutputFormat(this.determineOutputFormat(instances));
        }
        return Filter.useFilter((Instances)instances, (Filter)this.m_ActualFilter);
    }

    public String getRevision() {
        return RevisionUtils.extract((String)"$Revision: 6875 $");
    }

    public static void main(String[] args) {
        MetaPartitionedMultiFilter.runFilter((Filter)new MetaPartitionedMultiFilter(), (String[])args);
    }
}

