/*
 * Decompiled with CFR 0.152.
 */
package weka.filters.unsupervised.attribute;

import weka.core.Capabilities;
import weka.core.DenseInstance;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.SparseInstance;
import weka.core.Utils;
import weka.filters.Filter;
import weka.filters.UnsupervisedFilter;
import weka.filters.unsupervised.attribute.PotentialClassIgnorer;

public class NormalizeAdaptive
extends PotentialClassIgnorer
implements UnsupervisedFilter {
    static final long serialVersionUID = -8158531150984262898L;
    private double[] m_MinArray;
    private double[] m_MaxArray;
    double m_fScale = 0.0;
    int m_classIndex = -1;

    public String globalInfo() {
        return "Normalizes all numeric values in the given dataset (apart from the class attribute, if set). The resulting values are in [0,1] for the data used to compute the normalization intervals. ";
    }

    public Capabilities getCapabilities() {
        Capabilities result = super.getCapabilities();
        result.enableAllAttributes();
        result.enable(Capabilities.Capability.MISSING_VALUES);
        result.enableAllClasses();
        result.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        result.enable(Capabilities.Capability.NO_CLASS);
        return result;
    }

    public boolean setInputFormat(Instances instanceInfo) throws Exception {
        super.setInputFormat(instanceInfo);
        this.setOutputFormat(instanceInfo);
        this.m_MaxArray = null;
        this.m_MinArray = null;
        return true;
    }

    public boolean input(Instance instance) {
        if (this.getInputFormat() == null) {
            throw new IllegalStateException("No input instance format defined");
        }
        if (this.m_NewBatch) {
            this.resetQueue();
            this.m_NewBatch = false;
        }
        if (this.m_MinArray == null) {
            this.bufferInput(instance);
            return false;
        }
        this.convertInstance(instance);
        return true;
    }

    public boolean batchFinished() {
        if (this.getInputFormat() == null) {
            throw new IllegalStateException("No input instance format defined");
        }
        if (this.m_MinArray == null) {
            int i;
            Instances input = this.getInputFormat();
            this.m_MinArray = new double[input.numAttributes()];
            this.m_MaxArray = new double[input.numAttributes()];
            for (int i2 = 0; i2 < input.numAttributes(); ++i2) {
                this.m_MinArray[i2] = Double.NaN;
            }
            for (int j = 0; j < input.numInstances(); ++j) {
                double[] value = input.instance(j).toDoubleArray();
                for (i = 0; i < input.numAttributes(); ++i) {
                    if (!input.attribute(i).isNumeric() || input.classIndex() == i || Utils.isMissingValue((double)value[i])) continue;
                    if (Double.isNaN(this.m_MinArray[i])) {
                        this.m_MinArray[i] = this.m_MaxArray[i] = value[i];
                        continue;
                    }
                    if (value[i] < this.m_MinArray[i]) {
                        this.m_MinArray[i] = value[i];
                    }
                    if (!(value[i] > this.m_MaxArray[i])) continue;
                    this.m_MaxArray[i] = value[i];
                }
            }
            int nAtts = input.numAttributes();
            int iClass = this.m_classIndex;
            for (i = 0; i < nAtts; ++i) {
                if (i == iClass) continue;
                double f0 = this.m_MinArray[i];
                double f1 = this.m_MaxArray[i];
                this.m_MinArray[i] = f0 - (f1 - f0) * (double)i * this.m_fScale / (double)nAtts;
                this.m_MaxArray[i] = f1 + (f1 - f0) * (double)i * this.m_fScale / (double)nAtts;
            }
            for (i = 0; i < input.numInstances(); ++i) {
                this.convertInstance(input.instance(i));
            }
        }
        this.flushInput();
        this.m_NewBatch = true;
        return this.numPendingOutput() != 0;
    }

    public void setScale(double fScale) {
        this.m_fScale = fScale;
    }

    public double getScale() {
        return this.m_fScale;
    }

    public void setClassIndex(int classIndex) {
        classIndex = this.m_classIndex;
    }

    public int getClassIndex() {
        return this.m_classIndex;
    }

    private void convertInstance(Instance instance) {
        DenseInstance inst = null;
        if (instance instanceof SparseInstance) {
            double[] newVals = new double[instance.numAttributes()];
            int[] newIndices = new int[instance.numAttributes()];
            double[] vals = instance.toDoubleArray();
            int ind = 0;
            for (int j = 0; j < instance.numAttributes(); ++j) {
                double value;
                if (instance.attribute(j).isNumeric() && !Utils.isMissingValue((double)vals[j]) && this.getInputFormat().classIndex() != j) {
                    value = Double.isNaN(this.m_MinArray[j]) || this.m_MaxArray[j] == this.m_MinArray[j] ? 0.0 : (vals[j] - this.m_MinArray[j]) / (this.m_MaxArray[j] - this.m_MinArray[j]);
                    if (value == 0.0) continue;
                    newVals[ind] = value;
                    newIndices[ind] = j;
                    ++ind;
                    continue;
                }
                value = vals[j];
                if (value == 0.0) continue;
                newVals[ind] = value;
                newIndices[ind] = j;
                ++ind;
            }
            double[] tempVals = new double[ind];
            int[] tempInd = new int[ind];
            System.arraycopy(newVals, 0, tempVals, 0, ind);
            System.arraycopy(newIndices, 0, tempInd, 0, ind);
            inst = new SparseInstance(instance.weight(), tempVals, tempInd, instance.numAttributes());
        } else {
            double[] vals = instance.toDoubleArray();
            for (int j = 0; j < this.getInputFormat().numAttributes(); ++j) {
                if (!instance.attribute(j).isNumeric() || Utils.isMissingValue((double)vals[j]) || this.getInputFormat().classIndex() == j) continue;
                vals[j] = Double.isNaN(this.m_MinArray[j]) || this.m_MaxArray[j] == this.m_MinArray[j] ? 0.0 : (vals[j] - this.m_MinArray[j]) / (this.m_MaxArray[j] - this.m_MinArray[j]);
            }
            inst = new DenseInstance(instance.weight(), vals);
        }
        inst.setDataset(instance.dataset());
        this.push((Instance)inst);
    }

    public static void main(String[] argv) {
        try {
            if (Utils.getFlag((char)'b', (String[])argv)) {
                Filter.batchFilterFile((Filter)new NormalizeAdaptive(), (String[])argv);
            } else {
                Filter.filterFile((Filter)new NormalizeAdaptive(), (String[])argv);
            }
        }
        catch (Exception ex) {
            System.out.println(ex.getMessage());
        }
    }

    public String getRevision() {
        return "1.0";
    }
}

