/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.experiment.ext;

import adams.core.DateUtils;
import java.io.File;
import java.util.Date;
import weka.gui.experiment.ext.AbstractExperimentRunner;
import weka.gui.experiment.ext.ExperimenterPanel;

public class DefaultExperimentRunner
extends AbstractExperimentRunner {
    private static final long serialVersionUID = -5499408120296699079L;

    public DefaultExperimentRunner(ExperimenterPanel owner) throws Exception {
        super(owner);
    }

    @Override
    protected void doRun() throws Exception {
        int errors = 0;
        this.showStatus("Iterating...");
        while (this.m_Running && this.m_Exp.hasMoreIterations()) {
            try {
                String current = "Iteration:";
                if (this.m_Exp.getUsePropertyIterator()) {
                    int cnum = this.m_Exp.getCurrentPropertyNumber();
                    String ctype = this.m_Exp.getPropertyArray().getClass().getComponentType().getName();
                    int lastDot = ctype.lastIndexOf(46);
                    if (lastDot != -1) {
                        ctype = ctype.substring(lastDot + 1);
                    }
                    String cname = " " + ctype + "=" + (cnum + 1) + ":" + this.m_Exp.getPropertyArrayValue(cnum).getClass().getName();
                    current = current + cname;
                }
                String dname = ((File)this.m_Exp.getDatasets().elementAt(this.m_Exp.getCurrentDatasetNumber())).getName();
                current = current + " Dataset=" + dname + " Run=" + this.m_Exp.getCurrentRunNumber();
                this.showStatus(current);
                this.m_Exp.nextIteration();
            }
            catch (Exception ex) {
                ++errors;
                this.logMessage(ex);
                ex.printStackTrace();
                boolean continueAfterError = false;
                if (continueAfterError) {
                    this.m_Exp.advanceCounters();
                    continue;
                }
                this.m_Running = false;
            }
        }
        this.showStatus("Postprocessing...");
        this.m_Exp.postProcess();
        if (!this.m_Running) {
            this.logMessage("Interrupted");
        } else {
            this.logMessage("Finished");
        }
        if (errors == 1) {
            this.logMessage("There was " + errors + " error");
        } else {
            this.logMessage("There were " + errors + " errors");
        }
        this.showStatus("Not running");
    }

    @Override
    protected void postRun() {
        super.postRun();
        this.m_Owner.finishExecution();
        this.update();
        this.m_Running = false;
        this.logMessage("Done!");
        this.logMessage("--> END: " + DateUtils.getTimestampFormatter().format(new Date()));
    }
}

