/*
 * Decompiled with CFR 0.152.
 */
package org.ddogleg.solver;

import org.ejml.data.DenseMatrix64F;
import org.ejml.data.Matrix64F;
import org.ejml.factory.LinearSolverFactory;
import org.ejml.interfaces.linsol.LinearSolver;

public class FitQuadratic3by3 {
    LinearSolver<DenseMatrix64F> solver = LinearSolverFactory.leastSquares((int)9, (int)6);
    DenseMatrix64F X = new DenseMatrix64F(6, 1);
    DenseMatrix64F Y = new DenseMatrix64F(9, 1);
    double deltaX;
    double deltaY;

    public FitQuadratic3by3() {
        DenseMatrix64F M = new DenseMatrix64F(9, 6);
        int index = 0;
        for (int i = -1; i <= 1; ++i) {
            int j = -1;
            while (j <= 1) {
                M.set(index, 0, (double)(j * j));
                M.set(index, 1, (double)(i * j));
                M.set(index, 2, (double)(i * i));
                M.set(index, 3, (double)j);
                M.set(index, 4, (double)i);
                M.set(index, 5, 1.0);
                ++j;
                ++index;
            }
        }
        if (!this.solver.setA((Matrix64F)M)) {
            throw new RuntimeException("Solver is broken");
        }
    }

    public void setValue(int index, double value) {
        this.Y.set(index, value);
    }

    public void setValue(int x, int y, double value) {
        this.setValue((y + 1) * 3 + x + 1, value);
    }

    public void process() {
        this.solver.solve((Matrix64F)this.Y, (Matrix64F)this.X);
        double a = this.X.data[0];
        double b = this.X.data[1];
        double c = this.X.data[2];
        double d = this.X.data[3];
        double e = this.X.data[4];
        double bottom = 4.0 * a * c - b * b;
        this.deltaX = (b * e - 2.0 * d * c) / bottom;
        this.deltaY = (b * d - 2.0 * a * e) / bottom;
    }

    public double getDeltaX() {
        return this.deltaX;
    }

    public double getDeltaY() {
        return this.deltaY;
    }
}

