/*
 * Decompiled with CFR 0.152.
 */
package org.ddogleg.solver.impl;

import java.util.ArrayList;
import java.util.List;
import org.ddogleg.solver.Polynomial;
import org.ddogleg.solver.PolynomialOps;
import org.ddogleg.solver.PolynomialRoots;
import org.ejml.data.Complex64F;
import org.ejml.data.DenseMatrix64F;
import org.ejml.data.Matrix64F;
import org.ejml.factory.DecompositionFactory;
import org.ejml.interfaces.decomposition.EigenDecomposition;

public class RootFinderCompanion
implements PolynomialRoots {
    DenseMatrix64F c = new DenseMatrix64F(1, 1);
    EigenDecomposition<DenseMatrix64F> evd = DecompositionFactory.eig((int)11, (boolean)false, (boolean)false);
    List<Complex64F> roots = new ArrayList<Complex64F>();

    @Override
    public boolean process(Polynomial poly) {
        int i;
        int N;
        for (N = poly.size - 1; poly.c[N] == 0.0 && N > 0; --N) {
        }
        if (N <= 0) {
            return false;
        }
        if (this.c.numCols != N) {
            this.c.reshape(N, N);
            this.c.zero();
        } else if (this.evd.inputModified()) {
            this.c.zero();
        }
        double a = poly.c[N];
        for (i = 0; i < N; ++i) {
            this.c.set(i, N - 1, -poly.c[i] / a);
        }
        for (i = 1; i < N; ++i) {
            this.c.set(i, i - 1, 1.0);
        }
        if (!this.evd.decompose((Matrix64F)this.c)) {
            return false;
        }
        this.roots.clear();
        for (i = 0; i < N; ++i) {
            Complex64F r = this.evd.getEigenvalue(i);
            if (r.isReal()) {
                r.real = PolynomialOps.refineRoot(poly, r.real, 30);
            }
            this.roots.add(r);
        }
        return true;
    }

    @Override
    public List<Complex64F> getRoots() {
        return this.roots;
    }
}

