/*
 * Decompiled with CFR 0.152.
 */
package org.postgis.binary;

public abstract class ByteGetter {
    public abstract int get(int var1);

    public static class StringByteGetter
    extends ByteGetter {
        private String rep;

        public StringByteGetter(String string) {
            this.rep = string;
        }

        @Override
        public int get(int n) {
            byte by = StringByteGetter.unhex(this.rep.charAt(n *= 2));
            byte by2 = StringByteGetter.unhex(this.rep.charAt(n + 1));
            return (by << 4) + by2;
        }

        public static byte unhex(char c) {
            if (c >= '0' && c <= '9') {
                return (byte)(c - 48);
            }
            if (c >= 'A' && c <= 'F') {
                return (byte)(c - 65 + 10);
            }
            if (c >= 'a' && c <= 'f') {
                return (byte)(c - 97 + 10);
            }
            throw new IllegalArgumentException("No valid Hex char " + c);
        }
    }

    public static class BinaryByteGetter
    extends ByteGetter {
        private byte[] array;

        public BinaryByteGetter(byte[] byArray) {
            this.array = byArray;
        }

        @Override
        public int get(int n) {
            return this.array[n] & 0xFF;
        }
    }
}

