/*
 * Decompiled with CFR 0.152.
 */
package org.postgis.binary;

import org.postgis.binary.ByteGetter;

public abstract class ValueGetter {
    ByteGetter data;
    int position;
    public final byte endian;

    public ValueGetter(ByteGetter byteGetter, byte by) {
        this.data = byteGetter;
        this.endian = by;
    }

    public byte getByte() {
        return (byte)this.data.get(this.position++);
    }

    public int getInt() {
        int n = this.getInt(this.position);
        this.position += 4;
        return n;
    }

    public long getLong() {
        long l = this.getLong(this.position);
        this.position += 8;
        return l;
    }

    protected abstract int getInt(int var1);

    protected abstract long getLong(int var1);

    public double getDouble() {
        long l = this.getLong();
        return Double.longBitsToDouble(l);
    }

    public static class NDR
    extends ValueGetter {
        public static final byte NUMBER = 1;

        public NDR(ByteGetter byteGetter) {
            super(byteGetter, (byte)1);
        }

        @Override
        protected int getInt(int n) {
            return (this.data.get(n + 3) << 24) + (this.data.get(n + 2) << 16) + (this.data.get(n + 1) << 8) + this.data.get(n);
        }

        @Override
        protected long getLong(int n) {
            return ((long)this.data.get(n + 7) << 56) + ((long)this.data.get(n + 6) << 48) + ((long)this.data.get(n + 5) << 40) + ((long)this.data.get(n + 4) << 32) + ((long)this.data.get(n + 3) << 24) + ((long)this.data.get(n + 2) << 16) + ((long)this.data.get(n + 1) << 8) + ((long)this.data.get(n) << 0);
        }
    }

    public static class XDR
    extends ValueGetter {
        public static final byte NUMBER = 0;

        public XDR(ByteGetter byteGetter) {
            super(byteGetter, (byte)0);
        }

        @Override
        protected int getInt(int n) {
            return (this.data.get(n) << 24) + (this.data.get(n + 1) << 16) + (this.data.get(n + 2) << 8) + this.data.get(n + 3);
        }

        @Override
        protected long getLong(int n) {
            return ((long)this.data.get(n) << 56) + ((long)this.data.get(n + 1) << 48) + ((long)this.data.get(n + 2) << 40) + ((long)this.data.get(n + 3) << 32) + ((long)this.data.get(n + 4) << 24) + ((long)this.data.get(n + 5) << 16) + ((long)this.data.get(n + 6) << 8) + ((long)this.data.get(n + 7) << 0);
        }
    }
}

