/*
 * Decompiled with CFR 0.152.
 */
package adams.data.conversion.mapobject;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.data.conversion.mapobject.AbstractMapObjectGenerator;
import adams.data.spreadsheet.SpreadSheet;
import adams.data.spreadsheet.SpreadSheetColumnIndex;
import org.openstreetmap.gui.jmapviewer.interfaces.MapMarker;

public abstract class AbstractMapMarkerGenerator
extends AbstractMapObjectGenerator<MapMarker> {
    private static final long serialVersionUID = -8754565176631384914L;
    protected SpreadSheetColumnIndex m_GPS;
    protected int m_GPSIndex;

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("gps", "GPS", (Object)new SpreadSheetColumnIndex());
    }

    public void setGPS(SpreadSheetColumnIndex value) {
        this.m_GPS = value;
        this.reset();
    }

    public SpreadSheetColumnIndex getGPS() {
        return this.m_GPS;
    }

    public String GPSTipText() {
        return "The index of the column containing the GPS objects.";
    }

    @Override
    public Class generates() {
        return MapMarker[].class;
    }

    @Override
    public String getQuickInfo() {
        String result = super.getQuickInfo();
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"GPS", (Object)this.m_GPS, (String)", GPS: ");
        return result;
    }

    @Override
    protected void check(SpreadSheet sheet) {
        super.check(sheet);
        this.m_GPS.setData((Object)sheet);
        if (this.m_GPS.getIntIndex() == -1) {
            throw new IllegalStateException("Failed to locate column: " + this.m_GPS.getIndex());
        }
    }

    @Override
    protected void init(SpreadSheet sheet) {
        super.init(sheet);
        this.m_GPSIndex = this.m_GPS.getIntIndex();
    }
}

