/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.sink.openstreetmapviewer;

import adams.core.option.OptionUtils;
import adams.flow.sink.openstreetmapviewer.AbstractMapObjectPruner;
import org.openstreetmap.gui.jmapviewer.JMapViewerTree;

public class MultiPruner
extends AbstractMapObjectPruner {
    private static final long serialVersionUID = 805661569976845842L;
    protected AbstractMapObjectPruner[] m_Overlays;

    public String globalInfo() {
        return "A meta-pruner that applies multiple pruners.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("pruner", "pruners", (Object)new AbstractMapObjectPruner[0]);
    }

    public void setPruners(AbstractMapObjectPruner[] value) {
        if (value != null) {
            this.m_Overlays = value;
            this.reset();
        } else {
            this.getLogger().severe(((Object)((Object)this)).getClass().getName() + ": pruners cannot be null!");
        }
    }

    public AbstractMapObjectPruner[] getPruners() {
        return this.m_Overlays;
    }

    public String prunersTipText() {
        return "The array of pruners to apply.";
    }

    @Override
    protected void doPrune(JMapViewerTree tree) {
        for (int i = 0; i < this.m_Overlays.length; ++i) {
            this.getLogger().info("Pruner " + (i + 1) + "/" + this.m_Overlays.length + ": " + OptionUtils.getCommandLine((Object)((Object)this.m_Overlays[i])));
            this.m_Overlays[i].prune(tree);
        }
        this.getLogger().info("Finished!");
    }
}

