/*
 * Decompiled with CFR 0.152.
 */
package adams.data.boofcv.transformer;

import adams.data.boofcv.BoofCVImageContainer;
import adams.data.boofcv.transformer.AbstractBoofCVTransformer;
import adams.data.image.AbstractImageContainer;
import java.util.ArrayList;
import java.util.Arrays;

public class MultiTransformer
extends AbstractBoofCVTransformer {
    private static final long serialVersionUID = 7793661256600883689L;
    protected AbstractBoofCVTransformer[] m_Transformers;

    public String globalInfo() {
        return "Applies the specified BoofCV transformers one after the other.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("transformer", "transformers", (Object)new AbstractBoofCVTransformer[0]);
    }

    public void setTransformers(AbstractBoofCVTransformer[] value) {
        this.m_Transformers = value;
        this.reset();
    }

    public AbstractBoofCVTransformer[] getTransformers() {
        return this.m_Transformers;
    }

    public String transformersTipText() {
        return "The transformers to apply one after the other.";
    }

    protected BoofCVImageContainer[] doTransform(BoofCVImageContainer img) {
        ArrayList<AbstractImageContainer> result = new ArrayList<AbstractImageContainer>();
        result.add(img);
        ArrayList<AbstractImageContainer> input = new ArrayList<AbstractImageContainer>();
        for (int i = 0; i < this.m_Transformers.length; ++i) {
            if (this.isLoggingEnabled()) {
                this.getLogger().info("Transformer #" + (i + 1) + "...");
            }
            input.clear();
            input.addAll(result);
            result.clear();
            for (BoofCVImageContainer boofCVImageContainer : input) {
                result.addAll(Arrays.asList(this.m_Transformers[i].transform(boofCVImageContainer)));
            }
        }
        return result.toArray(new BoofCVImageContainer[result.size()]);
    }
}

