/*
 * Decompiled with CFR 0.152.
 */
package adams.data.image.features;

import adams.core.License;
import adams.core.annotation.MixedCopyright;
import adams.data.featureconverter.HeaderDefinition;
import adams.data.image.BufferedImageContainer;
import adams.data.image.BufferedImageHelper;
import adams.data.image.features.AbstractBufferedImageFeatureGenerator;
import adams.data.report.DataType;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@MixedCopyright(license=License.CC_BY_SA_3, author="chathan - http://stackoverflow.com/users/2556447/chathan", url="http://stackoverflow.com/a/22280200")
public class Entropy
extends AbstractBufferedImageFeatureGenerator {
    private static final long serialVersionUID = -8349656592325229512L;
    protected int m_StepSize;

    public String globalInfo() {
        return "Calculates the Shannon entropy of an image.\n\nOriginal code taken from here:\nhttp://stackoverflow.com/a/22280200";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("step-size", "stepSize", (Object)1, (Number)1, null);
    }

    public void setStepSize(int value) {
        this.m_StepSize = value;
        this.reset();
    }

    public int getStepSize() {
        return this.m_StepSize;
    }

    public String stepSizeTipText() {
        return "The step size to use (ie every n-th column/row).";
    }

    @Override
    public HeaderDefinition createHeader(BufferedImageContainer img) {
        HeaderDefinition result = new HeaderDefinition();
        result.add("Entropy", DataType.NUMERIC);
        return result;
    }

    protected double calculateShannonEntropy(BufferedImage img) {
        ArrayList<String> values = new ArrayList<String>();
        int n = 0;
        HashMap<Integer, Integer> occ = new HashMap<Integer, Integer>();
        for (int i = 0; i < img.getHeight(); i += this.m_StepSize) {
            for (int j = 0; j < img.getWidth(); j += this.m_StepSize) {
                int blue;
                int green;
                int pixel = img.getRGB(j, i);
                int red = pixel >> 16 & 0xFF;
                int d = (int)Math.round(0.2989 * (double)red + 0.587 * (double)(green = pixel >> 8 & 0xFF) + 0.114 * (double)(blue = pixel & 0xFF));
                if (!values.contains(String.valueOf(d))) {
                    values.add(String.valueOf(d));
                }
                if (occ.containsKey(d)) {
                    occ.put(d, (Integer)occ.get(d) + 1);
                } else {
                    occ.put(d, 1);
                }
                ++n;
            }
        }
        double result = 0.0;
        for (Map.Entry entry : occ.entrySet()) {
            double p = (double)((Integer)entry.getValue()).intValue() / (double)n;
            result += p * (Math.log(p) / Math.log(2.0));
        }
        return -result;
    }

    @Override
    public List<Object>[] generateRows(BufferedImageContainer img) {
        List[] result = null;
        BufferedImage image = BufferedImageHelper.convert((BufferedImage)((BufferedImage)img.getImage()), (int)6);
        result = new List[]{new ArrayList()};
        result[0].add(this.calculateShannonEntropy(image));
        return result;
    }
}

