/*
 * Decompiled with CFR 0.152.
 */
package adams.data.image.transformer;

import adams.data.image.BufferedImageContainer;
import adams.data.image.BufferedImageHelper;
import adams.data.image.IntArrayMatrixView;
import adams.data.image.transformer.AbstractBufferedImageTransformer;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;

public class LaplaceOperator
extends AbstractBufferedImageTransformer {
    private static final long serialVersionUID = 8400999643470579756L;

    public String globalInfo() {
        return "Applies the Laplace operator, using the following matrix:\n\n0  1  0\n1 -4  1\n0  1  0\n\nFor more information on the Laplace operator, see:\nhttp://docs.opencv.org/modules/imgproc/doc/filtering.html?highlight=laplacian#laplacian";
    }

    protected BufferedImageContainer[] doTransform(BufferedImageContainer img) {
        IntArrayMatrixView matrixIn = BufferedImageHelper.getPixelMatrix((BufferedImage)((BufferedImage)img.getImage()));
        IntArrayMatrixView matrixOut = new IntArrayMatrixView(matrixIn.getWidth() - 2, matrixIn.getHeight() - 2);
        int[] combined = new int[4];
        for (int y = 1; y < matrixIn.getHeight() - 1; ++y) {
            for (int x = 1; x < matrixIn.getWidth() - 1; ++x) {
                int[] top = matrixIn.getRGBA(x, y - 1);
                int[] left = matrixIn.getRGBA(x - 1, y);
                int[] center = matrixIn.getRGBA(x, y);
                int[] right = matrixIn.getRGBA(x + 1, y);
                int[] bottom = matrixIn.getRGBA(x, y + 1);
                for (int i = 0; i < 3; ++i) {
                    combined[i] = top[i] + left[i] + right[i] + bottom[i] - 4 * center[i];
                }
                combined[3] = center[3];
                matrixOut.setRGBA(x - 1, y - 1, combined);
            }
        }
        ColorModel dstCM = ((BufferedImage)img.getImage()).getColorModel();
        BufferedImage image = new BufferedImage(dstCM, dstCM.createCompatibleWritableRaster(img.getWidth(), img.getHeight()), dstCM.isAlphaPremultiplied(), null);
        image.setRGB(0, 0, matrixOut.getWidth(), matrixOut.getHeight(), matrixOut.getData(), 0, matrixOut.getWidth());
        BufferedImageContainer[] result = new BufferedImageContainer[]{(BufferedImageContainer)img.getHeader()};
        result[0].setImage((Object)image);
        return result;
    }
}

