/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.sink;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.data.image.AbstractImageContainer;
import adams.data.io.output.AbstractImageWriter;
import adams.data.io.output.JAIImageWriter;
import adams.flow.sink.AbstractFileWriter;

public class ImageWriter
extends AbstractFileWriter {
    private static final long serialVersionUID = 1824012225640852716L;
    protected AbstractImageWriter m_Writer;

    public String globalInfo() {
        return "Writes the image to disk using the specified writer.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("writer", "writer", (Object)new JAIImageWriter());
    }

    public String getQuickInfo() {
        String result = super.getQuickInfo();
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"writer", (Object)this.m_Writer, (String)", writer: ");
        return result;
    }

    public String outputFileTipText() {
        return "The filename of the image to write.";
    }

    public void setWriter(AbstractImageWriter value) {
        this.m_Writer = value;
        this.reset();
    }

    public AbstractImageWriter getWriter() {
        return this.m_Writer;
    }

    public String writerTipText() {
        return "The writer to use.";
    }

    public Class[] accepts() {
        return new Class[]{AbstractImageContainer.class};
    }

    public String setUp() {
        String result = super.setUp();
        if (result == null && !this.m_Writer.isAvailable()) {
            result = "Writer '" + this.m_Writer.getClass().getName() + "' is not available - check setup!";
        }
        return result;
    }

    protected String doExecute() {
        String result = null;
        AbstractImageContainer img = (AbstractImageContainer)this.m_InputToken.getPayload();
        try {
            result = this.m_Writer.write(this.m_OutputFile, img);
        }
        catch (Exception e) {
            result = this.handleException("Failed to write image to: " + this.m_OutputFile, e);
        }
        return result;
    }
}

