/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer.draw;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.data.image.BufferedImageHelper;
import adams.flow.transformer.draw.AbstractColorDrawOperation;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.image.BufferedImage;

public class FloodFill
extends AbstractColorDrawOperation {
    private static final long serialVersionUID = -337973956383988281L;
    protected int m_X;
    protected int m_Y;

    public String globalInfo() {
        return "Performs a flood-fill starting at the given position. The position also determines the color to replace.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("x", "X", (Object)1, (Number)1, null);
        this.m_OptionManager.add("y", "Y", (Object)1, (Number)1, null);
    }

    @Override
    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, (String)"X", (Object)this.m_X, (String)"X: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"Y", (Object)this.m_Y, (String)", Y: ");
        return result;
    }

    public void setX(int value) {
        if (value > 0) {
            this.m_X = value;
            this.reset();
        } else {
            this.getLogger().severe("X must be >0, provided: " + value);
        }
    }

    public int getX() {
        return this.m_X;
    }

    public String XTipText() {
        return "The X of the starting position of the flood-fill.";
    }

    public void setY(int value) {
        if (value > 0) {
            this.m_Y = value;
            this.reset();
        } else {
            this.getLogger().severe("Y must be >0, provided: " + value);
        }
    }

    public int getY() {
        return this.m_Y;
    }

    public String YTipText() {
        return "The Y of the start position of the flood-fill.";
    }

    @Override
    protected String check(BufferedImage image) {
        String result = super.check(image);
        if (result == null) {
            if (this.m_X > image.getWidth()) {
                result = "X is larger than image width: " + this.m_X + " > " + image.getWidth();
            } else if (this.m_Y > image.getHeight()) {
                result = "Y is larger than image height: " + this.m_Y + " > " + image.getHeight();
            }
        }
        return result;
    }

    @Override
    protected String doDraw(BufferedImage image) {
        Graphics g = image.getGraphics();
        g.setColor(this.m_Color);
        BufferedImageHelper.floodFill((BufferedImage)image, (int)(this.m_X - 1), (int)this.m_Y, (Color)new Color(image.getRGB(this.m_X, this.m_Y)), (Color)this.m_Color);
        return null;
    }
}

