/*
 * Decompiled with CFR 0.152.
 */
package org.im4java.process;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import java.util.concurrent.atomic.AtomicInteger;
import org.im4java.process.ErrorConsumer;
import org.im4java.process.InputProvider;
import org.im4java.process.OutputConsumer;
import org.im4java.process.ProcessEvent;
import org.im4java.process.ProcessEventListener;
import org.im4java.process.ProcessListener;
import org.im4java.process.ProcessTask;

public class ProcessStarter {
    public static final int BUFFER_SIZE = 65536;
    private static String iGlobalSearchPath = null;
    private String iSearchPath = null;
    private static AtomicInteger iPIDCounter = new AtomicInteger(0);
    private int iPID;
    private InputProvider iInputProvider = null;
    private OutputConsumer iOutputConsumer = null;
    private ErrorConsumer iErrorConsumer = null;
    private boolean iAsyncMode = false;
    private LinkedList<ProcessListener> iProcessListener = new LinkedList();
    private LinkedList<ProcessEventListener> iProcessEventListener = new LinkedList();

    protected ProcessStarter() {
        this.iPID = iPIDCounter.getAndAdd(1);
    }

    public void setInputProvider(InputProvider inputProvider) {
        this.iInputProvider = inputProvider;
    }

    public void setOutputConsumer(OutputConsumer outputConsumer) {
        this.iOutputConsumer = outputConsumer;
    }

    public void setErrorConsumer(ErrorConsumer errorConsumer) {
        this.iErrorConsumer = errorConsumer;
    }

    public void addProcessEventListener(ProcessEventListener processEventListener) {
        this.iProcessEventListener.add(processEventListener);
    }

    public void removeProcessEventListener(ProcessEventListener processEventListener) {
        this.iProcessEventListener.remove(processEventListener);
    }

    public void addProcessListener(ProcessListener processListener) {
        this.iProcessListener.add(processListener);
    }

    private void processInput(OutputStream outputStream) throws IOException {
        final BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(outputStream, 65536);
        new Thread(){

            @Override
            public void run() {
                try {
                    ProcessStarter.this.iInputProvider.provideInput(bufferedOutputStream);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }.run();
        bufferedOutputStream.close();
        if (outputStream != null) {
            outputStream.close();
        }
    }

    private void processOutput(InputStream inputStream, OutputConsumer outputConsumer) throws IOException {
        BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream, 65536);
        outputConsumer.consumeOutput(bufferedInputStream);
        bufferedInputStream.close();
        if (inputStream != null) {
            inputStream.close();
        }
    }

    private void processError(InputStream inputStream, ErrorConsumer errorConsumer) throws IOException {
        BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream, 65536);
        errorConsumer.consumeError(bufferedInputStream);
        bufferedInputStream.close();
        if (inputStream != null) {
            inputStream.close();
        }
    }

    protected int run(LinkedList<String> linkedList) throws IOException, InterruptedException, Exception {
        if (!this.iAsyncMode) {
            Process process = this.startProcess(linkedList);
            int n = this.waitForProcess(process);
            this.finished(n);
            return n;
        }
        ProcessTask processTask = this.getProcessTask(linkedList);
        new Thread(processTask).start();
        return 0;
    }

    protected ProcessTask getProcessTask(LinkedList<String> linkedList) {
        ProcessEvent processEvent = new ProcessEvent(this.iPID, this);
        processEvent.setReturnCode(-1);
        for (ProcessEventListener processEventListener : this.iProcessEventListener) {
            processEventListener.processInitiated(processEvent);
        }
        return new ProcessTask(this, linkedList, processEvent);
    }

    void runAndNotify(LinkedList<String> linkedList, ProcessEvent processEvent) {
        try {
            Iterator iterator = this.startProcess(linkedList);
            processEvent.setProcess((Process)((Object)iterator));
            for (ProcessEventListener processEventListener : this.iProcessEventListener) {
                processEventListener.processStarted(processEvent);
            }
            for (ProcessListener processListener : this.iProcessListener) {
                processListener.processStarted((Process)((Object)iterator));
            }
            int n = this.waitForProcess((Process)((Object)iterator));
            processEvent.setReturnCode(n);
            this.finished(n);
        }
        catch (Exception exception) {
            processEvent.setException(exception);
            try {
                this.finished(exception);
            }
            catch (Exception exception2) {
                processEvent.setException(exception2);
            }
        }
        for (ProcessEventListener processEventListener : this.iProcessEventListener) {
            processEventListener.processTerminated(processEvent);
        }
        for (ProcessListener processListener : this.iProcessListener) {
            processListener.processTerminated(processEvent);
        }
    }

    private Process startProcess(LinkedList<String> linkedList) throws IOException, InterruptedException {
        Object object;
        if (this.iSearchPath != null) {
            object = linkedList.getFirst();
            object = this.searchForCmd((String)object, this.iSearchPath);
            linkedList.set(0, (String)object);
        } else if (iGlobalSearchPath != null) {
            object = linkedList.getFirst();
            object = this.searchForCmd((String)object, iGlobalSearchPath);
            linkedList.set(0, (String)object);
        }
        object = new ProcessBuilder(linkedList);
        return ((ProcessBuilder)object).start();
    }

    private int waitForProcess(final Process process) throws IOException, InterruptedException {
        FutureTask<Object> futureTask = null;
        FutureTask<Object> futureTask2 = null;
        if (this.iInputProvider != null) {
            this.processInput(process.getOutputStream());
        }
        if (this.iOutputConsumer != null) {
            futureTask = new FutureTask<Object>(new Callable<Object>(){

                @Override
                public Object call() throws IOException {
                    ProcessStarter.this.processOutput(process.getInputStream(), ProcessStarter.this.iOutputConsumer);
                    return null;
                }
            });
            new Thread(futureTask).start();
        }
        if (this.iErrorConsumer != null) {
            futureTask2 = new FutureTask<Object>(new Callable<Object>(){

                @Override
                public Object call() throws IOException {
                    ProcessStarter.this.processError(process.getErrorStream(), ProcessStarter.this.iErrorConsumer);
                    return null;
                }
            });
            new Thread(futureTask2).start();
        }
        try {
            if (futureTask != null) {
                futureTask.get();
            }
            if (futureTask2 != null) {
                futureTask2.get();
            }
        }
        catch (ExecutionException executionException) {
            Throwable throwable = executionException.getCause();
            if (throwable instanceof IOException) {
                throw (IOException)throwable;
            }
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            throw new IllegalStateException(executionException);
        }
        process.waitFor();
        int n = process.exitValue();
        try {
            process.getInputStream().close();
            process.getOutputStream().close();
            process.getErrorStream().close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return n;
    }

    public void setAsyncMode(boolean bl) {
        this.iAsyncMode = bl;
    }

    public boolean isAsyncMode() {
        return this.iAsyncMode;
    }

    public static void setGlobalSearchPath(String string) {
        iGlobalSearchPath = string;
    }

    public static String getGlobalSearchPath() {
        return iGlobalSearchPath;
    }

    public void setSearchPath(String string) {
        this.iSearchPath = string;
    }

    public String getSearchPath() {
        return this.iSearchPath;
    }

    public static void setPIDCounter(int n) {
        iPIDCounter.set(n);
    }

    public void setPID(int n) {
        this.iPID = n;
    }

    public int getPID() {
        return this.iPID;
    }

    protected void finished(int n) throws Exception {
    }

    protected void finished(Exception exception) throws Exception {
    }

    public String searchForCmd(String string, String string2) throws IOException, FileNotFoundException {
        if (new File(string).isAbsolute()) {
            return string;
        }
        boolean bl = File.pathSeparator.equals(";");
        String[] stringArray = string2.split(File.pathSeparator);
        for (int i = 0; i < stringArray.length; ++i) {
            File file;
            if (bl) {
                file = new File(stringArray[i], string + ".exe");
                if (file.exists()) {
                    return file.getCanonicalPath();
                }
                file = new File(stringArray[i], string + ".cmd");
                if (file.exists()) {
                    return file.getCanonicalPath();
                }
                file = new File(stringArray[i], string + ".bat");
                if (!file.exists()) continue;
                return file.getCanonicalPath();
            }
            file = new File(stringArray[i], string);
            if (!file.exists()) continue;
            return file.getCanonicalPath();
        }
        throw new FileNotFoundException(string);
    }

    static {
        iGlobalSearchPath = System.getenv("IM4JAVA_TOOLPATH");
    }
}

