/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.timeseries;

import java.io.PrintStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import weka.classifiers.evaluation.NumericPrediction;
import weka.classifiers.timeseries.TSForecaster;
import weka.classifiers.timeseries.eval.TSEvaluation;
import weka.core.CommandlineRunnable;
import weka.core.Instances;
import weka.core.SerializedObject;

public abstract class AbstractForecaster
implements TSForecaster,
CommandlineRunnable,
Serializable {
    private static final long serialVersionUID = 5179667114364013750L;
    protected List<String> m_fieldsToForecast = null;

    public static List<String> stringToList(String list) {
        String[] fieldNames = list.split(",");
        ArrayList<String> thelist = new ArrayList<String>();
        for (String f : fieldNames) {
            thelist.add(f);
        }
        return thelist;
    }

    @Override
    public void setFieldsToForecast(String targets) throws Exception {
        this.m_fieldsToForecast = AbstractForecaster.stringToList(targets);
    }

    @Override
    public String getFieldsToForecast() {
        String list = "";
        for (String f : this.m_fieldsToForecast) {
            list = list + f + ",";
        }
        list = list.substring(0, list.lastIndexOf(44));
        return list;
    }

    @Override
    public abstract void buildForecaster(Instances var1, PrintStream ... var2) throws Exception;

    @Override
    public abstract void primeForecaster(Instances var1) throws Exception;

    @Override
    public abstract List<List<NumericPrediction>> forecast(int var1, PrintStream ... var2) throws Exception;

    public void run(Object toRun, String[] options) throws IllegalArgumentException {
        if (!(toRun instanceof TSForecaster)) {
            throw new IllegalArgumentException("Argument must be an object of type TSForecaster!");
        }
        this.runForecaster((TSForecaster)toRun, options);
    }

    public static TSForecaster makeCopy(TSForecaster model) throws Exception {
        return (TSForecaster)new SerializedObject((Object)model).getObject();
    }

    @Override
    public void runForecaster(TSForecaster forecaster, String[] options) {
        try {
            TSEvaluation.evaluateForecaster(forecaster, options);
        }
        catch (Exception e) {
            if (e.getMessage() != null && e.getMessage().indexOf("General options") == -1 || e.getMessage() == null) {
                e.printStackTrace();
            }
            System.err.println(e.getMessage());
        }
    }
}

