/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.timeseries.core;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import weka.classifiers.timeseries.core.TSLagMaker;
import weka.core.Attribute;
import weka.core.DenseInstance;
import weka.core.Instance;
import weka.core.Instances;

public class Utils {
    protected static Instance makeInstance(double timeToAdvance, TSLagMaker.PeriodicityHandler periodicityHandler, int numAtts, int timeIndex) {
        double incrTime = Utils.advanceSuppliedTimeValue(timeToAdvance, periodicityHandler, false);
        double[] newVals = new double[numAtts];
        for (int i = 0; i < newVals.length; ++i) {
            newVals[i] = weka.core.Utils.missingValue();
        }
        newVals[timeIndex] = incrTime;
        DenseInstance newInst = new DenseInstance(1.0, newVals);
        return newInst;
    }

    protected static void addToMissingReport(double incrTime, TSLagMaker.PeriodicityHandler periodicityHandler, List<String> missingReport) {
        if (missingReport != null) {
            if (periodicityHandler.isDateBased()) {
                String timeFormat = "yyyy-MM-dd'T'HH:mm:ss";
                SimpleDateFormat sdf = new SimpleDateFormat();
                sdf.applyPattern(timeFormat);
                Date d = new Date((long)incrTime);
                String result = sdf.format(d);
                missingReport.add(result);
            } else {
                missingReport.add("" + incrTime);
            }
        }
    }

    public static Instances insertMissing(Instances toInsert, Attribute timeStampAtt, TSLagMaker.PeriodicityHandler periodicityHandler, String m_skipEntries, List<String> missingReport) {
        if (m_skipEntries != null && m_skipEntries.length() > 0) {
            try {
                periodicityHandler.setSkipList(m_skipEntries, "yyyy-MM-dd'T'HH:mm:ss");
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        int timeIndex = timeStampAtt.index();
        Instance prevInst = null;
        for (int current = 0; current != toInsert.numInstances(); ++current) {
            if (prevInst != null && !toInsert.instance(current).isMissing(timeIndex)) {
                if (periodicityHandler.getPeriodicity() != TSLagMaker.Periodicity.MONTHLY && periodicityHandler.getPeriodicity() != TSLagMaker.Periodicity.QUARTERLY) {
                    Instance newInst;
                    Date candidate;
                    double delta = periodicityHandler.getPeriodicity().deltaTime();
                    double diff = toInsert.instance(current).value(timeIndex) - prevInst.value(timeIndex);
                    if (!(!(diff > 1.5 * delta) || periodicityHandler.isDateBased() && periodicityHandler.dateInSkipList(new Date((long)prevInst.value(timeIndex))) || periodicityHandler.dateInSkipList(candidate = new Date((long)(newInst = Utils.makeInstance(prevInst.value(timeIndex), periodicityHandler, toInsert.numAttributes(), timeIndex)).value(timeIndex))) || !((double)candidate.getTime() < toInsert.instance(current).value(timeIndex)))) {
                        newInst.setDataset(toInsert);
                        toInsert.add(current, newInst);
                        Utils.addToMissingReport(newInst.value(timeIndex), periodicityHandler, missingReport);
                    }
                } else {
                    Instance newInst;
                    Date candidate;
                    Date d = new Date((long)toInsert.instance(current).value(timeIndex));
                    GregorianCalendar c = new GregorianCalendar();
                    c.setTime(d);
                    int currentMonth = c.get(2);
                    d = new Date((long)prevInst.value(timeIndex));
                    c.setTime(d);
                    int prevMonth = c.get(2);
                    double diff = currentMonth + 1 - (prevMonth == 11 ? 0 : prevMonth + 1);
                    if (periodicityHandler.getPeriodicity() == TSLagMaker.Periodicity.MONTHLY) {
                        if (!(!(diff > 1.5) || periodicityHandler.isDateBased() && periodicityHandler.dateInSkipList(new Date((long)prevInst.value(timeIndex))) || periodicityHandler.dateInSkipList(candidate = new Date((long)(newInst = Utils.makeInstance(prevInst.value(timeIndex), periodicityHandler, toInsert.numAttributes(), timeIndex)).value(timeIndex))) || !((double)candidate.getTime() < toInsert.instance(current).value(timeIndex)))) {
                            newInst.setDataset(toInsert);
                            toInsert.add(current, newInst);
                            Utils.addToMissingReport(newInst.value(timeIndex), periodicityHandler, missingReport);
                        }
                    } else if (!(periodicityHandler.getPeriodicity() != TSLagMaker.Periodicity.QUARTERLY || !(diff > 4.5) || periodicityHandler.isDateBased() && periodicityHandler.dateInSkipList(new Date((long)prevInst.value(timeIndex))) || periodicityHandler.dateInSkipList(candidate = new Date((long)(newInst = Utils.makeInstance(prevInst.value(timeIndex), periodicityHandler, toInsert.numAttributes(), timeIndex)).value(timeIndex))) || !((double)candidate.getTime() < toInsert.instance(current).value(timeIndex)))) {
                        toInsert.add(current, newInst);
                        Utils.addToMissingReport(newInst.value(timeIndex), periodicityHandler, missingReport);
                    }
                }
            }
            if (toInsert.instance(current).isMissing(timeIndex)) continue;
            prevInst = toInsert.instance(current);
        }
        return null;
    }

    public static Instances replaceMissing(Instances toReplace, List<String> targets, String timeStampName, boolean dateOnly, TSLagMaker.Periodicity userHint, String skipEntries, Object ... missingReport) {
        Instances result = toReplace;
        Attribute timeStampAtt = null;
        TSLagMaker.PeriodicityHandler detected = null;
        List missingTargetList = null;
        List missingTimeStampList = null;
        List missingTimeStampRows = null;
        if (missingReport.length > 0) {
            missingTargetList = (List)missingReport[0];
            if (missingReport.length == 2) {
                missingTimeStampList = (List)missingReport[1];
            }
            if (missingReport.length == 3) {
                missingTimeStampRows = (List)missingReport[2];
            }
        }
        if (timeStampName != null && timeStampName.length() > 0 && (timeStampAtt = toReplace.attribute(timeStampName)) != null && (detected = TSLagMaker.determinePeriodicity(result, timeStampName, userHint)).getPeriodicity() != TSLagMaker.Periodicity.UNKNOWN) {
            Utils.insertMissing(toReplace, timeStampAtt, detected, skipEntries, missingTimeStampRows);
        }
        boolean ok = true;
        for (int i = 0; i < toReplace.numInstances(); ++i) {
            if (!toReplace.instance(i).hasMissingValue()) continue;
            if (!dateOnly) {
                for (String target : targets) {
                    int attIndex = toReplace.attribute(target).index();
                    if (!toReplace.instance(i).isMissing(attIndex)) continue;
                    ok = false;
                    break;
                }
                if (!ok) break;
            }
            if (timeStampAtt == null || !toReplace.instance(i).isMissing(timeStampAtt)) continue;
            ok = false;
            break;
        }
        if (ok) {
            return result;
        }
        if (!dateOnly) {
            for (String target : targets) {
                if (result.attribute(target) == null) continue;
                int attIndex = result.attribute(target).index();
                double lastNonMissing = weka.core.Utils.missingValue();
                for (int i = 0; i < result.numInstances(); ++i) {
                    Instance current = result.instance(i);
                    if (current.isMissing(attIndex)) {
                        if (weka.core.Utils.isMissingValue((double)lastNonMissing)) continue;
                        double futureNonMissing = weka.core.Utils.missingValue();
                        double x2 = 2.0;
                        for (int j = i + 1; j < result.numInstances(); ++j) {
                            if (!result.instance(j).isMissing(attIndex)) {
                                futureNonMissing = result.instance(j).value(attIndex);
                                break;
                            }
                            x2 += 1.0;
                        }
                        if (weka.core.Utils.isMissingValue((double)futureNonMissing)) continue;
                        double offset = lastNonMissing;
                        double slope = (futureNonMissing - lastNonMissing) / x2;
                        int j = i;
                        while ((double)j < (double)i + x2) {
                            if (result.instance(j).isMissing(attIndex)) {
                                double interpolated = (double)(j - i + 1) * slope + offset;
                                result.instance(j).setValue(attIndex, interpolated);
                                if (missingTargetList != null) {
                                    missingTargetList.add(new Integer(j + 1));
                                }
                            }
                            ++j;
                        }
                        continue;
                    }
                    lastNonMissing = current.value(attIndex);
                }
            }
        }
        if (timeStampAtt != null) {
            double newV;
            Instance current;
            int i;
            double firstNonMissing;
            int attIndex = timeStampAtt.index();
            double previousNonMissing = firstNonMissing = result.instance(0).value(attIndex);
            int firstNonMissingIndex = -1;
            boolean leadingMissingDates = weka.core.Utils.isMissingValue((double)firstNonMissing);
            for (i = 0; i < result.numInstances(); ++i) {
                current = result.instance(i);
                if (current.isMissing(attIndex)) {
                    if (!weka.core.Utils.isMissingValue((double)previousNonMissing)) {
                        newV = Utils.advanceSuppliedTimeValue(previousNonMissing, detected);
                        current.setValue(attIndex, newV);
                        if (missingTimeStampList != null) {
                            missingTimeStampList.add(new Integer(i + 1));
                        }
                    }
                } else if (firstNonMissingIndex == -1) {
                    firstNonMissingIndex = i;
                    firstNonMissing = current.value(attIndex);
                }
                previousNonMissing = current.value(attIndex);
            }
            if (leadingMissingDates && firstNonMissingIndex > 0) {
                for (i = firstNonMissingIndex - 1; i >= 0; --i) {
                    current = result.instance(i);
                    newV = Utils.decrementSuppliedTimeValue(firstNonMissing, detected);
                    current.setValue(attIndex, newV);
                    if (missingTimeStampList != null) {
                        missingTimeStampList.add(new Integer(i + 1));
                    }
                    firstNonMissing = newV;
                }
            }
        }
        return result;
    }

    public static double advanceSuppliedTimeValue(double valueToAdvance, TSLagMaker.PeriodicityHandler dateBasedPeriodicity) {
        return Utils.advanceSuppliedTimeValue(valueToAdvance, dateBasedPeriodicity, false);
    }

    public static double decrementSuppliedTimeValue(double valueToDecrement, TSLagMaker.PeriodicityHandler dateBasedPeriodicity) {
        return Utils.advanceSuppliedTimeValue(valueToDecrement, dateBasedPeriodicity, true);
    }

    protected static double advanceSuppliedTimeValue(double valueToAdvance, TSLagMaker.PeriodicityHandler dateBasedPeriodicity, boolean decrement) {
        int sign;
        double result = valueToAdvance;
        int n = sign = decrement ? -1 : 1;
        if (dateBasedPeriodicity.getPeriodicity() != TSLagMaker.Periodicity.UNKNOWN) {
            Date d = new Date((long)valueToAdvance);
            GregorianCalendar c = new GregorianCalendar();
            c.setTime(d);
            do {
                if (dateBasedPeriodicity.getPeriodicity() == TSLagMaker.Periodicity.YEARLY) {
                    ((Calendar)c).add(1, 1 * sign);
                } else if (dateBasedPeriodicity.getPeriodicity() == TSLagMaker.Periodicity.QUARTERLY) {
                    ((Calendar)c).add(2, 3 * sign);
                } else if (dateBasedPeriodicity.getPeriodicity() == TSLagMaker.Periodicity.MONTHLY) {
                    ((Calendar)c).add(2, 1 * sign);
                } else if (dateBasedPeriodicity.getPeriodicity() == TSLagMaker.Periodicity.WEEKLY) {
                    ((Calendar)c).add(3, 1 * sign);
                } else if (dateBasedPeriodicity.getPeriodicity() == TSLagMaker.Periodicity.DAILY) {
                    ((Calendar)c).add(6, 1 * sign);
                } else if (dateBasedPeriodicity.getPeriodicity() == TSLagMaker.Periodicity.HOURLY) {
                    ((Calendar)c).add(11, 1 * sign);
                }
                result = c.getTimeInMillis();
            } while (dateBasedPeriodicity.dateInSkipList(c.getTime()));
        } else {
            while (dateBasedPeriodicity.dateInSkipList(new Date((long)(result += dateBasedPeriodicity.deltaTime() * (double)sign)))) {
            }
        }
        return result;
    }
}

