/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.pd;

import de.intarsys.pdf.cos.COSArray;
import de.intarsys.pdf.cos.COSBasedObject;
import de.intarsys.pdf.cos.COSDictionary;
import de.intarsys.pdf.cos.COSInteger;
import de.intarsys.pdf.cos.COSName;
import de.intarsys.pdf.cos.COSObject;
import de.intarsys.pdf.pd.PDAcroFormField;
import de.intarsys.pdf.pd.PDAction;
import de.intarsys.pdf.pd.PDFileSpecification;
import de.intarsys.pdf.pd.PDFileSpecificationURL;
import de.intarsys.pdf.pd.SubmitFormFlags;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class PDActionSubmitForm
extends PDAction {
    public static final MetaClass META = new MetaClass(MetaClass.class.getDeclaringClass());
    public static final COSName CN_ActionType_SubmitForm = COSName.constant("SubmitForm");
    public static final COSName DK_F = COSName.constant("F");
    public static final COSName DK_Fields = COSName.constant("Fields");
    public static final COSName DK_Flags = COSName.constant("Flags");
    private SubmitFormFlags flags;

    public static PDActionSubmitForm createNew(URL uRL) {
        PDActionSubmitForm pDActionSubmitForm = (PDActionSubmitForm)META.createNew();
        pDActionSubmitForm.setUrl(uRL);
        return pDActionSubmitForm;
    }

    protected PDActionSubmitForm(COSObject cOSObject) {
        super(cOSObject);
    }

    protected int basicGetFlags() {
        return this.getFieldInt(DK_Flags, 0);
    }

    protected void basicSetFlags(int n) {
        if (n != 0) {
            this.cosSetField(DK_Flags, COSInteger.create(n));
        } else {
            this.cosRemoveField(DK_Flags);
        }
    }

    @Override
    public COSName cosGetExpectedActionType() {
        return CN_ActionType_SubmitForm;
    }

    public List getFields() {
        COSArray cOSArray = this.cosGetField(DK_Fields).asArray();
        if (cOSArray != null) {
            ArrayList<String> arrayList = new ArrayList<String>();
            Iterator iterator = cOSArray.iterator();
            while (iterator.hasNext()) {
                COSObject cOSObject = (COSObject)iterator.next();
                if (cOSObject instanceof COSDictionary) {
                    PDAcroFormField pDAcroFormField = (PDAcroFormField)PDAcroFormField.META.createFromCos(cOSObject);
                    arrayList.add(pDAcroFormField.getQualifiedName());
                    continue;
                }
                arrayList.add(cOSObject.stringValue());
            }
            return arrayList;
        }
        return null;
    }

    protected SubmitFormFlags getFlags() {
        if (this.flags == null) {
            this.flags = new SubmitFormFlags(this);
        }
        return this.flags;
    }

    public URL getUrl() {
        PDFileSpecification pDFileSpecification = this.getUrlSpecification();
        if (pDFileSpecification != null) {
            return ((PDFileSpecificationURL)pDFileSpecification).getURL();
        }
        return null;
    }

    protected PDFileSpecification getUrlSpecification() {
        COSObject cOSObject = this.cosGetField(DK_F);
        if (cOSObject.isNull()) {
            return null;
        }
        return (PDFileSpecificationURL)PDFileSpecificationURL.META.createFromCos(cOSObject);
    }

    public boolean isCanonicalFormat() {
        return this.getFlags().isCanonicalFormat();
    }

    public boolean isEmbedForm() {
        return this.getFlags().isEmbedForm();
    }

    public boolean isExclFKey() {
        return this.getFlags().isExclFKey();
    }

    public boolean isExclNonUserAnnots() {
        return this.getFlags().isExclNonUserAnnots();
    }

    public boolean isExportFormat() {
        return this.getFlags().isExportFormat();
    }

    public boolean isGetMethod() {
        return this.getFlags().isGetMethod();
    }

    public boolean isInclude() {
        return this.getFlags().isInclude();
    }

    public boolean isIncludeAnnotations() {
        return this.getFlags().isIncludeAnnotations();
    }

    public boolean isIncludeAppendSaves() {
        return this.getFlags().isIncludeAppendSaves();
    }

    public boolean isIncludeNoValueFields() {
        return this.getFlags().isIncludeNoValueFields();
    }

    public boolean isNotDEFINED() {
        return this.getFlags().isNotDEFINED();
    }

    public boolean isSubmitCoordinates() {
        return this.getFlags().isSubmitCoordinates();
    }

    public boolean isSubmitPDF() {
        return this.getFlags().isSubmitPDF();
    }

    public boolean isXFDF() {
        return this.getFlags().isXFDF();
    }

    public void setCanonicalFormat(boolean bl) {
        this.getFlags().setCanonicalFormat(bl);
    }

    public void setEmbedForm(boolean bl) {
        this.getFlags().setEmbedForm(bl);
    }

    public void setExclFKey(boolean bl) {
        this.getFlags().setExclFKey(bl);
    }

    public void setExclNonUserAnnots(boolean bl) {
        this.getFlags().setExclNonUserAnnots(bl);
    }

    public void setExportFormat(boolean bl) {
        this.getFlags().setExportFormat(bl);
    }

    protected void setFields(List list) {
    }

    public void setGetMethod(boolean bl) {
        this.getFlags().setGetMethod(bl);
    }

    public void setInclude(boolean bl) {
        this.getFlags().setInclude(bl);
    }

    public void setIncludeAnnotations(boolean bl) {
        this.getFlags().setIncludeAnnotations(bl);
    }

    public void setIncludeAppendSaves(boolean bl) {
        this.getFlags().setIncludeAppendSaves(bl);
    }

    public void setIncludeNoValueFields(boolean bl) {
        this.getFlags().setIncludeNoValueFields(bl);
    }

    public void setNotDEFINED(boolean bl) {
        this.getFlags().setNotDEFINED(bl);
    }

    public void setSubmitCoordinates(boolean bl) {
        this.getFlags().setSubmitCoordinates(bl);
    }

    public void setSubmitPDF(boolean bl) {
        this.getFlags().setSubmitPDF(bl);
    }

    public void setUrl(URL uRL) {
        if (uRL != null) {
            this.setUrlSpecification(PDFileSpecificationURL.createNew(uRL));
        } else {
            this.setUrlSpecification(null);
        }
    }

    protected void setUrlSpecification(PDFileSpecification pDFileSpecification) {
        this.setFieldObject(DK_F, pDFileSpecification);
    }

    public void setXFDF(boolean bl) {
        this.getFlags().setXFDF(bl);
    }

    public static class MetaClass
    extends PDAction.MetaClass {
        protected MetaClass(Class clazz) {
            super(clazz);
        }

        @Override
        protected COSBasedObject doCreateCOSBasedObject(COSObject cOSObject) {
            return new PDActionSubmitForm(cOSObject);
        }
    }
}

