/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.stats.fourinone;

import adams.data.statistics.StatUtils;
import adams.gui.event.PaintListener;
import adams.gui.visualization.core.AxisPanel;
import adams.gui.visualization.core.PaintablePanel;
import adams.gui.visualization.core.Paintlet;
import adams.gui.visualization.core.PlotPanel;
import adams.gui.visualization.core.plot.Axis;
import adams.gui.visualization.stats.fourinone.VersusFitOptions;
import adams.gui.visualization.stats.fourinone.VersusFitPanel;
import adams.gui.visualization.stats.paintlet.VsFitPaintlet;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Graphics;
import weka.core.Instances;

public class VersusFit
extends PaintablePanel {
    private static final long serialVersionUID = 2542241196305925848L;
    protected Instances m_Instances;
    protected VersusFitPanel m_Plot;
    protected VsFitPaintlet m_val;
    protected VersusFitOptions m_VsFitOptions;
    protected int m_Index;
    protected int m_PredInd;

    protected void initGUI() {
        super.initGUI();
        this.setLayout(new BorderLayout());
        this.m_Plot = new VersusFitPanel();
        this.m_Plot.addPaintListener((PaintListener)this);
        this.add((Component)((Object)this.m_Plot), "Center");
        this.m_val = new VsFitPaintlet();
        this.m_val.setPanel(this);
    }

    public void setOptions(VersusFitOptions val) {
        this.m_VsFitOptions = val;
        this.m_VsFitOptions.getAxisX().configure((PlotPanel)this.m_Plot, Axis.BOTTOM);
        this.m_VsFitOptions.getAxisY().configure((PlotPanel)this.m_Plot, Axis.LEFT);
        this.removePaintlet((Paintlet)this.m_val);
        this.m_val = (VsFitPaintlet)this.m_VsFitOptions.getPaintlet().shallowCopy(true);
        this.m_val.setPanel(this);
    }

    public PlotPanel getPlot() {
        return this.m_Plot;
    }

    public void prepareUpdate() {
        if (this.m_Instances != null) {
            this.m_val.setInstances(this.m_Instances);
            this.m_val.setIndices(this.m_Index, this.m_PredInd);
            this.m_val.setRepaintOnChange(true);
            AxisPanel axisBottom = this.getPlot().getAxis(Axis.BOTTOM);
            AxisPanel axisLeft = this.getPlot().getAxis(Axis.LEFT);
            double[] predicted = this.m_Instances.attributeToDoubleArray(this.m_PredInd);
            double[] residuals = this.m_Instances.attributeToDoubleArray(this.m_Index);
            double minY = StatUtils.min((double[])residuals);
            double maxY = StatUtils.max((double[])residuals);
            double maxX = StatUtils.max((double[])predicted);
            double minX = StatUtils.min((double[])predicted);
            axisBottom.setMinimum(minX);
            axisBottom.setMaximum(maxX);
            axisLeft.setMinimum(minY);
            axisLeft.setMaximum(maxY);
        }
    }

    protected boolean canPaint(Graphics g) {
        return this.m_Plot != null && this.m_Instances != null;
    }

    public Instances getInstances() {
        return this.m_Instances;
    }

    public void setInstances(Instances inst) {
        this.m_Instances = inst;
    }

    public void setIndices(int res, int pred) {
        this.m_Index = res;
        this.m_PredInd = pred;
    }
}

