/*
 * Decompiled with CFR 0.152.
 */
package adams.data.spreadsheet.cellfinder;

import adams.core.QuickInfoHelper;
import adams.core.Range;
import adams.core.option.OptionHandler;
import adams.data.spreadsheet.Cell;
import adams.data.spreadsheet.SpreadSheet;
import adams.data.spreadsheet.SpreadSheetColumnRange;
import adams.data.spreadsheet.cellfinder.AbstractCellFinder;
import adams.data.spreadsheet.cellfinder.CellLocation;
import adams.data.spreadsheet.cellfinder.TypeRangeIterator;
import java.util.ArrayList;
import java.util.Iterator;

public class CellTypeRange
extends AbstractCellFinder {
    private static final long serialVersionUID = 3956527986917157099L;
    protected Cell.ContentType m_Type;
    protected Range m_Rows;
    protected SpreadSheetColumnRange m_Columns;

    public String globalInfo() {
        return "Locator that locates cells of a certain type using a rectangular range.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("type", "type", (Object)Cell.ContentType.STRING);
        this.m_OptionManager.add("rows", "rows", (Object)new Range("first-last"));
        this.m_OptionManager.add("columns", "columns", (Object)new SpreadSheetColumnRange("first-last"));
    }

    public void setType(Cell.ContentType value) {
        this.m_Type = value;
        this.reset();
    }

    public Cell.ContentType getType() {
        return this.m_Type;
    }

    public String typeTipText() {
        return "The cell type to locate.";
    }

    public void setRows(Range value) {
        this.m_Rows = value;
        this.reset();
    }

    public Range getRows() {
        return this.m_Rows;
    }

    public String rowsTipText() {
        return "The rows to locate.";
    }

    public void setColumns(SpreadSheetColumnRange value) {
        this.m_Columns = value;
        this.reset();
    }

    public SpreadSheetColumnRange getColumns() {
        return this.m_Columns;
    }

    public String columnsTipText() {
        return "The columns to locate.";
    }

    @Override
    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, (String)"rows", (Object)this.m_Rows, (String)"rows: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"columns", (Object)((Object)this.m_Columns), (String)", cols: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"type", (Object)this.m_Type, (String)", type: ");
        return result;
    }

    @Override
    protected Iterator<CellLocation> doFindCells(SpreadSheet sheet) {
        this.m_Rows.setMax(sheet.getRowCount());
        this.m_Columns.setSpreadSheet(sheet);
        int[] rows = this.m_Rows.getIntIndices();
        int[] cols = this.m_Columns.getIntIndices();
        if (rows.length > 0 && cols.length > 0) {
            return new TypeRangeIterator(sheet, this.m_Type, rows, cols);
        }
        return new ArrayList().iterator();
    }
}

