/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.tools.spreadsheetviewer;

import adams.data.spreadsheet.SpreadSheet;
import adams.flow.core.Actor;
import adams.flow.core.Token;
import adams.flow.transformer.SpreadSheetMerge;
import adams.gui.tools.spreadsheetviewer.AbstractSelectedSheetsDataPluginWithGOE;
import adams.gui.tools.spreadsheetviewer.SpreadSheetPanel;

public class Merge
extends AbstractSelectedSheetsDataPluginWithGOE {
    private static final long serialVersionUID = -1680562922203169642L;

    public String globalInfo() {
        return "Merges multiple spreadsheets into a single one (side-by-side).";
    }

    @Override
    public String getMenuText() {
        return "Merge...";
    }

    @Override
    public String getMenuIcon() {
        return "merge.png";
    }

    @Override
    public boolean canProcess(SpreadSheetPanel panel) {
        return super.canProcess(panel) && panel.getOwner().getTabCount() > 1;
    }

    @Override
    protected Class getEditorType() {
        return Actor.class;
    }

    @Override
    protected Object getDefaultValue() {
        return new SpreadSheetMerge();
    }

    @Override
    protected boolean getCanChangeClassInDialog() {
        return false;
    }

    @Override
    public boolean isInPlace() {
        return false;
    }

    @Override
    protected SpreadSheet process() {
        if (this.m_SelectedPanels.length < 2) {
            this.getLogger().warning("At least two panels must be selected!");
            return null;
        }
        SpreadSheet result = null;
        SpreadSheetMerge merge = (SpreadSheetMerge)((Object)this.m_Editor.getValue());
        SpreadSheet[] sheets = new SpreadSheet[this.m_SelectedPanels.length];
        for (int i = 0; i < this.m_SelectedPanels.length; ++i) {
            sheets[i] = this.m_SelectedPanels[i].getSheet();
        }
        Token token = new Token((Object)sheets);
        merge.input(token);
        String msg = merge.execute();
        if (msg == null) {
            if (merge.hasPendingOutput()) {
                token = merge.output();
                result = (SpreadSheet)token.getPayload();
                merge.cleanUp();
            } else {
                this.getLogger().severe("Merge did not generate any output!");
            }
        } else {
            this.getLogger().severe("Failed to merge spreadsheets: " + msg);
        }
        return result;
    }
}

