/*
 * Decompiled with CFR 0.152.
 */
package adams.core.base;

import adams.core.Utils;
import adams.core.base.AbstractBaseString;
import java.awt.Point;

public class BasePointInt
extends AbstractBaseString {
    private static final long serialVersionUID = -3504062141216626521L;
    public static final String SEPARATOR = ";";
    public static final String DEFAULT = "0;0";

    public BasePointInt() {
        this(DEFAULT);
    }

    public BasePointInt(String s) {
        super(s);
    }

    public BasePointInt(Point value) {
        this(BasePointInt.toString(value));
    }

    public BasePointInt(int x, int y) {
        this(new Point(x, y));
    }

    @Override
    protected void initialize() {
        this.m_Internal = DEFAULT;
    }

    @Override
    public boolean isValid(String value) {
        if (value == null) {
            return false;
        }
        return this.parse(value) != null;
    }

    public Point pointValue() {
        return this.parse((String)((Object)this.m_Internal));
    }

    @Override
    public String getTipText() {
        return "An integer point (x;y).";
    }

    public static String toString(Point d) {
        return d.x + SEPARATOR + d.y;
    }

    public Point parse(String s) {
        String[] parts;
        Point result = null;
        if (s.indexOf(SEPARATOR) > 0 && (parts = s.split(SEPARATOR)).length == 2 && Utils.isInteger(parts[0]) && Utils.isInteger(parts[1])) {
            result = new Point(Integer.parseInt(parts[0]), Integer.parseInt(parts[1]));
        }
        return result;
    }
}

