/*
 * Decompiled with CFR 0.152.
 */
package adams.core.io;

import adams.core.Properties;
import adams.core.Utils;
import adams.core.io.PlaceholderFile;
import adams.core.management.OS;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.List;

public class FileUtils {
    public static final String FILENAME = "adams/core/io/FileUtils.props";
    protected static Properties m_Properties;
    protected static String FILENAME_CHARS;
    protected static Integer MAX_EXTENSION_LENGTH;
    protected static String[] IGNORED_EXTENSION_SUFFIXES;
    public static final int BINARY_CHECK_BUFFER_SIZE = 1024;

    protected static synchronized Properties getProperties() {
        if (m_Properties == null) {
            Properties result;
            try {
                result = Properties.read(FILENAME);
            }
            catch (Exception e) {
                result = new Properties();
            }
            m_Properties = result;
        }
        return m_Properties;
    }

    public static synchronized String getFileNameChars() {
        if (FILENAME_CHARS == null) {
            FILENAME_CHARS = FileUtils.getProperties().getProperty("FileNameChars", "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789_-.,;()#@");
        }
        return FILENAME_CHARS;
    }

    public static synchronized int getMaxExtensionLength() {
        if (MAX_EXTENSION_LENGTH == null) {
            MAX_EXTENSION_LENGTH = FileUtils.getProperties().getInteger("MaxExtensionLength", 6);
        }
        return MAX_EXTENSION_LENGTH;
    }

    public static synchronized String[] getIgnoredExtensionSuffixes() {
        if (IGNORED_EXTENSION_SUFFIXES == null) {
            IGNORED_EXTENSION_SUFFIXES = FileUtils.getProperties().getProperty("IgnoredExtensionSuffixes", "7z,bz2,gz").replaceAll(" ", "").split(",");
        }
        return IGNORED_EXTENSION_SUFFIXES;
    }

    public static List<String> loadFromFile(File file) {
        return FileUtils.loadFromFile(file, null);
    }

    public static List<String> loadFromFile(File file, String encoding) {
        ArrayList<String> result = new ArrayList<String>();
        try {
            String line;
            BufferedReader reader = encoding != null && encoding.length() > 0 ? new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file.getAbsolutePath()), encoding)) : new BufferedReader(new InputStreamReader(new FileInputStream(file.getAbsolutePath())));
            while ((line = reader.readLine()) != null) {
                result.add(line);
            }
            reader.close();
        }
        catch (Exception e) {
            result = null;
            e.printStackTrace();
        }
        return result;
    }

    public static byte[] loadFromBinaryFile(File file) {
        byte[] result;
        int i;
        ArrayList<Byte> content = new ArrayList<Byte>();
        BufferedInputStream stream = null;
        try {
            int read;
            byte[] buffer = new byte[1024];
            stream = new BufferedInputStream(new FileInputStream(file.getAbsoluteFile()));
            while ((read = stream.read(buffer)) != -1) {
                for (i = 0; i < read; ++i) {
                    content.add(buffer[i]);
                }
            }
        }
        catch (Exception e) {
            System.err.println("Problem loading binary file '" + file + "':");
            e.printStackTrace();
            content = null;
        }
        if (stream != null) {
            try {
                stream.close();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (content != null) {
            result = new byte[content.size()];
            for (i = 0; i < result.length; ++i) {
                result[i] = (Byte)content.get(i);
            }
        } else {
            result = null;
        }
        return result;
    }

    public static String loadHexFromBinaryFile(File file) {
        return FileUtils.loadHexFromBinaryFile(file, 16);
    }

    public static String loadHexFromBinaryFile(File file, int columns) {
        byte[] content = FileUtils.loadFromBinaryFile(file);
        if (content == null) {
            return null;
        }
        return Utils.toHex(content, columns);
    }

    public static byte[] loadByteArrayFromFile(File file) {
        byte[] result;
        BufferedInputStream bis = null;
        ByteArrayOutputStream bytesIn = null;
        try {
            int ch;
            bis = new BufferedInputStream(new FileInputStream(file.getAbsoluteFile()));
            bytesIn = new ByteArrayOutputStream();
            while ((ch = bis.read()) != -1) {
                bytesIn.write(ch);
            }
            bis.close();
            result = bytesIn.toByteArray();
        }
        catch (Exception e) {
            result = null;
            e.printStackTrace();
        }
        return result;
    }

    public static boolean saveToFile(String[] content, File file) {
        ArrayList<String> lines = new ArrayList<String>();
        for (int i = 0; i < content.length; ++i) {
            lines.add(content[i]);
        }
        return FileUtils.saveToFile(lines, file);
    }

    public static boolean saveToFile(List<String> content, File file) {
        return FileUtils.saveToFile(content, file, null);
    }

    public static boolean saveToFile(List<String> content, File file, String encoding) {
        boolean result = true;
        try {
            BufferedWriter writer = encoding != null && encoding.length() > 0 ? new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file.getAbsolutePath()), encoding)) : new BufferedWriter(new OutputStreamWriter(new FileOutputStream(file.getAbsolutePath())));
            for (int i = 0; i < content.size(); ++i) {
                writer.write(content.get(i));
                writer.newLine();
            }
            writer.flush();
            writer.close();
        }
        catch (Exception e) {
            result = false;
            e.printStackTrace();
        }
        return result;
    }

    public static boolean writeToFile(String filename, Object obj) {
        return FileUtils.writeToFile(filename, obj, null);
    }

    public static boolean writeToFile(String filename, Object obj, String encoding) {
        return FileUtils.writeToFile(filename, obj, true, encoding);
    }

    public static boolean writeToFile(String filename, Object obj, boolean append) {
        return FileUtils.writeToFile(filename, obj, append, null);
    }

    public static boolean writeToFile(String filename, Object obj, boolean append, String encoding) {
        boolean result;
        try {
            BufferedWriter writer = encoding != null && encoding.length() > 0 ? new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(filename, append), encoding)) : new BufferedWriter(new OutputStreamWriter(new FileOutputStream(filename, append)));
            writer.write("" + obj);
            writer.newLine();
            writer.flush();
            writer.close();
            result = true;
        }
        catch (Exception e) {
            result = false;
        }
        return result;
    }

    public static boolean copyOrMove(File sourceLocation, File targetLocation, boolean move) throws IOException {
        int len;
        if (sourceLocation.isDirectory()) {
            if (!targetLocation.exists() && !targetLocation.mkdir()) {
                return false;
            }
            String[] children = sourceLocation.list();
            for (int i = 0; i < children.length; ++i) {
                if (FileUtils.copyOrMove(new File(sourceLocation.getAbsoluteFile(), children[i]), new File(targetLocation.getAbsoluteFile(), children[i]), move)) continue;
                return false;
            }
            if (move) {
                return sourceLocation.delete();
            }
            return true;
        }
        FileInputStream in = new FileInputStream(sourceLocation.getAbsoluteFile());
        FileOutputStream out = targetLocation.isDirectory() ? new FileOutputStream(targetLocation.getAbsolutePath() + File.separator + sourceLocation.getName()) : new FileOutputStream(targetLocation.getAbsoluteFile());
        byte[] buf = new byte[1024];
        while ((len = ((InputStream)in).read(buf)) > 0) {
            ((OutputStream)out).write(buf, 0, len);
        }
        ((InputStream)in).close();
        ((OutputStream)out).close();
        if (move) {
            return sourceLocation.delete();
        }
        return true;
    }

    public static boolean copy(File sourceLocation, File targetLocation) throws IOException {
        return FileUtils.copyOrMove(sourceLocation, targetLocation, false);
    }

    public static boolean move(File sourceLocation, File targetLocation) throws IOException {
        return FileUtils.copyOrMove(sourceLocation, targetLocation, true);
    }

    public static boolean delete(String file) {
        return FileUtils.delete(new PlaceholderFile(file));
    }

    public static boolean delete(File file) {
        boolean result = true;
        if (file.isDirectory()) {
            File[] files;
            for (File f : files = file.listFiles()) {
                if (f.getName().equals(".") || f.getName().equals("..")) continue;
                FileUtils.delete(f);
            }
        }
        result = file.delete();
        return result;
    }

    public static String createFilename(String s, String replace) {
        StringBuilder result = new StringBuilder();
        String chars = FileUtils.getFileNameChars();
        for (int i = 0; i < s.length(); ++i) {
            if (chars.indexOf(s.charAt(i)) == -1) {
                result.append(replace);
                continue;
            }
            result.append(s.charAt(i));
        }
        return result.toString();
    }

    public static int getDirectoryDepth(File file) {
        int result = 0;
        if (!file.isDirectory()) {
            file = file.getParentFile();
        }
        while (file.getParentFile() != null) {
            ++result;
            file = file.getParentFile();
        }
        return result;
    }

    public static String createPartialFilename(File file, int numParentDirs) {
        String result;
        if (numParentDirs == -1) {
            result = file.getAbsolutePath();
        } else {
            result = file.getName();
            File parent = file;
            for (int i = 0; i < numParentDirs && parent.getParentFile() != null; ++i) {
                parent = parent.getParentFile();
                result = parent.getName() + File.separator + result;
            }
        }
        return result;
    }

    public static boolean isDirEmpty(File dir) {
        return FileUtils.isDirEmpty(dir, null);
    }

    public static boolean isDirEmpty(String dir) {
        return FileUtils.isDirEmpty(dir, null);
    }

    public static boolean isDirEmpty(File dir, String regExp) {
        return FileUtils.isDirEmpty(dir.getAbsolutePath(), regExp);
    }

    public static boolean isDirEmpty(String dir, String regExp) {
        boolean result = true;
        File file = new File(dir);
        if (!file.exists() || !file.isDirectory()) {
            return result;
        }
        String[] files = file.list();
        for (int i = 0; i < files.length; ++i) {
            if (files[i].equals(".") || files[i].equals("..") || regExp != null && !files[i].matches(regExp)) continue;
            result = false;
            break;
        }
        return result;
    }

    public static String fixExecutable(String executable) {
        String result = executable;
        if (OS.isWindows()) {
            if (!result.endsWith(".exe") || !result.endsWith(".com")) {
                result = result + ".exe";
            }
        } else if (result.endsWith(".exe") || result.endsWith(".com")) {
            result = result.substring(0, result.length() - 4);
        }
        return result;
    }

    public static String quoteExecutable(String executable) {
        String result = executable;
        if (result.indexOf(32) > -1) {
            result = "\"" + result + "\"";
        }
        return result;
    }

    public static String removeIgnoredExtensionSuffixes(String filename) {
        String[] ignored;
        String result = filename;
        for (String suffix : ignored = FileUtils.getIgnoredExtensionSuffixes()) {
            if (!result.endsWith("." + suffix)) continue;
            result = result.substring(0, result.length() - suffix.length() - 1);
        }
        return result;
    }

    public static String getExtension(File file) {
        return FileUtils.getExtension(file.getAbsolutePath());
    }

    public static String getExtension(String filename) {
        String[] result = FileUtils.getExtensions(filename);
        if (result != null) {
            return result[0];
        }
        return null;
    }

    public static String[] getExtensions(File file) {
        return FileUtils.getExtensions(file.getAbsolutePath());
    }

    public static String[] getExtensions(String filename) {
        if (filename.indexOf(46) == -1) {
            return null;
        }
        ArrayList<String> result = new ArrayList<String>();
        String shortened = FileUtils.removeIgnoredExtensionSuffixes(filename);
        int max = FileUtils.getMaxExtensionLength();
        int pos = filename.lastIndexOf(46, shortened.length() - 1);
        result.add(filename.substring(pos + 1));
        int posNext = filename.lastIndexOf(46, pos - 1);
        if (posNext > -1 && pos - posNext <= max) {
            result.add(filename.substring(posNext + 1));
        }
        return result.toArray(new String[result.size()]);
    }

    public static File replaceExtension(File file, String newExt) {
        return new File(FileUtils.replaceExtension(file.getAbsolutePath(), newExt));
    }

    public static PlaceholderFile replaceExtension(PlaceholderFile file, String newExt) {
        return new PlaceholderFile(FileUtils.replaceExtension(file.getAbsolutePath(), newExt));
    }

    public static String replaceExtension(String file, String newExt) {
        String result = file;
        int index = (file = FileUtils.removeIgnoredExtensionSuffixes(file)).lastIndexOf(46);
        if (index > -1) {
            result = newExt.length() > 0 ? file.substring(0, index) + newExt : file.substring(0, index);
        }
        return result;
    }

    public static File getTempDirectory() {
        return new File(System.getProperty("java.io.tmpdir"));
    }

    public static boolean isBinary(String filename) {
        return FileUtils.isBinary(new PlaceholderFile(filename));
    }

    public static boolean isBinary(File file) {
        int read;
        boolean result = false;
        BufferedInputStream stream = null;
        byte[] buffer = new byte[1024];
        try {
            stream = new BufferedInputStream(new FileInputStream(file.getAbsoluteFile()));
            read = stream.read(buffer);
        }
        catch (Exception e) {
            System.err.println("Problem reading binary file '" + file + "':");
            e.printStackTrace();
            read = -1;
        }
        if (stream != null) {
            try {
                stream.close();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (read > -1) {
            block7: for (int i = 0; i < read && !result; ++i) {
                if (buffer[i] >= 32) continue;
                switch (buffer[i]) {
                    case 9: 
                    case 10: 
                    case 13: {
                        continue block7;
                    }
                    default: {
                        result = true;
                    }
                }
            }
        }
        return result;
    }

    public static String convertPlaceholder(String file) {
        if (file.startsWith("${")) {
            return new PlaceholderFile(file).getAbsolutePath();
        }
        return file;
    }

    public static PlaceholderFile[] toPlaceholderFileArray(Object input) {
        PlaceholderFile[] result;
        if (input instanceof String) {
            result = new PlaceholderFile[]{new PlaceholderFile((String)input)};
        } else if (input instanceof String[]) {
            String[] str = (String[])input;
            result = new PlaceholderFile[str.length];
            for (int i = 0; i < str.length; ++i) {
                result[i] = new PlaceholderFile(str[i]);
            }
        } else if (input instanceof File) {
            result = new PlaceholderFile[]{new PlaceholderFile((File)input)};
        } else if (input instanceof File[]) {
            result = (PlaceholderFile[])input;
        } else {
            throw new IllegalArgumentException("Unhandled class: " + Utils.classToString(input.getClass()));
        }
        return result;
    }

    public static File[] toFileArray(Object input) {
        File[] result;
        if (input instanceof String) {
            result = new File[]{new File(FileUtils.convertPlaceholder((String)input))};
        } else if (input instanceof String[]) {
            String[] str = (String[])input;
            result = new File[str.length];
            for (int i = 0; i < str.length; ++i) {
                result[i] = new File(FileUtils.convertPlaceholder(str[i]));
            }
        } else if (input instanceof File) {
            result = new File[]{((File)input).getAbsoluteFile()};
        } else if (input instanceof File[]) {
            File[] files = (File[])input;
            result = new File[files.length];
            for (int i = 0; i < files.length; ++i) {
                result[i] = files[i].getAbsoluteFile();
            }
        } else {
            throw new IllegalArgumentException("Unhandled class: " + Utils.classToString(input.getClass()));
        }
        return result;
    }

    public static String[] toStringArray(Object input) {
        String[] result;
        if (input instanceof String) {
            result = new String[]{FileUtils.convertPlaceholder((String)input)};
        } else if (input instanceof String[]) {
            String[] str = (String[])input;
            result = new String[str.length];
            for (int i = 0; i < str.length; ++i) {
                result[i] = FileUtils.convertPlaceholder(str[i]);
            }
        } else if (input instanceof File) {
            result = new String[]{((File)input).getAbsolutePath()};
        } else if (input instanceof File[]) {
            File[] files = (File[])input;
            result = new String[files.length];
            for (int i = 0; i < files.length; ++i) {
                result[i] = files[i].getAbsolutePath();
            }
        } else {
            throw new IllegalArgumentException("Unhandled class: " + Utils.classToString(input.getClass()));
        }
        return result;
    }

    public static String useForwardSlashes(String path) {
        String result = path.startsWith("\\\\") ? "\\\\" + path.substring(2).replace("\\", "/") : path.replace("\\", "/");
        return result;
    }
}

