/*
 * Decompiled with CFR 0.152.
 */
package adams.core.option;

import adams.core.ClassLocator;
import adams.core.option.AbstractArgumentOption;
import adams.core.option.AbstractCommandLineHandler;
import adams.core.option.NestedConsumer;
import adams.core.option.OptionHandler;
import adams.core.option.OptionManager;
import adams.core.option.OptionUtils;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;

public class ClassOption
extends AbstractArgumentOption {
    private static final long serialVersionUID = 945814491797364391L;

    protected ClassOption(OptionManager owner, String commandline, String property, Object defValue) {
        this(owner, commandline, property, defValue, true);
    }

    protected ClassOption(OptionManager owner, String commandline, String property, Object defValue, boolean outputDefValue) {
        super(owner, commandline, property, defValue, outputDefValue);
    }

    @Override
    protected boolean compareValues(Object value, Object defValue) {
        return false;
    }

    @Override
    public Object valueOf(String s) throws Exception {
        return OptionUtils.forAnyCommandLine(this.getBaseClass(), s);
    }

    @Override
    public String toString(Object obj) {
        return OptionUtils.getCommandLine(obj);
    }

    protected void setNestedValues(ArrayList values) {
        int size = this.isMultiple() ? values.size() : 1;
        Object value = Array.newInstance(this.getBaseClass(), size);
        if (this.getDebug()) {
            System.out.println(this.getOptionHandler().getClass().getName() + "/" + this.getClass().getName() + "/" + "-" + this.getCommandline() + ": #" + size + " value(s)");
        }
        try {
            for (int i = 0; i < size; ++i) {
                AbstractCommandLineHandler handler;
                ArrayList pair;
                if (values.get(i) instanceof String) {
                    pair = new ArrayList();
                    String str = (String)values.get(i);
                    if (str.indexOf(32) > -1) {
                        pair.add(str.substring(0, str.indexOf(32)));
                        pair.add(str.substring(str.indexOf(32) + 1));
                    } else {
                        pair.add(str);
                    }
                } else {
                    pair = (ArrayList)values.get(i);
                }
                String classname = (String)pair.get(0);
                Object element = OptionUtils.forName(this.getBaseClass(), classname, new String[0]);
                Array.set(value, i, element);
                if (pair.size() <= 1) continue;
                if (pair.get(1) instanceof String) {
                    String optionStr = (String)pair.get(1);
                    if (ClassLocator.hasInterface(OptionHandler.class, element.getClass())) {
                        pair.set(1, new ArrayList<String>(Arrays.asList(OptionUtils.splitOptions(optionStr))));
                    } else {
                        handler = AbstractCommandLineHandler.getHandler(element);
                        pair.set(1, new ArrayList<String>(Arrays.asList(handler.splitOptions(optionStr))));
                    }
                }
                if (ClassLocator.hasInterface(OptionHandler.class, element.getClass())) {
                    NestedConsumer consumer = new NestedConsumer();
                    consumer.consume((OptionHandler)element, (ArrayList)pair.get(1));
                    consumer.cleanUp();
                    continue;
                }
                handler = AbstractCommandLineHandler.getHandler(element);
                ArrayList nested = (ArrayList)pair.get(1);
                ArrayList<String> options = new ArrayList<String>();
                for (int n = 0; n < nested.size(); ++n) {
                    options.add((String)nested.get(n));
                }
                handler.setOptions(element, options.toArray(new String[options.size()]));
            }
            Method method = this.getWriteMethod();
            if (this.isMultiple()) {
                method.invoke((Object)this.getOptionHandler(), value);
            } else {
                method.invoke((Object)this.getOptionHandler(), Array.get(value, 0));
            }
        }
        catch (Exception e) {
            if (!this.m_Owner.isQuiet()) {
                System.err.println("Error setting nested values for " + this.getOptionHandler().getClass().getName() + "/" + this.getClass().getName() + "/" + "-" + this.getCommandline() + ": " + values);
                e.printStackTrace();
            }
            return;
        }
    }

    protected void addArgumentInfo(StringBuilder buffer) {
        buffer.append(" <" + this.getBaseClass().getName() + " [options]>");
    }

    @Override
    public String toString() {
        return "-" + this.getCommandline() + "/" + this.getProperty() + " <" + this.m_BaseClass.getName() + ">" + (this.isMultiple() ? " ..." : "");
    }

    @Override
    public void cleanUp() {
        Object values;
        Object value = this.getCurrentValue();
        if (!this.isMultiple()) {
            values = Array.newInstance(this.getBaseClass(), 1);
            Array.set(values, 0, value);
        } else {
            values = value;
            int n = Array.getLength(values);
        }
        int len = Array.getLength(values);
        for (int i = 0; i < len; ++i) {
            value = Array.get(values, i);
            if (!(value instanceof OptionHandler)) continue;
            try {
                ((OptionHandler)value).cleanUpOptions();
                continue;
            }
            catch (Exception e) {
                if (this.m_Owner.isQuiet()) continue;
                System.err.println("Error calling cleanUp()/" + this.getProperty() + ":");
                e.printStackTrace();
            }
        }
        super.cleanUp();
    }
}

