/*
 * Decompiled with CFR 0.152.
 */
package adams.core.option;

import adams.core.ClassLocator;
import adams.core.CleanUpHandler;
import adams.core.EnumWithCustomDisplay;
import adams.core.Variables;
import adams.core.VariablesHandler;
import adams.core.base.BaseObject;
import adams.core.option.AbstractArgumentOption;
import adams.core.option.AbstractOption;
import adams.core.option.BaseObjectOption;
import adams.core.option.BooleanOption;
import adams.core.option.ByteOption;
import adams.core.option.ClassOption;
import adams.core.option.CustomHooksOption;
import adams.core.option.DoubleOption;
import adams.core.option.EnumOption;
import adams.core.option.FloatOption;
import adams.core.option.IntegerOption;
import adams.core.option.LongOption;
import adams.core.option.OptionHandler;
import adams.core.option.OptionManagerException;
import adams.core.option.OptionTraversalPath;
import adams.core.option.OptionTraverser;
import adams.core.option.OptionTraverserWithResult;
import adams.core.option.OptionUtils;
import adams.core.option.PreGetOptionslistHook;
import adams.core.option.ShortOption;
import adams.core.option.StringOption;
import adams.flow.core.AbstractActor;
import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class OptionManager
implements Serializable,
CleanUpHandler {
    private static final long serialVersionUID = 2383307592894383257L;
    protected OptionHandler m_Owner;
    protected List<AbstractOption> m_Options;
    protected HashMap<String, Integer> m_CommandlineIndex;
    protected HashMap<String, Integer> m_PropertyIndex;
    protected boolean m_ThrowExceptions;
    protected Variables m_Variables;
    protected boolean m_Quiet;

    public OptionManager(OptionHandler owner) {
        this.m_Owner = owner;
        this.m_Options = new ArrayList<AbstractOption>();
        this.m_CommandlineIndex = new HashMap();
        this.m_PropertyIndex = new HashMap();
        this.m_ThrowExceptions = false;
        this.m_Variables = null;
        this.m_Quiet = false;
    }

    public OptionHandler getOwner() {
        return this.m_Owner;
    }

    public void setVariables(Variables value) {
        this.m_Variables = value;
    }

    public synchronized Variables getVariables() {
        if (this.m_Variables == null) {
            this.m_Variables = new Variables();
        }
        return this.m_Variables;
    }

    public void setThrowExceptions(boolean value) {
        this.m_ThrowExceptions = value;
        for (int i = 0; i < this.m_Options.size(); ++i) {
            Object current;
            if (!(this.m_Options.get(i) instanceof ClassOption) || !((current = ((ClassOption)this.m_Options.get(i)).getCurrentValue()) instanceof OptionHandler)) continue;
            ((OptionHandler)current).getOptionManager().setThrowExceptions(value);
        }
    }

    public boolean getThrowExceptions() {
        return this.m_ThrowExceptions;
    }

    public void setQuiet(boolean value) {
        this.m_Quiet = value;
    }

    public boolean isQuiet() {
        return this.m_Quiet;
    }

    protected void handleError(Throwable t) {
        if (this.m_ThrowExceptions) {
            throw new OptionManagerException(t);
        }
        t.printStackTrace();
    }

    public AbstractOption add(String commandline, String property, Object defValue) {
        return this.insert(-1, commandline, property, defValue, true);
    }

    public AbstractOption insert(int index, String commandline, String property, Object defValue) {
        return this.insert(index, commandline, property, defValue, true);
    }

    public AbstractOption add(String commandline, String property, Object defValue, boolean outputDefValue) {
        return this.insert(-1, commandline, property, defValue, outputDefValue, null, null);
    }

    public AbstractOption insert(int index, String commandline, String property, Object defValue, boolean outputDefValue) {
        return this.insert(index, commandline, property, defValue, outputDefValue, null, null);
    }

    public AbstractOption add(String commandline, String property, Object defValue, Number lower, Number upper) {
        return this.insert(-1, commandline, property, defValue, true, lower, upper);
    }

    public AbstractOption insert(int index, String commandline, String property, Object defValue, Number lower, Number upper) {
        return this.insert(index, commandline, property, defValue, true, lower, upper);
    }

    public AbstractOption add(String commandline, String property, Object defValue, boolean outputDefValue, Number lower, Number upper) {
        return this.insert(-1, commandline, property, defValue, outputDefValue, lower, upper);
    }

    public AbstractOption insert(int index, String commandline, String property, Object defValue, boolean outputDefValue, Number lower, Number upper) {
        OptionUtils.registerCustomHooks();
        if (this.m_CommandlineIndex.containsKey(commandline)) {
            this.handleError(new IllegalArgumentException("Command-line flag '" + commandline + "' is already in use (" + this.getOwner().getClass().getName() + ")!"));
        }
        if (this.m_PropertyIndex.containsKey(property)) {
            this.handleError(new IllegalArgumentException("Property '" + property + "' is already in use (" + this.getOwner().getClass().getName() + ")!"));
        }
        if (index == -1) {
            index = this.m_CommandlineIndex.size();
            this.m_CommandlineIndex.put(commandline, this.m_CommandlineIndex.size());
            this.m_PropertyIndex.put(property, this.m_PropertyIndex.size());
        } else if (index > -1) {
            for (String key : this.m_CommandlineIndex.keySet()) {
                if (this.m_CommandlineIndex.get(key) < index) continue;
                this.m_CommandlineIndex.put(key, this.m_CommandlineIndex.get(key) + 1);
            }
            for (String key : this.m_PropertyIndex.keySet()) {
                if (this.m_PropertyIndex.get(key) < index) continue;
                this.m_PropertyIndex.put(key, this.m_PropertyIndex.get(key) + 1);
            }
            this.m_CommandlineIndex.put(commandline, index);
            this.m_PropertyIndex.put(property, index);
        } else {
            this.handleError(new IllegalArgumentException("Invalid index for option '" + property + "' (" + this.getOwner().getClass().getName() + "): " + index));
        }
        Class<?> baseclass = defValue.getClass();
        if (baseclass.isArray()) {
            baseclass = baseclass.getComponentType();
        }
        if (baseclass == Boolean.TYPE || baseclass == Boolean.class) {
            BooleanOption result = new BooleanOption(this, commandline, property, defValue, outputDefValue);
            this.m_Options.add(index, result);
            return result;
        }
        if (baseclass == String.class) {
            StringOption result = new StringOption(this, commandline, property, defValue, outputDefValue);
            this.m_Options.add(index, result);
            return result;
        }
        if (baseclass == Integer.TYPE || baseclass == Integer.class) {
            IntegerOption result = new IntegerOption(this, commandline, property, defValue, outputDefValue, (Integer)lower, (Integer)upper);
            this.m_Options.add(index, result);
            return result;
        }
        if (baseclass == Double.TYPE || baseclass == Double.class) {
            DoubleOption result = new DoubleOption(this, commandline, property, defValue, outputDefValue, (Double)lower, (Double)upper);
            this.m_Options.add(index, result);
            return result;
        }
        if (baseclass == Long.TYPE || baseclass == Long.class) {
            LongOption result = new LongOption(this, commandline, property, defValue, outputDefValue, (Long)lower, (Long)upper);
            this.m_Options.add(index, result);
            return result;
        }
        if (baseclass == Float.TYPE || baseclass == Float.class) {
            FloatOption result = new FloatOption(this, commandline, property, defValue, outputDefValue, (Float)lower, (Float)upper);
            this.m_Options.add(index, result);
            return result;
        }
        if (baseclass == Byte.TYPE || baseclass == Byte.class) {
            ByteOption result = new ByteOption(this, commandline, property, defValue, outputDefValue, (Byte)lower, (Byte)upper);
            this.m_Options.add(index, result);
            return result;
        }
        if (baseclass == Short.TYPE || baseclass == Short.class) {
            ShortOption result = new ShortOption(this, commandline, property, defValue, outputDefValue, (Short)lower, (Short)upper);
            this.m_Options.add(index, result);
            return result;
        }
        try {
            PropertyDescriptor descriptor = OptionUtils.getDescriptor(this.getOwner(), property);
            baseclass = descriptor.getReadMethod().getReturnType();
            if (baseclass.isArray()) {
                baseclass = baseclass.getComponentType();
            }
            if (ClassLocator.isSubclass(BaseObject.class, baseclass)) {
                BaseObjectOption result = new BaseObjectOption(this, commandline, property, defValue, outputDefValue);
                this.m_Options.add(index, result);
                return result;
            }
            if (ClassLocator.hasInterface(EnumWithCustomDisplay.class, baseclass) || ClassLocator.isSubclass(Enum.class, baseclass)) {
                EnumOption result = new EnumOption(this, commandline, property, defValue, outputDefValue);
                this.m_Options.add(index, result);
                return result;
            }
            if (OptionUtils.getValueOfHook(baseclass) != null || OptionUtils.getToStringHook(baseclass) != null) {
                CustomHooksOption result = new CustomHooksOption(this, commandline, property, defValue, outputDefValue);
                this.m_Options.add(index, result);
                return result;
            }
            ClassOption result = new ClassOption(this, commandline, property, defValue, outputDefValue);
            this.m_Options.add(index, result);
            return result;
        }
        catch (Exception e) {
            this.handleError(new Exception("Failed to add " + commandline + "/" + property + " (" + this.getOwner() + ")!", e));
            return null;
        }
    }

    public List<AbstractOption> getOptionsList() {
        if (this.getOwner() instanceof PreGetOptionslistHook) {
            ((PreGetOptionslistHook)((Object)this.getOwner())).preGetOptionsList();
        }
        return this.m_Options;
    }

    protected AbstractOption findOption(String flagOrProperty, boolean flag) {
        AbstractOption result = null;
        Integer index = flag ? this.m_CommandlineIndex.get(flagOrProperty) : this.m_PropertyIndex.get(flagOrProperty);
        if (index != null) {
            result = this.m_Options.get(index);
        }
        return result;
    }

    public AbstractOption findByFlag(String flag) {
        return this.findOption(flag, true);
    }

    public AbstractOption findByProperty(String property) {
        return this.findOption(property, false);
    }

    public AbstractOption findByClass(Class cls) {
        AbstractOption result = null;
        for (AbstractOption option : this.m_Options) {
            if (option.getReadMethod().getReturnType() != cls) continue;
            result = option;
            break;
        }
        return result;
    }

    public AbstractOption removeByFlag(String flag) {
        return this.removeOption(flag, true);
    }

    public AbstractOption removeByProperty(String property) {
        return this.removeOption(property, false);
    }

    protected AbstractOption removeOption(String flagOrProperty, boolean flag) {
        AbstractOption result = null;
        Integer index = flag ? this.m_CommandlineIndex.get(flagOrProperty) : this.m_PropertyIndex.get(flagOrProperty);
        if (index != null) {
            result = this.m_Options.get(index);
            this.m_Options.remove(index);
            String removeKey = null;
            for (String key : this.m_CommandlineIndex.keySet()) {
                if (this.m_CommandlineIndex.get(key) != index) continue;
                removeKey = key;
            }
            this.m_CommandlineIndex.remove(removeKey);
            removeKey = null;
            for (String key : this.m_PropertyIndex.keySet()) {
                if (this.m_PropertyIndex.get(key) != index) continue;
                removeKey = key;
            }
            this.m_PropertyIndex.remove(removeKey);
            for (String key : this.m_CommandlineIndex.keySet()) {
                if (this.m_CommandlineIndex.get(key) <= index) continue;
                this.m_CommandlineIndex.put(key, this.m_CommandlineIndex.get(key) - 1);
            }
            for (String key : this.m_PropertyIndex.keySet()) {
                if (this.m_PropertyIndex.get(key) <= index) continue;
                this.m_PropertyIndex.put(key, this.m_PropertyIndex.get(key) - 1);
            }
        }
        return result;
    }

    public AbstractArgumentOption setVariableForProperty(String property, String variable) {
        AbstractArgumentOption argOption;
        AbstractArgumentOption result = null;
        AbstractOption option = this.findOption(property, false);
        if (option != null && option instanceof AbstractArgumentOption && (argOption = (AbstractArgumentOption)option).getProperty().equals(property)) {
            result = argOption;
            argOption.setVariable(variable);
        }
        return result;
    }

    public String getVariableForProperty(String property) {
        AbstractArgumentOption argOption;
        String result = null;
        AbstractOption option = this.findOption(property, false);
        if (option != null && option instanceof AbstractArgumentOption && (argOption = (AbstractArgumentOption)option).getProperty().equals(property)) {
            result = argOption.getVariable();
        }
        return result;
    }

    public void setDefaults() {
        for (int i = 0; i < this.m_Options.size(); ++i) {
            AbstractOption option = this.m_Options.get(i);
            Method method = option.getWriteMethod();
            try {
                method.invoke((Object)option.getOptionHandler(), option.getDefaultValue());
                continue;
            }
            catch (Exception e) {
                if (!this.m_Quiet) {
                    System.err.println("Error setting default value for '" + this.m_Owner.getClass().getName() + "/" + option.getProperty() + "':");
                }
                this.handleError(e);
            }
        }
    }

    public void updateVariablesInstance(final Variables variables) {
        this.traverse(new OptionTraverser(){

            protected void update(AbstractOption option, OptionTraversalPath path) {
                if (option.getOwner().getVariables() != variables) {
                    option.getOwner().setVariables(variables);
                }
            }

            @Override
            public void handleBooleanOption(BooleanOption option, OptionTraversalPath path) {
                this.update(option, path);
            }

            @Override
            public void handleClassOption(ClassOption option, OptionTraversalPath path) {
                this.update(option, path);
            }

            @Override
            public void handleArgumentOption(AbstractArgumentOption option, OptionTraversalPath path) {
                this.update(option, path);
            }

            @Override
            public boolean canHandle(AbstractOption option) {
                return true;
            }

            @Override
            public boolean canRecurse(Class cls) {
                return !ClassLocator.hasInterface(VariablesHandler.class, cls) && !ClassLocator.isSubclass(AbstractActor.class, cls);
            }

            @Override
            public boolean canRecurse(Object obj) {
                return this.canRecurse(obj.getClass());
            }
        }, true);
    }

    public String updateVariableValues() {
        return this.updateVariableValues(false);
    }

    public String updateVariableValues(final boolean forceUpdate) {
        OptionTraverserWithResult<StringBuilder> traverser = new OptionTraverserWithResult<StringBuilder>(){
            protected StringBuilder m_Result;

            @Override
            public void resetResult() {
                this.m_Result = new StringBuilder();
            }

            @Override
            public void handleBooleanOption(BooleanOption option, OptionTraversalPath path) {
                this.handleArgumentOption(option, path);
            }

            @Override
            public void handleClassOption(ClassOption option, OptionTraversalPath path) {
                this.handleArgumentOption(option, path);
            }

            @Override
            public void handleArgumentOption(AbstractArgumentOption option, OptionTraversalPath path) {
                String error;
                if ((option.isVariableModified() || option.isVariableAttached() && forceUpdate || option.isVariableReferencingObject()) && (error = option.updateVariable()) != null) {
                    if (this.m_Result.length() > 0) {
                        this.m_Result.append("\n");
                    }
                    this.m_Result.append(option.getOptionHandler().getClass().getName() + "/" + option.getProperty() + ": " + error);
                }
            }

            @Override
            public boolean canHandle(AbstractOption option) {
                return true;
            }

            @Override
            public boolean canRecurse(Class cls) {
                return !ClassLocator.hasInterface(VariablesHandler.class, cls);
            }

            @Override
            public boolean canRecurse(Object obj) {
                return this.canRecurse(obj.getClass());
            }

            @Override
            public StringBuilder getResult() {
                return this.m_Result;
            }
        };
        traverser.resetResult();
        this.traverse(traverser, true);
        StringBuilder result = (StringBuilder)traverser.getResult();
        if (result.length() == 0) {
            return null;
        }
        return result.toString();
    }

    public void registerVariables() {
        this.traverse(new OptionTraverser(){

            @Override
            public void handleBooleanOption(BooleanOption option, OptionTraversalPath path) {
                this.handleArgumentOption(option, path);
            }

            @Override
            public void handleClassOption(ClassOption option, OptionTraversalPath path) {
                this.handleArgumentOption(option, path);
            }

            @Override
            public void handleArgumentOption(AbstractArgumentOption option, OptionTraversalPath path) {
                if (option.isVariableAttached()) {
                    OptionManager.this.getVariables().addVariableChangeListener(option);
                }
            }

            @Override
            public boolean canHandle(AbstractOption option) {
                return true;
            }

            @Override
            public boolean canRecurse(Class cls) {
                return !ClassLocator.hasInterface(VariablesHandler.class, cls);
            }

            @Override
            public boolean canRecurse(Object obj) {
                return this.canRecurse(obj.getClass());
            }
        }, true);
    }

    public void deregisterVariables() {
        if (this.m_Variables == null) {
            return;
        }
        this.traverse(new OptionTraverser(){

            @Override
            public void handleBooleanOption(BooleanOption option, OptionTraversalPath path) {
                this.handleArgumentOption(option, path);
            }

            @Override
            public void handleClassOption(ClassOption option, OptionTraversalPath path) {
                this.handleArgumentOption(option, path);
            }

            @Override
            public void handleArgumentOption(AbstractArgumentOption option, OptionTraversalPath path) {
                if (option.isVariableAttached()) {
                    OptionManager.this.getVariables().removeVariableChangeListener(option);
                }
            }

            @Override
            public boolean canHandle(AbstractOption option) {
                return true;
            }

            @Override
            public boolean canRecurse(Class cls) {
                return !ClassLocator.hasInterface(VariablesHandler.class, cls);
            }

            @Override
            public boolean canRecurse(Object obj) {
                return this.canRecurse(obj.getClass());
            }
        }, true);
    }

    public void updateVariablePrefix(final String prefix, final boolean add) {
        this.traverse(new OptionTraverser(){

            @Override
            public void handleBooleanOption(BooleanOption option, OptionTraversalPath path) {
                this.handleArgumentOption(option, path);
            }

            @Override
            public void handleClassOption(ClassOption option, OptionTraversalPath path) {
                this.handleArgumentOption(option, path);
            }

            @Override
            public void handleArgumentOption(AbstractArgumentOption option, OptionTraversalPath path) {
                if (option.isVariableAttached()) {
                    String vname = option.getVariableName();
                    if (add) {
                        if (!vname.startsWith(prefix)) {
                            vname = prefix + vname;
                        }
                    } else if (!vname.startsWith(prefix)) {
                        vname = vname.substring(prefix.length());
                    }
                    option.setVariable(vname);
                }
            }

            @Override
            public boolean canHandle(AbstractOption option) {
                return true;
            }

            @Override
            public boolean canRecurse(Class cls) {
                return !ClassLocator.hasInterface(VariablesHandler.class, cls);
            }

            @Override
            public boolean canRecurse(Object obj) {
                return this.canRecurse(obj.getClass());
            }
        }, true);
    }

    public void traverse(OptionTraverser traverser) {
        this.traverse(traverser, false);
    }

    public void traverse(OptionTraverser traverser, boolean nonAdams) {
        this.traverse(traverser, new OptionTraversalPath(), nonAdams);
    }

    protected void traverse(OptionTraverser traverser, OptionTraversalPath path, boolean nonAdams) {
        List<AbstractOption> options = this.getOptionsList();
        for (AbstractOption opt : options) {
            int n;
            Object current;
            ClassOption cloption = null;
            if (opt instanceof BooleanOption) {
                if (traverser.canHandle(opt)) {
                    traverser.handleBooleanOption((BooleanOption)opt, path);
                }
            } else if (opt instanceof ClassOption) {
                cloption = (ClassOption)opt;
                if (traverser.canHandle(opt)) {
                    traverser.handleClassOption(cloption, path);
                }
            } else if (traverser.canHandle(opt)) {
                traverser.handleArgumentOption((AbstractArgumentOption)opt, path);
            }
            if (cloption == null || !traverser.canRecurse(cloption.getBaseClass()) || (current = cloption.getCurrentValue()) == null) continue;
            boolean isOptionHandler = ClassLocator.hasInterface(OptionHandler.class, cloption.getBaseClass());
            if (!isOptionHandler) {
                Class[] cls;
                if (current.getClass().isArray()) {
                    cls = new Class[Array.getLength(current)];
                    for (n = 0; n < cls.length; ++n) {
                        cls[n] = Array.get(current, n).getClass();
                    }
                } else {
                    cls = new Class[]{current.getClass()};
                }
                for (n = 0; n < cls.length && !(isOptionHandler = ClassLocator.hasInterface(OptionHandler.class, cls[n])); ++n) {
                }
            }
            if (isOptionHandler) {
                if (cloption.isMultiple()) {
                    for (n = 0; n < Array.getLength(current); ++n) {
                        Object element = Array.get(current, n);
                        if (!traverser.canRecurse(element)) continue;
                        path.push(cloption.getProperty() + "[" + n + "]");
                        ((OptionHandler)element).getOptionManager().traverse(traverser, path, nonAdams);
                        path.pop();
                    }
                    continue;
                }
                if (!traverser.canRecurse(current)) continue;
                path.push(cloption.getProperty());
                ((OptionHandler)current).getOptionManager().traverse(traverser, path, nonAdams);
                path.pop();
                continue;
            }
            if (!nonAdams) continue;
            this.traverse(traverser, path, current);
        }
    }

    protected void traverse(OptionTraverser traverser, OptionTraversalPath path, Object obj) {
        block5: {
            try {
                PropertyDescriptor[] props;
                BeanInfo bi = Introspector.getBeanInfo(obj.getClass());
                for (PropertyDescriptor prop : props = bi.getPropertyDescriptors()) {
                    Object current;
                    if (prop.getReadMethod() == null || prop.getWriteMethod() == null || (current = prop.getReadMethod().invoke(obj, new Object[0])) == null) continue;
                    path.push(prop.getName());
                    if (current instanceof OptionHandler) {
                        ((OptionHandler)current).getOptionManager().traverse(traverser, path, true);
                    } else {
                        this.traverse(traverser, path, current);
                    }
                    path.pop();
                }
            }
            catch (Exception e) {
                if (this.m_Quiet) break block5;
                System.err.println("Failed to traverse non-ADAMS object: path=" + path + ", class=" + obj.getClass() + ", object=" + obj + ", exeption=" + e);
            }
        }
    }

    public int size() {
        return this.m_Options.size();
    }

    @Override
    public void cleanUp() {
        for (int i = 0; i < this.m_Options.size(); ++i) {
            this.m_Options.get(i).cleanUp();
        }
        this.m_Options.clear();
        this.m_CommandlineIndex.clear();
        this.m_PropertyIndex.clear();
        this.m_Variables = null;
    }
}

