/*
 * Decompiled with CFR 0.152.
 */
package adams.data;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Random;

public abstract class AbstractAnonymizer<T>
implements Serializable {
    private static final long serialVersionUID = -7508140332366459841L;
    protected String m_ID;
    protected long m_Seed;
    protected Random m_Random;
    protected int m_BufferSize;
    protected ArrayList<Integer> m_Buffer;
    protected Hashtable<T, Integer> m_Mapping;

    protected AbstractAnonymizer() {
        this("" + Math.random(), 100);
    }

    protected AbstractAnonymizer(String id, int bufferSize) {
        this(id, (long)(Math.random() * 10000.0), bufferSize);
    }

    protected AbstractAnonymizer(String id, long seed, int bufferSize) {
        if (id == null) {
            throw new IllegalArgumentException("ID cannot be null!");
        }
        if (bufferSize < 1) {
            throw new IllegalArgumentException("Buffer size must >0, provided: " + bufferSize);
        }
        this.m_ID = id;
        this.m_Seed = seed;
        this.m_Random = new Random(seed);
        this.m_BufferSize = bufferSize;
        this.m_Mapping = new Hashtable();
        this.m_Buffer = new ArrayList();
    }

    public String getID() {
        return this.m_ID;
    }

    public long getSeed() {
        return this.m_Seed;
    }

    public int getBufferSize() {
        return this.m_BufferSize;
    }

    protected abstract T toAnonymized(Integer var1);

    protected void fillBuffer() {
        for (int i = 0; i < this.m_BufferSize; ++i) {
            this.m_Buffer.add(new Integer(this.m_Mapping.size() + i));
        }
        Collections.shuffle(this.m_Buffer, this.m_Random);
    }

    public synchronized T anonymize(T value) {
        if (value == null) {
            return null;
        }
        if (this.m_Mapping.containsKey(value)) {
            return this.toAnonymized(this.m_Mapping.get(value));
        }
        if (this.m_Buffer.size() == 0) {
            this.fillBuffer();
        }
        Integer next = this.m_Buffer.get(0);
        this.m_Buffer.remove(0);
        this.m_Mapping.put(value, next);
        return this.toAnonymized(next);
    }

    public int hashCode() {
        return this.m_ID.hashCode();
    }

    public String toString() {
        return "id=" + this.m_ID + ", seed=" + this.m_Seed + ", bufferSize=" + this.m_BufferSize + ", #mappings=" + this.m_Mapping.size();
    }
}

