/*
 * Decompiled with CFR 0.152.
 */
package adams.data;

import adams.core.base.AbstractBaseString;
import java.text.DecimalFormat;

public class DecimalFormatString
extends AbstractBaseString {
    private static final long serialVersionUID = -7134897961930112280L;
    public static final String DEFAULT = "0";

    public DecimalFormatString() {
        this(DEFAULT);
    }

    public DecimalFormatString(String s) {
        super(s);
    }

    @Override
    protected void initialize() {
        this.m_Internal = DEFAULT;
    }

    @Override
    public boolean isValid(String value) {
        if (value == null) {
            return false;
        }
        try {
            new DecimalFormat(value);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public String getTipText() {
        return "Format string for decimal numbers.";
    }

    public DecimalFormat toDecimalFormat() {
        return new DecimalFormat(this.getValue());
    }

    public String getHelpURL() {
        return "http://docs.oracle.com/javase/6/docs/api/java/text/DecimalFormat.html";
    }

    public String getHelpDescription() {
        return "Information on the decimal format string";
    }

    public String getHelpTitle() {
        return null;
    }

    public String getHelpIcon() {
        return "help2.png";
    }
}

