/*
 * Decompiled with CFR 0.152.
 */
package adams.data.conversion;

import adams.core.DateTime;
import adams.core.DateTimeType;
import adams.core.QuickInfoHelper;
import adams.core.Time;
import adams.core.base.BaseDate;
import adams.core.base.BaseDateTime;
import adams.core.base.BaseTime;
import adams.core.option.OptionHandler;
import adams.data.conversion.AbstractConversion;
import java.util.Date;
import jodd.datetime.JDateTime;

public class ConvertDateTimeType
extends AbstractConversion {
    private static final long serialVersionUID = -2353313471489671117L;
    protected DateTimeType m_InputDateTimeType;
    protected DateTimeType m_OutputDateTimeType;

    @Override
    public String globalInfo() {
        return "Turns instances of the the specified input date/time type into instances of the specified output date/time type.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("input-datetime-type", "inputDateTimeType", (Object)DateTimeType.DATE);
        this.m_OptionManager.add("output-datetime-type", "outputDateTimeType", (Object)DateTimeType.MSECS);
    }

    public void setInputDateTimeType(DateTimeType value) {
        this.m_InputDateTimeType = value;
        this.reset();
    }

    public DateTimeType getInputDateTimeType() {
        return this.m_InputDateTimeType;
    }

    public String inputDateTimeTypeTipText() {
        return "The date/time type of the input data.";
    }

    public void setOutputDateTimeType(DateTimeType value) {
        this.m_OutputDateTimeType = value;
        this.reset();
    }

    public DateTimeType getOutputDateTimeType() {
        return this.m_OutputDateTimeType;
    }

    public String outputDateTimeTypeTipText() {
        return "The date/time type of the output data.";
    }

    @Override
    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, "inputDateType", (Object)this.m_InputDateTimeType);
        result = result + " -> ";
        result = result + QuickInfoHelper.toString((OptionHandler)this, "outputDateType", (Object)this.m_OutputDateTimeType);
        return result;
    }

    @Override
    public Class accepts() {
        switch (this.m_InputDateTimeType) {
            case MSECS: {
                return Double.class;
            }
            case SECONDS: {
                return Double.class;
            }
            case DATE: {
                return Date.class;
            }
            case DATETIME: {
                return DateTime.class;
            }
            case TIME: {
                return Time.class;
            }
            case BASEDATE: {
                return BaseDate.class;
            }
            case BASEDATETIME: {
                return BaseDateTime.class;
            }
            case BASETIME: {
                return BaseTime.class;
            }
            case JULIANDATE: {
                return Double.class;
            }
        }
        throw new IllegalStateException("Unhandled input data/time type: " + (Object)((Object)this.m_InputDateTimeType));
    }

    @Override
    public Class generates() {
        switch (this.m_OutputDateTimeType) {
            case MSECS: {
                return Double.class;
            }
            case SECONDS: {
                return Double.class;
            }
            case DATE: {
                return Date.class;
            }
            case DATETIME: {
                return DateTime.class;
            }
            case TIME: {
                return Time.class;
            }
            case BASEDATE: {
                return BaseDate.class;
            }
            case BASEDATETIME: {
                return BaseDateTime.class;
            }
            case BASETIME: {
                return BaseTime.class;
            }
            case JULIANDATE: {
                return Double.class;
            }
        }
        throw new IllegalStateException("Unhandled output data/time type: " + (Object)((Object)this.m_OutputDateTimeType));
    }

    @Override
    protected Object doConvert() throws Exception {
        long msecs;
        if (this.m_InputDateTimeType == this.m_OutputDateTimeType) {
            return this.m_Input;
        }
        switch (this.m_InputDateTimeType) {
            case MSECS: {
                msecs = ((Double)this.m_Input).longValue();
                break;
            }
            case SECONDS: {
                msecs = ((Double)this.m_Input).longValue() * 1000L;
                break;
            }
            case DATE: {
                msecs = ((Date)this.m_Input).getTime();
                break;
            }
            case DATETIME: {
                msecs = ((DateTime)this.m_Input).getTime();
                break;
            }
            case TIME: {
                msecs = ((Time)this.m_Input).getTime();
                break;
            }
            case BASEDATE: {
                msecs = ((BaseDate)this.m_Input).dateValue().getTime();
                break;
            }
            case BASEDATETIME: {
                msecs = ((BaseDateTime)this.m_Input).dateValue().getTime();
                break;
            }
            case BASETIME: {
                msecs = ((BaseTime)this.m_Input).dateValue().getTime();
                break;
            }
            case JULIANDATE: {
                msecs = new JDateTime(((Double)this.m_Input).doubleValue()).convertToDate().getTime();
                break;
            }
            default: {
                throw new IllegalStateException("Unhandled input data/time type: " + (Object)((Object)this.m_InputDateTimeType));
            }
        }
        switch (this.m_OutputDateTimeType) {
            case MSECS: {
                return new Double(msecs);
            }
            case SECONDS: {
                return new Double(msecs / 1000L);
            }
            case DATE: {
                return new Date(msecs);
            }
            case DATETIME: {
                return new DateTime(msecs);
            }
            case TIME: {
                return new Time(msecs);
            }
            case BASEDATE: {
                return new BaseDate(new Date(msecs));
            }
            case BASEDATETIME: {
                return new BaseDateTime(new DateTime(msecs));
            }
            case BASETIME: {
                return new BaseTime(new Time(msecs));
            }
            case JULIANDATE: {
                return new JDateTime(new Date(msecs)).getJulianDateDouble();
            }
        }
        throw new IllegalStateException("Unhandled output data/time type: " + (Object)((Object)this.m_OutputDateTimeType));
    }
}

