/*
 * Decompiled with CFR 0.152.
 */
package adams.data.conversion;

import adams.core.DateFormat;
import adams.core.DateTime;
import adams.core.DateTimeType;
import adams.core.Time;
import adams.core.base.BaseDate;
import adams.core.base.BaseDateTime;
import adams.core.base.BaseTime;
import adams.data.DateFormatString;
import adams.data.conversion.AbstractConversionToString;
import java.util.Date;
import jodd.datetime.JDateTime;

public class DateTimeTypeToString
extends AbstractConversionToString {
    private static final long serialVersionUID = -2353313471489671117L;
    protected DateTimeType m_DateTimeType;
    protected DateFormatString m_Format;
    protected transient DateFormat m_Formatter;

    @Override
    public String globalInfo() {
        return "Turns instances of the the specified date/time type into a string using the specified format.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("datetime-type", "dateTimeType", (Object)DateTimeType.DATE);
        this.m_OptionManager.add("format", "format", new DateFormatString("yyyy-MM-dd"));
    }

    @Override
    protected void reset() {
        super.reset();
        this.m_Formatter = null;
    }

    public void setDateTimeType(DateTimeType value) {
        this.m_DateTimeType = value;
        this.reset();
    }

    public DateTimeType getDateTimeType() {
        return this.m_DateTimeType;
    }

    public String dateTimeTypeTipText() {
        return "The date/time type to convert into a string.";
    }

    public void setFormat(DateFormatString value) {
        this.m_Format = value;
        this.reset();
    }

    public DateFormatString getFormat() {
        return this.m_Format;
    }

    public String formatTipText() {
        return "The format for turning the date/time type into a string.";
    }

    @Override
    public Class accepts() {
        switch (this.m_DateTimeType) {
            case MSECS: {
                return Double.class;
            }
            case SECONDS: {
                return Double.class;
            }
            case DATE: {
                return Date.class;
            }
            case DATETIME: {
                return DateTime.class;
            }
            case TIME: {
                return Time.class;
            }
            case BASEDATE: {
                return BaseDate.class;
            }
            case BASEDATETIME: {
                return BaseDateTime.class;
            }
            case BASETIME: {
                return BaseTime.class;
            }
            case JULIANDATE: {
                return Double.class;
            }
        }
        throw new IllegalStateException("Unhandled data/time type: " + (Object)((Object)this.m_DateTimeType));
    }

    @Override
    protected Object doConvert() throws Exception {
        if (this.m_Formatter == null) {
            this.m_Formatter = this.m_Format.toDateFormat();
        }
        switch (this.m_DateTimeType) {
            case MSECS: {
                return this.m_Formatter.format(new Date(((Double)this.m_Input).longValue()));
            }
            case SECONDS: {
                return this.m_Formatter.format(new Date(((Double)this.m_Input).longValue() * 1000L));
            }
            case DATE: {
                return this.m_Formatter.format((Date)this.m_Input);
            }
            case DATETIME: {
                return this.m_Formatter.format((DateTime)this.m_Input);
            }
            case TIME: {
                return this.m_Formatter.format((Time)this.m_Input);
            }
            case BASEDATE: {
                return this.m_Formatter.format(((BaseDate)this.m_Input).dateValue());
            }
            case BASEDATETIME: {
                return this.m_Formatter.format(((BaseDateTime)this.m_Input).dateValue());
            }
            case BASETIME: {
                return this.m_Formatter.format(((BaseTime)this.m_Input).dateValue());
            }
            case JULIANDATE: {
                return this.m_Formatter.format(new JDateTime(((Double)this.m_Input).doubleValue()).convertToDate());
            }
        }
        throw new IllegalStateException("Unhandled data/time type: " + (Object)((Object)this.m_DateTimeType));
    }
}

