/*
 * Decompiled with CFR 0.152.
 */
package adams.data.conversion;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.core.scripting.AbstractScriptingHandler;
import adams.core.scripting.Dummy;
import adams.data.conversion.AbstractConversion;
import adams.data.conversion.AbstractScriptedConversion;

public class Scripted
extends AbstractScriptedConversion {
    private static final long serialVersionUID = 1304903578667689350L;
    protected transient AbstractConversion m_ConversionObject;
    protected AbstractScriptingHandler m_Handler;

    @Override
    public String globalInfo() {
        return "A conversion that uses any scripting handler for processing the data with a script located in the specified file.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("handler", "handler", new Dummy());
    }

    @Override
    public String getQuickInfo() {
        String result = super.getQuickInfo();
        result = result + QuickInfoHelper.toString((OptionHandler)this, "handler", this.m_Handler.getClass(), ", handler: ");
        return result;
    }

    @Override
    public String scriptOptionsTipText() {
        return "The options for the script; must consist of 'key=value' pairs separated by blanks; the value of 'key' can be accessed via the 'getAdditionalOptions().getXYZ(\"key\")' method in the script actor.";
    }

    public void setHandler(AbstractScriptingHandler value) {
        this.m_Handler = value;
        this.reset();
    }

    public AbstractScriptingHandler getHandler() {
        return this.m_Handler;
    }

    public String handlerTipText() {
        return "The handler to use for scripting.";
    }

    @Override
    public Class accepts() {
        if (this.m_ConversionObject != null) {
            return this.m_ConversionObject.accepts();
        }
        return Object.class;
    }

    @Override
    public Class generates() {
        if (this.m_ConversionObject != null) {
            return this.m_ConversionObject.generates();
        }
        return Object.class;
    }

    @Override
    protected String loadScriptObject() {
        Object[] result = this.m_Handler.loadScriptObject(AbstractConversion.class, this.m_ScriptFile, this.m_ScriptOptions, this.getOptionManager().getVariables());
        this.m_ScriptObject = result[1];
        return (String)result[0];
    }

    @Override
    protected String checkScriptObject() {
        return null;
    }

    @Override
    public String setUp() {
        String result = super.setUp();
        if (result == null) {
            this.m_ConversionObject = (AbstractConversion)this.m_ScriptObject;
        }
        return result;
    }

    @Override
    protected Object doConvert() throws Exception {
        this.m_ConversionObject.setInput(this.m_Input);
        String msg = this.m_ConversionObject.convert();
        if (msg != null) {
            throw new IllegalStateException(msg);
        }
        return this.m_ConversionObject.getOutput();
    }

    @Override
    public void destroy() {
        super.destroy();
        this.m_ConversionObject = null;
    }
}

