/*
 * Decompiled with CFR 0.152.
 */
package adams.data.distribution;

import adams.data.distribution.AbstractRealDistribution;
import org.apache.commons.math3.distribution.RealDistribution;
import org.apache.commons.math3.distribution.TriangularDistribution;

public class Triangular
extends AbstractRealDistribution {
    private static final long serialVersionUID = -1708992443868275973L;
    protected double m_A;
    protected double m_C;
    protected double m_B;

    @Override
    public String globalInfo() {
        return "The Triangular distribution.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("a", "a", 0.0);
        this.m_OptionManager.add("c", "c", 0.0);
        this.m_OptionManager.add("b", "b", 0.0);
    }

    public void setA(double value) {
        this.m_A = value;
        this.reset();
    }

    public double getA() {
        return this.m_A;
    }

    public String aTipText() {
        return "The a parameter.";
    }

    public void setC(double value) {
        this.m_C = value;
        this.reset();
    }

    public double getC() {
        return this.m_C;
    }

    public String cTipText() {
        return "The c parameter.";
    }

    public void setB(double value) {
        this.m_B = value;
        this.reset();
    }

    public double getB() {
        return this.m_B;
    }

    public String bTipText() {
        return "The b parameter.";
    }

    @Override
    public RealDistribution getRealDistribution() {
        return new TriangularDistribution(this.m_A, this.m_C, this.m_B);
    }
}

