/*
 * Decompiled with CFR 0.152.
 */
package adams.data.distribution;

import adams.data.distribution.AbstractRealDistribution;
import org.apache.commons.math3.distribution.RealDistribution;
import org.apache.commons.math3.distribution.WeibullDistribution;

public class Weibull
extends AbstractRealDistribution {
    private static final long serialVersionUID = -1708992443868275973L;
    protected double m_Alpha;
    protected double m_Beta;
    protected double m_InverseCumAccuracy;

    @Override
    public String globalInfo() {
        return "The Weibull distribution.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("alpha", "alpha", 0.0);
        this.m_OptionManager.add("beta", "beta", 0.0);
        this.m_OptionManager.add("inverse-cum-accuracy", "inverseCumAccuracy", 1.0E-9);
    }

    public void setAlpha(double value) {
        this.m_Alpha = value;
        this.reset();
    }

    public double getAlpha() {
        return this.m_Alpha;
    }

    public String alphaTipText() {
        return "The alpha parameter.";
    }

    public void setBeta(double value) {
        this.m_Beta = value;
        this.reset();
    }

    public double getBeta() {
        return this.m_Beta;
    }

    public String betaTipText() {
        return "The beta parameter.";
    }

    public void setInverseCumAccuracy(double value) {
        this.m_InverseCumAccuracy = value;
        this.reset();
    }

    public double getInverseCumAccuracy() {
        return this.m_InverseCumAccuracy;
    }

    public String inverseCumAccuracyTipText() {
        return "The inverse cumulative accuracy.";
    }

    @Override
    public RealDistribution getRealDistribution() {
        return new WeibullDistribution(this.m_Alpha, this.m_Beta, this.m_InverseCumAccuracy);
    }
}

