/*
 * Decompiled with CFR 0.152.
 */
package adams.data.featureconverter;

import adams.core.QuickInfoSupporter;
import adams.core.option.AbstractOptionHandler;
import adams.data.featureconverter.HeaderDefinition;
import java.util.List;

public abstract class AbstractFeatureConverter<D, R>
extends AbstractOptionHandler
implements QuickInfoSupporter {
    private static final long serialVersionUID = 4745159188031576718L;
    protected D m_Header;
    protected HeaderDefinition m_HeaderDefinition;
    protected String m_Dataset;

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("dataset", "dataset", "Dataset");
    }

    @Override
    public void reset() {
        super.reset();
        this.m_Header = null;
        this.m_HeaderDefinition = null;
    }

    public void setDataset(String value) {
        this.m_Dataset = value;
        this.reset();
    }

    public String getDataset() {
        return this.m_Dataset;
    }

    public String datasetTipText() {
        return "The dataset name to use.";
    }

    @Override
    public String getQuickInfo() {
        return null;
    }

    public boolean isInitialized() {
        return this.m_Header != null;
    }

    public D getHeader() {
        return this.m_Header;
    }

    public HeaderDefinition getHeaderDefinition() {
        return this.m_HeaderDefinition;
    }

    public abstract Class getDatasetFormat();

    public abstract Class getRowFormat();

    protected abstract D doGenerateHeader(HeaderDefinition var1);

    public D generateHeader(HeaderDefinition header) {
        this.m_Header = this.doGenerateHeader(header);
        this.m_HeaderDefinition = header;
        return this.m_Header;
    }

    protected abstract R doGenerateRow(List<Object> var1);

    public R generateRow(List<Object> data) {
        if (this.m_Header == null) {
            throw new IllegalStateException("No header available! generatedHeader called?");
        }
        if (this.m_HeaderDefinition.size() != data.size()) {
            throw new IllegalStateException("Header and data differ in size: " + this.m_HeaderDefinition.size() + " != " + data.size());
        }
        return this.doGenerateRow(data);
    }
}

