/*
 * Decompiled with CFR 0.152.
 */
package adams.data.filter;

import adams.core.TechnicalInformation;
import adams.core.TechnicalInformationHandler;
import adams.data.container.DataContainer;
import adams.data.container.DataPoint;
import adams.data.filter.AbstractFilter;
import adams.data.utils.SAXUtils;
import java.util.List;

public abstract class AbstractSAX<T extends DataContainer>
extends AbstractFilter<T>
implements TechnicalInformationHandler {
    private static final long serialVersionUID = 1836858988505886282L;
    protected int m_NumWindows;
    protected int m_NumBins;
    protected boolean m_OutputLabels;
    protected double[] m_BreakPoints;
    protected double[][] m_DistMatrix;

    @Override
    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation result = new TechnicalInformation(TechnicalInformation.Type.PROCEEDINGS);
        result.setValue(TechnicalInformation.Field.AUTHOR, "Chiu, B. and Keogh, E. and Lonardi, S.");
        result.setValue(TechnicalInformation.Field.TITLE, "Probabilistic Discovery of Time Series Motifs");
        result.setValue(TechnicalInformation.Field.BOOKTITLE, "9th ACM SIGKDD International Conference on Knowledge Discovery and Data Mining");
        result.setValue(TechnicalInformation.Field.PAGES, "493-498");
        result.setValue(TechnicalInformation.Field.YEAR, "2003");
        result.setValue(TechnicalInformation.Field.LOCATION, "Washington, DC, USA");
        result.setValue(TechnicalInformation.Field.PDF, "http://www.cs.ucr.edu/~eamonn/SIGKDD_Motif.pdf");
        return result;
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("num-windows", "numWindows", 10, 1, null);
        this.m_OptionManager.add("num-bins", "numBins", 10, 1, null);
        this.m_OptionManager.add("output-labels", "outputLabels", true);
    }

    @Override
    public void reset() {
        super.reset();
        this.m_BreakPoints = null;
        this.m_DistMatrix = null;
    }

    public void setNumWindows(int value) {
        if (value >= 1) {
            this.m_NumWindows = value;
            this.reset();
        } else {
            this.getLogger().severe("The number of windows must be at least 1, provided: " + value);
        }
    }

    public int getNumWindows() {
        return this.m_NumWindows;
    }

    public String numWindowsTipText() {
        return "The number of windows to use for Piecewise Aggregate Approximation (PAA).";
    }

    public void setNumBins(int value) {
        if (value >= 1) {
            this.m_NumBins = value;
            this.reset();
        } else {
            this.getLogger().severe("The number of bins must be at least 1, provided: " + value);
        }
    }

    public int getNumBins() {
        return this.m_NumBins;
    }

    public String numBinsTipText() {
        return "The number of bins to use for the Gaussian.";
    }

    public void setOutputLabels(boolean value) {
        this.m_OutputLabels = value;
        this.reset();
    }

    public boolean getOutputLabels() {
        return this.m_OutputLabels;
    }

    public String outputLabelsTipText() {
        return "If enabled, labels are output instead of distances.";
    }

    protected abstract double getMeanDeltaX(T var1);

    protected abstract double getX(DataPoint var1);

    protected abstract double getY(DataPoint var1);

    protected abstract DataPoint newDataPoint(double var1, double var3);

    @Override
    protected T processData(T data) {
        int i;
        DataContainer result = data.getHeader();
        if (data.size() == 0) {
            return (T)result;
        }
        List points = data.toList();
        double meanDelta = this.getMeanDeltaX(data);
        if (this.m_BreakPoints == null) {
            this.m_BreakPoints = SAXUtils.calcBreakPoints(this.m_NumBins);
        }
        if (!this.m_OutputLabels && this.m_DistMatrix == null) {
            this.m_DistMatrix = SAXUtils.calcDistMatrix(this.m_BreakPoints);
        }
        double[] values = new double[points.size()];
        for (i = 0; i < points.size(); ++i) {
            values[i] = this.getY((DataPoint)points.get(i));
        }
        double[] sax = SAXUtils.toSAX(values, this.m_NumWindows, this.m_BreakPoints);
        for (i = 0; i < sax.length; ++i) {
            DataPoint point = this.m_OutputLabels ? this.newDataPoint(this.getX((DataPoint)points.get(0)) + (double)i * meanDelta, sax[i]) : this.newDataPoint(this.getX((DataPoint)points.get(0)) + (double)i * meanDelta, SAXUtils.minDist(new double[]{sax[i]}, new double[]{0.0}, this.m_DistMatrix, 1));
            result.add(point);
        }
        return (T)result;
    }
}

