/*
 * Decompiled with CFR 0.152.
 */
package adams.data.io.output;

import adams.core.ClassLister;
import adams.core.base.BaseCharset;
import adams.core.io.FileEncodingSupporter;
import adams.core.option.AbstractOptionHandler;
import adams.data.io.output.AppendableSpreadSheetWriter;
import adams.data.io.output.SpreadSheetWriter;
import adams.data.spreadsheet.SpreadSheet;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.io.output.WriterOutputStream;
import org.codehaus.plexus.util.FileUtils;

public abstract class AbstractSpreadSheetWriter
extends AbstractOptionHandler
implements SpreadSheetWriter,
FileEncodingSupporter {
    private static final long serialVersionUID = -3547064795252689769L;
    protected BaseCharset m_Encoding;

    @Override
    protected void initialize() {
        super.initialize();
        this.m_Encoding = new BaseCharset();
    }

    @Override
    public void reset() {
        super.reset();
    }

    @Override
    public abstract String getFormatDescription();

    @Override
    public abstract String[] getFormatExtensions();

    public String getDefaultFormatExtension() {
        return this.getFormatExtensions()[0];
    }

    @Override
    public void setEncoding(BaseCharset value) {
        this.m_Encoding = value;
        this.reset();
    }

    @Override
    public BaseCharset getEncoding() {
        return this.m_Encoding;
    }

    @Override
    public String encodingTipText() {
        return "The type of encoding to use when writing using a writer, use empty string for default.";
    }

    protected abstract OutputType getOutputType();

    protected boolean supportsCompressedOutput() {
        return false;
    }

    protected boolean canCompress(String filename) {
        return this.supportsCompressedOutput() && filename.toLowerCase().endsWith(".gz");
    }

    @Override
    public boolean write(SpreadSheet content, File file) {
        return this.write(content, file.getAbsolutePath());
    }

    @Override
    public boolean write(SpreadSheet content, String filename) {
        boolean result = true;
        boolean append = false;
        if (this instanceof AppendableSpreadSheetWriter) {
            AppendableSpreadSheetWriter appendable = (AppendableSpreadSheetWriter)((Object)this);
            appendable.setFileExists(FileUtils.fileExists((String)filename));
            append = appendable.canAppend(content);
        }
        try {
            switch (this.getOutputType()) {
                case FILE: {
                    result = this.doWrite(content, filename);
                    break;
                }
                case STREAM: {
                    OutputStream output = new FileOutputStream(filename, append);
                    if (!append && this.canCompress(filename)) {
                        output = new GZIPOutputStream(output);
                    }
                    result = this.doWrite(content, output);
                    output.flush();
                    ((OutputStream)output).close();
                    break;
                }
                case WRITER: {
                    OutputStream output = new FileOutputStream(filename, append);
                    if (!append && this.canCompress(filename)) {
                        output = new GZIPOutputStream(output);
                    }
                    BufferedWriter writer = this.m_Encoding != null ? new BufferedWriter(new OutputStreamWriter(output, this.m_Encoding.charsetValue())) : new BufferedWriter(new OutputStreamWriter(output));
                    result = this.doWrite(content, writer);
                    writer.flush();
                    writer.close();
                    break;
                }
                default: {
                    throw new IllegalStateException("Unhandled output type: " + (Object)((Object)this.getOutputType()));
                }
            }
        }
        catch (Exception e) {
            result = false;
            e.printStackTrace();
        }
        return result;
    }

    @Override
    public boolean write(SpreadSheet content, OutputStream stream) {
        switch (this.getOutputType()) {
            case FILE: {
                throw new IllegalStateException("Only supports writing to files, not output streams!");
            }
            case STREAM: {
                return this.doWrite(content, stream);
            }
            case WRITER: {
                return this.doWrite(content, new OutputStreamWriter(stream));
            }
        }
        throw new IllegalStateException("Unhandled output type: " + (Object)((Object)this.getOutputType()));
    }

    @Override
    public boolean write(SpreadSheet content, Writer writer) {
        switch (this.getOutputType()) {
            case FILE: {
                throw new IllegalStateException("Only supports writing to files, not output streams!");
            }
            case STREAM: {
                return this.doWrite(content, (OutputStream)new WriterOutputStream(writer));
            }
            case WRITER: {
                return this.doWrite(content, writer);
            }
        }
        throw new IllegalStateException("Unhandled output type: " + (Object)((Object)this.getOutputType()));
    }

    protected boolean doWrite(SpreadSheet content, String filename) {
        return false;
    }

    protected boolean doWrite(SpreadSheet content, Writer writer) {
        return false;
    }

    protected boolean doWrite(SpreadSheet content, OutputStream out) {
        return false;
    }

    public static String[] getWriters() {
        return ClassLister.getSingleton().getClassnames(SpreadSheetWriter.class);
    }

    public static enum OutputType {
        FILE,
        WRITER,
        STREAM;

    }
}

