/*
 * Decompiled with CFR 0.152.
 */
package adams.data.io.output;

import adams.core.DateFormat;
import adams.core.Utils;
import adams.core.base.BaseCharset;
import adams.data.DateFormatString;
import adams.data.io.input.CsvSpreadSheetReader;
import adams.data.io.input.SpreadSheetReader;
import adams.data.io.output.AbstractFormattedSpreadSheetWriter;
import adams.data.io.output.AbstractSpreadSheetWriter;
import adams.data.io.output.AppendableSpreadSheetWriter;
import adams.data.io.output.IncrementalSpreadSheetWriter;
import adams.data.io.output.SpreadSheetWriterWithFormulaSupport;
import adams.data.spreadsheet.Cell;
import adams.data.spreadsheet.DataRow;
import adams.data.spreadsheet.Row;
import adams.data.spreadsheet.SpreadSheet;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Iterator;
import java.util.logging.Level;

public class CsvSpreadSheetWriter
extends AbstractFormattedSpreadSheetWriter
implements AppendableSpreadSheetWriter,
SpreadSheetWriterWithFormulaSupport,
IncrementalSpreadSheetWriter {
    private static final long serialVersionUID = -3549185519778801930L;
    public static final char[] BACKQUOTE_CHARS = new char[]{'\t'};
    public static final String[] BACKQUOTED_STRINGS = new String[]{"\\t"};
    public static final char[] ESCAPE_CHARS = new char[]{'\\', '\'', '\t', '\n', '\r', '\"'};
    public static final String[] ESCAPE_STRINGS = new String[]{"\\\\", "\\'", "\\t", "\\n", "\\r", "\\\""};
    protected String m_Comment;
    protected boolean m_OutputComments;
    protected boolean m_Appending;
    protected SpreadSheet m_Header;
    protected boolean m_KeepExisting;
    protected boolean m_FileExists;
    protected boolean m_OutputAsDisplayed;
    protected String m_QuoteCharacter;
    protected String m_Separator;
    protected String m_NewLine;
    protected boolean m_AlwaysQuoteText;
    protected boolean m_EscapeSpecialChars;
    protected DateFormatString m_DateFormat;
    protected DateFormatString m_DateTimeFormat;
    protected DateFormatString m_TimeFormat;
    protected transient DateFormat m_DateFormatter;
    protected transient DateFormat m_DateTimeFormatter;
    protected transient DateFormat m_TimeFormatter;

    @Override
    public String globalInfo() {
        return "Writes CSV files.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("enncoding", "encoding", new BaseCharset());
        this.m_OptionManager.add("comment", "comment", "#");
        this.m_OptionManager.add("output-comments", "outputComments", true);
        this.m_OptionManager.add("output-as-displayed", "outputAsDisplayed", false);
        this.m_OptionManager.add("appending", "appending", false);
        this.m_OptionManager.add("keep-existing", "keepExisting", false);
        this.m_OptionManager.add("quote-char", "quoteCharacter", "\"");
        this.m_OptionManager.add("separator", "separator", ",");
        this.m_OptionManager.add("new-line", "newLine", Utils.backQuoteChars(System.getProperty("line.separator")));
        this.m_OptionManager.add("always-quote-text", "alwaysQuoteText", false);
        this.m_OptionManager.add("escape-special-chars", "escapeSpecialChars", false);
        this.m_OptionManager.add("date-format", "dateFormat", new DateFormatString("yyyy-MM-dd"));
        this.m_OptionManager.add("datetime-format", "dateTimeFormat", new DateFormatString("yyyy-MM-dd HH:mm:ss"));
        this.m_OptionManager.add("time-format", "timeFormat", new DateFormatString("HH:mm:ss"));
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.m_Header = null;
        this.m_FileExists = false;
    }

    @Override
    public void reset() {
        super.reset();
        this.m_Header = null;
        this.m_FileExists = false;
    }

    public void setComment(String value) {
        this.m_Comment = value;
        this.reset();
    }

    public String getComment() {
        return this.m_Comment;
    }

    public String commentTipText() {
        return "The string denoting the start of a line comment (comments can only precede header row).";
    }

    public void setOutputComments(boolean value) {
        this.m_OutputComments = value;
        this.reset();
    }

    public boolean getOutputComments() {
        return this.m_OutputComments;
    }

    public String outputCommentsTipText() {
        return "If enabled, any available comments are output before the actual data (using the 'comment' prefix).";
    }

    @Override
    public void setOutputAsDisplayed(boolean value) {
        this.m_OutputAsDisplayed = value;
        this.reset();
    }

    @Override
    public boolean getOutputAsDisplayed() {
        return this.m_OutputAsDisplayed;
    }

    @Override
    public String outputAsDisplayedTipText() {
        return "If enabled, cells are output as displayed, ie, results of formulas instead of the formulas.";
    }

    @Override
    public boolean canAppend(SpreadSheet sheet) {
        if (this.m_Header == null) {
            return this.m_KeepExisting;
        }
        return this.m_Header.equalsHeader(sheet) == null;
    }

    @Override
    public void setAppending(boolean value) {
        this.m_Appending = value;
        this.reset();
    }

    @Override
    public boolean isAppending() {
        return this.m_Appending;
    }

    @Override
    public String appendingTipText() {
        return "If enabled, multiple spreadsheets with the same structure can be written to the same file.";
    }

    @Override
    public void setKeepExisting(boolean value) {
        this.m_KeepExisting = value;
        this.reset();
    }

    @Override
    public boolean getKeepExisting() {
        return this.m_KeepExisting;
    }

    @Override
    public String keepExistingTipText() {
        return "If enabled, any output file that exists when the writer is executed for the first time won't get replaced with the current header; useful when outputting data in multiple locations in the flow, but one needs to be cautious as to not stored mixed content (eg varying number of columns, etc).";
    }

    public void setQuoteCharacter(String value) {
        if (value.length() == 1) {
            this.m_QuoteCharacter = value;
            this.reset();
        } else {
            this.getLogger().severe("Only one character allowed for quote character, provided: " + value);
        }
    }

    public String getQuoteCharacter() {
        return this.m_QuoteCharacter;
    }

    public String quoteCharacterTipText() {
        return "The character to use for surrounding text cells.";
    }

    public void setSeparator(String value) {
        if (Utils.unbackQuoteChars(value).length() == 1) {
            this.m_Separator = Utils.unbackQuoteChars(value);
            this.reset();
        } else {
            this.getLogger().severe("Only one character allowed (or two, in case of backquoted ones) for separator, provided: " + value);
        }
    }

    public String getSeparator() {
        return Utils.backQuoteChars(this.m_Separator);
    }

    public String separatorTipText() {
        return "The separator to use for the columns; use '\\t' for tab.";
    }

    public void setNewLine(String value) {
        this.m_NewLine = Utils.unbackQuoteChars(value);
        this.reset();
    }

    public String getNewLine() {
        return Utils.backQuoteChars(this.m_NewLine);
    }

    public String newLineTipText() {
        return "The newline character(s) to use for the columns; use '\\r' for carriage return and '\\n' for line feed; Linux/Unix use '\\n', Windows uses '\\r\\n' and old Macs use '\\r'.";
    }

    public void setAlwaysQuoteText(boolean value) {
        this.m_AlwaysQuoteText = value;
        this.reset();
    }

    public boolean getAlwaysQuoteText() {
        return this.m_AlwaysQuoteText;
    }

    public String alwaysQuoteTextTipText() {
        return "If enabled, text/formula cells always get surrounded by double quotes.";
    }

    public void setEscapeSpecialChars(boolean value) {
        this.m_EscapeSpecialChars = value;
        this.reset();
    }

    public boolean getEscapeSpecialChars() {
        return this.m_EscapeSpecialChars;
    }

    public String escapeSpecialCharsTipText() {
        return "If enabled, special characters get escaped with a backslash: " + Utils.flatten(ESCAPE_STRINGS, ", ");
    }

    public void setDateFormat(DateFormatString value) {
        this.m_DateFormat = value;
        this.reset();
    }

    public DateFormatString getDateFormat() {
        return this.m_DateFormat;
    }

    public String dateFormatTipText() {
        return "The format for dates.";
    }

    public void setDateTimeFormat(DateFormatString value) {
        this.m_DateTimeFormat = value;
        this.reset();
    }

    public DateFormatString getDateTimeFormat() {
        return this.m_DateTimeFormat;
    }

    public String dateTimeFormatTipText() {
        return "The format for date/times.";
    }

    public void setTimeFormat(DateFormatString value) {
        this.m_TimeFormat = value;
        this.reset();
    }

    public DateFormatString getTimeFormat() {
        return this.m_TimeFormat;
    }

    public String timeFormatTipText() {
        return "The format for times.";
    }

    @Override
    public void setFileExists(boolean value) {
        this.m_FileExists = value;
    }

    @Override
    public boolean getFileExists() {
        return this.m_FileExists;
    }

    @Override
    public String getFormatDescription() {
        return "Comma-separated values files";
    }

    @Override
    public String[] getFormatExtensions() {
        return new String[]{"csv", "csv.gz"};
    }

    @Override
    public SpreadSheetReader getCorrespondingReader() {
        return new CsvSpreadSheetReader();
    }

    @Override
    protected AbstractSpreadSheetWriter.OutputType getOutputType() {
        return AbstractSpreadSheetWriter.OutputType.WRITER;
    }

    @Override
    protected boolean supportsCompressedOutput() {
        return !this.isAppending();
    }

    protected DateFormat getDateFormatter() {
        if (this.m_DateFormatter == null) {
            this.m_DateFormatter = this.m_DateFormat.toDateFormat();
        }
        return this.m_DateFormatter;
    }

    protected DateFormat getDateTimeFormatter() {
        if (this.m_DateTimeFormatter == null) {
            this.m_DateTimeFormatter = this.m_DateTimeFormat.toDateFormat();
        }
        return this.m_DateTimeFormatter;
    }

    protected DateFormat getTimeFormatter() {
        if (this.m_TimeFormatter == null) {
            this.m_TimeFormatter = this.m_TimeFormat.toDateFormat();
        }
        return this.m_TimeFormatter;
    }

    protected String quoteString(String s) {
        boolean required;
        boolean bl = required = this.m_AlwaysQuoteText || s.contains(this.m_Separator) || s.contains(" ") || s.contains(this.m_QuoteCharacter) || s.contains("\n") || s.contains("\t") || s.length() == 0;
        String result = this.m_EscapeSpecialChars ? this.m_QuoteCharacter + Utils.backQuoteChars(s, ESCAPE_CHARS, ESCAPE_STRINGS) + this.m_QuoteCharacter : (required ? Utils.doubleUpQuotes(s, this.m_QuoteCharacter.charAt(0), BACKQUOTE_CHARS, BACKQUOTED_STRINGS) : s);
        return result;
    }

    protected String quoteNumber(String s) {
        boolean required = s.contains(this.m_Separator) || s.length() == 0;
        String result = required ? Utils.doubleUpQuotes(s, this.m_QuoteCharacter.charAt(0), BACKQUOTE_CHARS, BACKQUOTED_STRINGS) : s;
        return result;
    }

    protected boolean doWriteHeader(Row header, Writer writer) {
        boolean result = true;
        try {
            if (this.m_OutputComments) {
                for (int i = 0; i < header.getOwner().getComments().size(); ++i) {
                    writer.write(this.m_Comment + " " + header.getOwner().getComments().get(i) + this.m_NewLine);
                }
            }
            boolean first = true;
            for (String key : header.cellKeys()) {
                Cell cell = header.getCell(key);
                if (!first) {
                    writer.write(this.m_Separator);
                }
                if (cell.isMissing()) {
                    writer.write(this.quoteString(this.m_MissingValue));
                } else {
                    writer.write(this.quoteString(cell.getContent()));
                }
                first = false;
            }
            writer.write(this.m_NewLine);
        }
        catch (Exception e) {
            result = false;
            this.getLogger().log(Level.SEVERE, "Failed writing spreadsheet header", e);
        }
        return result;
    }

    protected boolean writeHeader(Row header, Writer writer) {
        boolean result = true;
        if (!(this.m_Header != null || this.m_FileExists && this.m_KeepExisting)) {
            result = this.doWriteHeader(header, writer);
            if (this.m_Appending) {
                this.m_Header = header.getOwner().getHeader();
            }
        }
        return result;
    }

    protected boolean doWrite(Row content, Writer writer) {
        boolean result = true;
        try {
            DateFormat dformat = this.getDateFormatter();
            DateFormat dtformat = this.getDateTimeFormatter();
            DateFormat tformat = this.getTimeFormatter();
            boolean first = true;
            for (String keyd : content.getOwner().getHeaderRow().cellKeys()) {
                Cell cell = content.getCell(keyd);
                if (!first) {
                    writer.write(this.m_Separator);
                }
                if (cell != null && cell.getContent() != null && !cell.isMissing()) {
                    if (cell.isFormula() && !this.m_OutputAsDisplayed) {
                        writer.write(this.quoteString(cell.getFormula()));
                    } else {
                        switch (cell.getContentType()) {
                            case STRING: {
                                writer.write(this.quoteString(cell.getContent()));
                                break;
                            }
                            case LONG: {
                                writer.write(this.quoteNumber(cell.toLong().toString()));
                                break;
                            }
                            case DOUBLE: {
                                writer.write(this.quoteNumber(this.format(cell.toDouble())));
                                break;
                            }
                            case DATE: {
                                writer.write(this.quoteString(dformat.format(cell.toDate())));
                                break;
                            }
                            case DATETIME: {
                                writer.write(this.quoteString(dtformat.format(cell.toDateTime())));
                                break;
                            }
                            case TIME: {
                                writer.write(this.quoteString(tformat.format(cell.toTime())));
                                break;
                            }
                            case BOOLEAN: {
                                writer.write(this.quoteString(cell.toBoolean().toString()));
                                break;
                            }
                            default: {
                                writer.write(this.quoteString(cell.toString()));
                                break;
                            }
                        }
                    }
                } else {
                    writer.write(this.quoteString(this.m_MissingValue));
                }
                first = false;
            }
            writer.write(this.m_NewLine);
        }
        catch (Exception e) {
            result = false;
            this.getLogger().log(Level.SEVERE, "Failed writing spreadsheet data", e);
        }
        return result;
    }

    @Override
    protected boolean doWrite(SpreadSheet content, Writer writer) {
        DataRow row;
        this.m_Appending = true;
        boolean result = this.writeHeader(content.getHeaderRow(), writer);
        Iterator<DataRow> iterator = content.rows().iterator();
        while (iterator.hasNext() && (result = this.doWrite(row = iterator.next(), writer))) {
        }
        return result;
    }

    @Override
    public boolean isIncremental() {
        return true;
    }

    @Override
    public boolean write(Row content, File file) {
        this.m_Appending = true;
        return this.write(content, file.getAbsolutePath());
    }

    @Override
    public boolean write(Row content, String filename) {
        boolean result = true;
        this.m_Appending = true;
        try {
            FileOutputStream output = new FileOutputStream(filename, this.m_Header != null);
            BufferedWriter writer = this.m_Encoding != null ? new BufferedWriter(new OutputStreamWriter((OutputStream)output, this.m_Encoding.charsetValue())) : new BufferedWriter(new OutputStreamWriter(output));
            result = this.write(content, (Writer)writer);
            writer.flush();
            writer.close();
        }
        catch (Exception e) {
            result = false;
            e.printStackTrace();
        }
        return result;
    }

    @Override
    public boolean write(Row content, OutputStream stream) {
        this.m_Appending = true;
        return this.write(content, (Writer)new OutputStreamWriter(stream));
    }

    @Override
    public boolean write(Row content, Writer writer) {
        this.m_Appending = true;
        boolean result = this.writeHeader(content.getOwner().getHeaderRow(), writer);
        if (result) {
            result = this.doWrite(content, writer);
        }
        return result;
    }
}

