/*
 * Decompiled with CFR 0.152.
 */
package adams.data.outlier;

import adams.core.scripting.AbstractScriptingHandler;
import adams.core.scripting.Dummy;
import adams.data.container.DataContainer;
import adams.data.outlier.AbstractOutlierDetector;
import adams.data.outlier.AbstractScriptedOutlierDetector;
import java.util.List;

public class Scripted
extends AbstractScriptedOutlierDetector {
    private static final long serialVersionUID = 1304903578667689350L;
    protected transient AbstractOutlierDetector m_OutlierDetectorObject;
    protected AbstractScriptingHandler m_Handler;

    @Override
    public String globalInfo() {
        return "An outlier detector that uses any scripting handler for processing the data with a script located in the specified file.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("handler", "handler", new Dummy());
    }

    @Override
    public String scriptOptionsTipText() {
        return "The options for the script; must consist of 'key=value' pairs separated by blanks; the value of 'key' can be accessed via the 'getAdditionalOptions().getXYZ(\"key\")' method in the script actor.";
    }

    public void setHandler(AbstractScriptingHandler value) {
        this.m_Handler = value;
        this.reset();
    }

    public AbstractScriptingHandler getHandler() {
        return this.m_Handler;
    }

    public String handlerTipText() {
        return "The handler to use for scripting.";
    }

    @Override
    protected String loadScriptObject() {
        Object[] result = this.m_Handler.loadScriptObject(AbstractOutlierDetector.class, this.m_ScriptFile, this.m_ScriptOptions, this.getOptionManager().getVariables());
        this.m_ScriptObject = result[1];
        return (String)result[0];
    }

    @Override
    protected String checkScriptObject() {
        return null;
    }

    @Override
    protected void checkData(DataContainer data) {
        super.checkData(data);
        this.m_OutlierDetectorObject = (AbstractOutlierDetector)this.m_ScriptObject;
    }

    protected List<String> processData(DataContainer data) {
        return this.m_OutlierDetectorObject.detect(data);
    }

    @Override
    public void destroy() {
        super.destroy();
        this.m_OutlierDetectorObject = null;
    }
}

