/*
 * Decompiled with CFR 0.152.
 */
package adams.data.outlier;

import adams.core.base.BaseRegExp;
import adams.data.container.DataContainer;
import adams.data.outlier.AbstractOutlierDetector;
import adams.data.report.DataType;
import adams.data.report.Field;
import adams.data.report.Report;
import adams.data.report.ReportHandler;
import java.util.ArrayList;
import java.util.List;

public class StringMatcher
extends AbstractOutlierDetector {
    private static final long serialVersionUID = -4774492907534443823L;
    protected Field m_Field;
    protected BaseRegExp m_RegExp;
    protected boolean m_Invert;

    @Override
    public String globalInfo() {
        return "Checks whether the specified string field is available in the report and the value matches the specified regular expression.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("field", "field", new Field("blah", DataType.UNKNOWN));
        this.m_OptionManager.add("regexp", "regExp", new BaseRegExp(".*"));
        this.m_OptionManager.add("invert", "invert", false);
    }

    public void setField(Field value) {
        this.m_Field = value;
        this.reset();
    }

    public Field getField() {
        return this.m_Field;
    }

    public String fieldTipText() {
        return "The field to use (ie, the class).";
    }

    public void setRegExp(BaseRegExp value) {
        this.m_RegExp = value;
        this.reset();
    }

    public BaseRegExp getRegExp() {
        return this.m_RegExp;
    }

    public String regExpTipText() {
        return "The regular expression used for matching the strings.";
    }

    public void setInvert(boolean value) {
        this.m_Invert = value;
        this.reset();
    }

    public boolean getInvert() {
        return this.m_Invert;
    }

    public String invertTipText() {
        return "If set to true, then the matching sense is inverted.";
    }

    protected List<String> processData(DataContainer data) {
        ArrayList<String> result = new ArrayList<String>();
        if (data instanceof ReportHandler) {
            ReportHandler handler = (ReportHandler)((Object)data);
            if (handler.getReport() != null) {
                Object report = handler.getReport();
                if (!((Report)report).hasValue(this.m_Field)) {
                    result.add("Field '" + this.m_Field + "' not in report!");
                } else if (!(((Report)report).getValue(this.m_Field) instanceof String)) {
                    result.add("Field '" + this.m_Field + "' not of type String!");
                } else {
                    String s = ((Report)report).getStringValue(this.m_Field);
                    boolean pass = this.m_Invert ? !this.m_RegExp.isMatch(s) : this.m_RegExp.isMatch(s);
                    if (!pass) {
                        result.add("'" + s + "' doesn't match '" + this.m_RegExp + "' for field " + this.m_Field);
                    }
                }
            } else {
                result.add("No report available!");
            }
        } else {
            result.add("Data container does not handle reports!");
        }
        return result;
    }
}

