/*
 * Decompiled with CFR 0.152.
 */
package adams.data.spreadsheet;

import adams.core.Utils;
import java.util.ArrayList;

public class SpreadSheetUtils {
    public static String[] split(String s, char delimiter) {
        return SpreadSheetUtils.split(s, delimiter, false);
    }

    public static String[] split(String s, char delimiter, boolean unquote) {
        ArrayList<String> result = new ArrayList<String>();
        StringBuilder current = new StringBuilder();
        boolean escaped = false;
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '\"') {
                escaped = !escaped;
                current.append(c);
                continue;
            }
            if (c == delimiter) {
                if (escaped) {
                    current.append(c);
                    continue;
                }
                if (unquote) {
                    result.add(Utils.unDoubleQuote(current.toString()));
                } else {
                    result.add(current.toString());
                }
                current.delete(0, current.length());
                continue;
            }
            current.append(c);
        }
        if (current.length() > 0) {
            if (unquote) {
                result.add(Utils.unDoubleQuote(current.toString()));
            } else {
                result.add(current.toString());
            }
        }
        return result.toArray(new String[result.size()]);
    }
}

